/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.exec;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.AbstractResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCTrace;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCFakeStatementImpl;
import org.jkiss.dbeaver.model.qm.QMUtils;

public class JDBCResultSetImpl
extends AbstractResultSet<JDBCSession, JDBCStatement>
implements JDBCResultSet {
    private static final Log log = Log.getLog(JDBCResultSetImpl.class);
    private final ResultSet original;
    private JDBCResultSetMetaData metaData;
    private long rowsFetched;
    private long maxRows = -1L;
    private final boolean disableLogging;

    public static JDBCResultSet makeResultSet(@NotNull JDBCSession session, @Nullable JDBCStatement statement, @NotNull ResultSet original, boolean disableLogging) throws SQLException {
        return session.getDataSource().getJdbcFactory().createResultSet(session, statement, original, disableLogging);
    }

    protected JDBCResultSetImpl(@NotNull JDBCSession session, @Nullable JDBCStatement statement, @NotNull ResultSet original, boolean disableLogging) {
        super((DBCSession)session, (DBCStatement)statement);
        if (statement instanceof JDBCFakeStatementImpl) {
            JDBCFakeStatementImpl fake = (JDBCFakeStatementImpl)statement;
            fake.setResultSet(this);
        }
        this.original = original;
        this.disableLogging = disableLogging;
        if (!disableLogging) {
            QMUtils.getDefaultHandler().handleResultSetOpen((DBCResultSet)this);
        }
        if (JDBCTrace.isApiTraceEnabled()) {
            JDBCTrace.dumpResultSetOpen(this.original);
        }
    }

    protected void beforeFetch() {
        ((JDBCSession)this.session).getExecutionContext().lockQueryExecution();
    }

    protected void afterFetch() {
        ((JDBCSession)this.session).getExecutionContext().unlockQueryExecution();
        if (JDBCUtils.LOG_JDBC_WARNINGS) {
            try {
                JDBCUtils.reportWarnings(this.getSession(), this.getWarnings());
            }
            catch (Throwable e) {
                log.debug((Object)("Error reading JDBC warnings: " + e.getMessage()));
            }
        }
    }

    @Override
    public ResultSet getOriginal() {
        return this.original;
    }

    @Override
    public JDBCSession getSession() {
        return (JDBCSession)this.session;
    }

    @Override
    public JDBCStatement getSourceStatement() {
        return (JDBCStatement)this.statement;
    }

    @Override
    public JDBCStatement getStatement() {
        return this.getSourceStatement();
    }

    public Object getAttributeValue(int index) throws DBCException {
        this.checkNotEmpty();
        try {
            return this.original.getObject(index + 1);
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, (DBCExecutionContext)((JDBCSession)this.session).getExecutionContext());
        }
    }

    public Object getAttributeValue(String name) throws DBCException {
        this.checkNotEmpty();
        try {
            return this.original.getObject(name);
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, (DBCExecutionContext)((JDBCSession)this.session).getExecutionContext());
        }
    }

    private void checkNotEmpty() {
        if (this.original == null) {
            throw new IllegalStateException();
        }
    }

    public boolean nextRow() throws DBCException {
        if (this.original == null) {
            return false;
        }
        try {
            return this.next();
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, (DBCExecutionContext)((JDBCSession)this.session).getExecutionContext());
        }
    }

    public boolean moveTo(int position) throws DBCException {
        if (this.original == null) {
            return false;
        }
        try {
            return this.absolute(position);
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, (DBCExecutionContext)((JDBCSession)this.session).getExecutionContext());
        }
    }

    @NotNull
    public JDBCResultSetMetaData getMeta() throws DBCException {
        if (this.metaData == null) {
            try {
                this.metaData = this.createMetaDataImpl();
            }
            catch (SQLException e) {
                throw new DBCException((Throwable)e, (DBCExecutionContext)((JDBCSession)this.session).getExecutionContext());
            }
        }
        return this.metaData;
    }

    @Nullable
    public String getResultSetName() throws DBCException {
        if (this.original == null) {
            return null;
        }
        try {
            return this.original.getCursorName();
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, (DBCExecutionContext)((JDBCSession)this.session).getExecutionContext());
        }
    }

    public Object getFeature(String name) {
        if ("jdbc".equals(name)) {
            return true;
        }
        return super.getFeature(name);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            return this.getMeta();
        }
        catch (DBCException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw new SQLException(e);
        }
    }

    @Override
    public void setMaxRows(long maxRows) {
        this.maxRows = maxRows;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.original == null) {
            return false;
        }
        if (this.maxRows >= 0L && this.rowsFetched >= this.maxRows) {
            return false;
        }
        this.beforeFetch();
        try {
            boolean fetched = this.original.next();
            if (fetched) {
                ++this.rowsFetched;
            }
            if (fetched && JDBCTrace.isApiTraceEnabled()) {
                JDBCTrace.dumpResultSetRow(this.original);
            }
            boolean bl = fetched;
            return bl;
        }
        finally {
            this.afterFetch();
        }
    }

    @Override
    public void close() {
        if (this.original != null) {
            if (!this.disableLogging) {
                QMUtils.getDefaultHandler().handleResultSetClose((DBCResultSet)this, this.rowsFetched);
            }
            try {
                this.original.close();
            }
            catch (SQLException e) {
                log.error((Object)"Can't close result set", (Throwable)e);
            }
        }
        if (this.statement instanceof JDBCFakeStatementImpl) {
            ((JDBCStatement)this.statement).close();
        }
        if (JDBCTrace.isApiTraceEnabled()) {
            JDBCTrace.dumpResultSetClose();
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkNotEmpty();
        return this.original.wasNull();
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkNotEmpty();
        return this.original.getString(columnIndex);
    }

    private static void traceGetValue(int columnIndex, String value) {
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkNotEmpty();
        return this.original.getBoolean(columnIndex);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkNotEmpty();
        return this.original.getByte(columnIndex);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkNotEmpty();
        return this.original.getShort(columnIndex);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkNotEmpty();
        return this.original.getInt(columnIndex);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkNotEmpty();
        return this.original.getLong(columnIndex);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkNotEmpty();
        return this.original.getFloat(columnIndex);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkNotEmpty();
        return this.original.getDouble(columnIndex);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.checkNotEmpty();
        return this.original.getBigDecimal(columnIndex, scale);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkNotEmpty();
        return this.original.getBytes(columnIndex);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.checkNotEmpty();
        return this.original.getDate(columnIndex);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.checkNotEmpty();
        return this.original.getTime(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkNotEmpty();
        return this.original.getTimestamp(columnIndex);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkNotEmpty();
        return this.original.getAsciiStream(columnIndex);
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.checkNotEmpty();
        return this.original.getUnicodeStream(columnIndex);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkNotEmpty();
        return this.original.getBinaryStream(columnIndex);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        this.checkNotEmpty();
        return this.original.getString(columnLabel);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        this.checkNotEmpty();
        return this.original.getBoolean(columnLabel);
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        this.checkNotEmpty();
        return this.original.getByte(columnLabel);
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        this.checkNotEmpty();
        return this.original.getShort(columnLabel);
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        this.checkNotEmpty();
        return this.original.getInt(columnLabel);
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        this.checkNotEmpty();
        return this.original.getLong(columnLabel);
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        this.checkNotEmpty();
        return this.original.getFloat(columnLabel);
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        this.checkNotEmpty();
        return this.original.getDouble(columnLabel);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        this.checkNotEmpty();
        return this.original.getBigDecimal(columnLabel, scale);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        this.checkNotEmpty();
        return this.original.getBytes(columnLabel);
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        this.checkNotEmpty();
        return this.original.getDate(columnLabel);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        this.checkNotEmpty();
        return this.original.getTime(columnLabel);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        this.checkNotEmpty();
        return this.original.getTimestamp(columnLabel);
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        this.checkNotEmpty();
        return this.original.getAsciiStream(columnLabel);
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        this.checkNotEmpty();
        return this.original.getUnicodeStream(columnLabel);
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        this.checkNotEmpty();
        return this.original.getBinaryStream(columnLabel);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkNotEmpty();
        return this.original.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.original == null) {
            return;
        }
        this.original.clearWarnings();
    }

    @Override
    @Nullable
    public String getCursorName() throws SQLException {
        if (this.original == null) {
            return null;
        }
        return this.original.getCursorName();
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkNotEmpty();
        return this.original.getObject(columnIndex);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        this.checkNotEmpty();
        return this.original.getObject(columnLabel);
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        return this.original.findColumn(columnLabel);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return this.original.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.original.getCharacterStream(columnLabel);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.original.getBigDecimal(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.original.getBigDecimal(columnLabel);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.original.isBeforeFirst();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.original.isAfterLast();
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.original.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.original.isLast();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.original.beforeFirst();
    }

    @Override
    public void afterLast() throws SQLException {
        this.original.afterLast();
    }

    @Override
    public boolean first() throws SQLException {
        return this.original.first();
    }

    @Override
    public boolean last() throws SQLException {
        return this.original.last();
    }

    @Override
    public int getRow() throws SQLException {
        return this.original.getRow();
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        return this.original.absolute(row);
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        return this.original.relative(rows);
    }

    @Override
    public boolean previous() throws SQLException {
        return this.original.previous();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.original.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.original.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.original.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.original.getFetchSize();
    }

    @Override
    public int getType() throws SQLException {
        return this.original.getType();
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this.original.getConcurrency();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return this.original.rowUpdated();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return this.original.rowInserted();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return this.original.rowDeleted();
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.original.updateNull(columnIndex);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.original.updateBoolean(columnIndex, x);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.original.updateByte(columnIndex, x);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.original.updateShort(columnIndex, x);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.original.updateInt(columnIndex, x);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.original.updateLong(columnIndex, x);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.original.updateFloat(columnIndex, x);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.original.updateDouble(columnIndex, x);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.original.updateBigDecimal(columnIndex, x);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.original.updateString(columnIndex, x);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.original.updateBytes(columnIndex, x);
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.original.updateDate(columnIndex, x);
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.original.updateTime(columnIndex, x);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.original.updateTimestamp(columnIndex, x);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.original.updateAsciiStream(columnIndex, x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.original.updateBinaryStream(columnIndex, x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.original.updateCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        this.original.updateObject(columnIndex, x, scaleOrLength);
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.original.updateObject(columnIndex, x);
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        this.original.updateNull(columnLabel);
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        this.original.updateBoolean(columnLabel, x);
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        this.original.updateByte(columnLabel, x);
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        this.original.updateShort(columnLabel, x);
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        this.original.updateInt(columnLabel, x);
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        this.original.updateLong(columnLabel, x);
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        this.original.updateFloat(columnLabel, x);
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        this.original.updateDouble(columnLabel, x);
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        this.original.updateBigDecimal(columnLabel, x);
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        this.original.updateString(columnLabel, x);
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        this.original.updateBytes(columnLabel, x);
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        this.original.updateDate(columnLabel, x);
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        this.original.updateTime(columnLabel, x);
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        this.original.updateTimestamp(columnLabel, x);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.original.updateAsciiStream(columnLabel, x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.original.updateBinaryStream(columnLabel, x, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        this.original.updateCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        this.original.updateObject(columnLabel, x, scaleOrLength);
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        this.original.updateObject(columnLabel, x);
    }

    @Override
    public void insertRow() throws SQLException {
        this.original.insertRow();
    }

    @Override
    public void updateRow() throws SQLException {
        this.original.updateRow();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.original.deleteRow();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.original.refreshRow();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.original.cancelRowUpdates();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.original.moveToInsertRow();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.original.moveToCurrentRow();
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        return this.original.getObject(columnIndex, map);
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        return this.original.getRef(columnIndex);
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        return this.original.getBlob(columnIndex);
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        return this.original.getClob(columnIndex);
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        return this.original.getArray(columnIndex);
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        return this.original.getObject(columnLabel, map);
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        return this.original.getRef(columnLabel);
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.original.getBlob(columnLabel);
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return this.original.getClob(columnLabel);
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return this.original.getArray(columnLabel);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.original.getDate(columnIndex, cal);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.original.getDate(columnLabel, cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.original.getTime(columnIndex, cal);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.original.getTime(columnLabel, cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.original.getTimestamp(columnIndex, cal);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.original.getTimestamp(columnLabel, cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return this.original.getURL(columnIndex);
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return this.original.getURL(columnLabel);
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.original.updateRef(columnIndex, x);
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        this.original.updateRef(columnLabel, x);
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.original.updateBlob(columnIndex, x);
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        this.original.updateBlob(columnLabel, x);
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.original.updateClob(columnIndex, x);
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        this.original.updateClob(columnLabel, x);
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.original.updateArray(columnIndex, x);
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        this.original.updateArray(columnLabel, x);
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        return this.original.getRowId(columnIndex);
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return this.original.getRowId(columnLabel);
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        this.original.updateRowId(columnIndex, x);
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        this.original.updateRowId(columnLabel, x);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.original.getHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.original.isClosed();
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        this.original.updateNString(columnIndex, nString);
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        this.original.updateNString(columnLabel, nString);
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.original.updateNClob(columnIndex, nClob);
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        this.original.updateNClob(columnLabel, nClob);
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        return this.original.getNClob(columnIndex);
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return this.original.getNClob(columnLabel);
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return this.original.getSQLXML(columnIndex);
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return this.original.getSQLXML(columnLabel);
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.original.updateSQLXML(columnIndex, xmlObject);
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.original.updateSQLXML(columnLabel, xmlObject);
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.original.getNString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.original.getNString(columnLabel);
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.original.getNCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.original.getNCharacterStream(columnLabel);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.original.updateNCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.original.updateNCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.original.updateAsciiStream(columnIndex, x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.original.updateBinaryStream(columnIndex, x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.original.updateCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.original.updateAsciiStream(columnLabel, x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.original.updateBinaryStream(columnLabel, x, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.original.updateCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.original.updateBlob(columnIndex, inputStream, length);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.original.updateBlob(columnLabel, inputStream, length);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.original.updateClob(columnIndex, reader, length);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.original.updateClob(columnLabel, reader, length);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.original.updateNClob(columnIndex, reader, length);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.original.updateNClob(columnLabel, reader, length);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.original.updateNCharacterStream(columnIndex, x);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.original.updateNCharacterStream(columnLabel, reader);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.original.updateAsciiStream(columnIndex, x);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.original.updateBinaryStream(columnIndex, x);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.original.updateCharacterStream(columnIndex, x);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.original.updateAsciiStream(columnLabel, x);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.original.updateBinaryStream(columnLabel, x);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.original.updateCharacterStream(columnLabel, reader);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.original.updateBlob(columnIndex, inputStream);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.original.updateBlob(columnLabel, inputStream);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.original.updateClob(columnIndex, reader);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.original.updateClob(columnLabel, reader);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.original.updateNClob(columnIndex, reader);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.original.updateNClob(columnLabel, reader);
    }

    @Override
    @Nullable
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        return this.original.getObject(columnIndex, type);
    }

    @Override
    @Nullable
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.original.getObject(columnLabel, type);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.original.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.original.isWrapperFor(iface);
    }

    protected JDBCResultSetMetaData createMetaDataImpl() throws SQLException {
        return ((JDBCSession)this.session).getDataSource().getJdbcFactory().createResultSetMetaData(this);
    }
}

