/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.tasks;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableBase;
import org.jkiss.dbeaver.ext.mysql.tasks.MySQLToolTableRepairSettings;
import org.jkiss.dbeaver.ext.mysql.tasks.MySQLToolWithStatus;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;

public class MySQLToolTableRepair
extends MySQLToolWithStatus<MySQLTableBase, MySQLToolTableRepairSettings> {
    @NotNull
    public MySQLToolTableRepairSettings createToolSettings() {
        return new MySQLToolTableRepairSettings();
    }

    public void generateObjectQueries(DBCSession session, MySQLToolTableRepairSettings settings, List<DBEPersistAction> queries, MySQLTableBase object) throws DBCException {
        String sql = "REPAIR TABLE " + object.getFullyQualifiedName(DBPEvaluationContext.DDL);
        boolean isQuick = settings.isQuick();
        boolean isExtended = settings.isExtended();
        boolean useFRM = settings.isUseFRM();
        if (isQuick) {
            sql = sql + " QUICK";
        }
        if (isExtended) {
            sql = sql + " EXTENDED";
        }
        if (useFRM) {
            sql = sql + " USE_FRM";
        }
        queries.add((DBEPersistAction)new SQLDatabasePersistAction(sql));
    }
}

