/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.persist.evolve.Converter;
import com.sleepycat.persist.impl.Accessor;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.Reader;
import com.sleepycat.persist.impl.RefreshException;
import com.sleepycat.persist.model.EntityModel;
import com.sleepycat.persist.raw.RawObject;

public class ConverterReader
implements Reader {
    private static final long serialVersionUID = -305788321064984348L;
    private Converter converter;
    private transient Format oldFormat;

    ConverterReader(Converter converter) {
        this.converter = converter;
    }

    @Override
    public void initializeReader(Catalog catalog, EntityModel entityModel, int n, Format format) {
        this.oldFormat = format;
    }

    @Override
    public Object newInstance(EntityInput entityInput, boolean bl) throws RefreshException {
        return this.oldFormat.newInstance(entityInput, true);
    }

    @Override
    public void readPriKey(Object object, EntityInput entityInput, boolean bl) throws RefreshException {
        this.oldFormat.readPriKey(object, entityInput, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object readObject(Object object, EntityInput entityInput, boolean bl) throws RefreshException {
        Catalog catalog = entityInput.getCatalog();
        boolean bl2 = entityInput.setRawAccess(true);
        try {
            object = this.oldFormat.readObject(object, entityInput, true);
        }
        finally {
            entityInput.setRawAccess(bl2);
        }
        object = this.converter.getConversion().convert(object);
        if (!bl && object instanceof RawObject) {
            object = catalog.convertRawObject((RawObject)object, null);
        }
        return object;
    }

    @Override
    public Accessor getAccessor(boolean bl) {
        return this.oldFormat.getAccessor(bl);
    }
}

