/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db.internal;

import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.internal.db_javaJNI;

public class DbChannel {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected DbChannel(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(DbChannel dbChannel) {
        return dbChannel == null ? 0L : dbChannel.swigCPtr;
    }

    synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                throw new UnsupportedOperationException("C++ destructor does not have public access");
            }
            this.swigCPtr = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(int n) throws DatabaseException {
        try {
            this.close0(n);
        }
        finally {
            this.swigCPtr = 0L;
        }
    }

    void close0(int n) {
        db_javaJNI.DbChannel_close0(this.swigCPtr, this, n);
    }

    public void send_repmsg(DatabaseEntry[] databaseEntryArray, int n, int n2) throws DatabaseException {
        db_javaJNI.DbChannel_send_repmsg(this.swigCPtr, this, databaseEntryArray, n, n2);
    }

    public void send_request(DatabaseEntry[] databaseEntryArray, int n, DatabaseEntry databaseEntry, long l, int n2) throws DatabaseException {
        db_javaJNI.DbChannel_send_request(this.swigCPtr, this, databaseEntryArray, n, databaseEntry, l, n2);
    }

    public void set_timeout(long l) throws DatabaseException {
        db_javaJNI.DbChannel_set_timeout(this.swigCPtr, this, l);
    }
}

