/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

public final class ReplicationConfig
implements Cloneable {
    public static final ReplicationConfig BULK = new ReplicationConfig("BULK", 16);
    public static final ReplicationConfig DELAYCLIENT = new ReplicationConfig("DELAYCLIENT", 32);
    public static final ReplicationConfig AUTOINIT = new ReplicationConfig("AUTOINIT", 4);
    public static final ReplicationConfig NOWAIT = new ReplicationConfig("NOWAIT", 256);
    public static final ReplicationConfig STRICT_2SITE = new ReplicationConfig("STRICT_2SITE", 1);
    public static final ReplicationConfig ELECTIONS = new ReplicationConfig("ELECTIONS", 2);
    public static final ReplicationConfig LEASE = new ReplicationConfig("LEASE", 128);
    private String configName;
    private int flag;

    static ReplicationConfig fromInt(int n) {
        switch (n) {
            case 16: {
                return BULK;
            }
            case 32: {
                return DELAYCLIENT;
            }
            case 4: {
                return AUTOINIT;
            }
            case 256: {
                return NOWAIT;
            }
            case 1: {
                return STRICT_2SITE;
            }
            case 2: {
                return ELECTIONS;
            }
            case 128: {
                return LEASE;
            }
        }
        throw new IllegalArgumentException("Unknown replication config: " + n);
    }

    private ReplicationConfig(String string, int n) {
        this.configName = string;
        this.flag = n;
    }

    int getFlag() {
        return this.flag;
    }

    public String toString() {
        return "ReplicationConfig." + this.configName;
    }
}

