/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

public final class RegionResourceType {
    public static final RegionResourceType LOCK = new RegionResourceType("LOCK", 1);
    public static final RegionResourceType LOCK_OBJECT = new RegionResourceType("LOCK_OBJECT", 2);
    public static final RegionResourceType LOCKER = new RegionResourceType("LOCKER", 3);
    public static final RegionResourceType LOG_ID = new RegionResourceType("LOG_ID", 4);
    public static final RegionResourceType TRANSACTION = new RegionResourceType("TRANSACTION", 5);
    public static final RegionResourceType THREAD = new RegionResourceType("THREAD", 6);
    private final String typeName;
    private final int flag;

    static RegionResourceType fromFlag(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return LOCK;
            }
            case 2: {
                return LOCK_OBJECT;
            }
            case 3: {
                return LOCKER;
            }
            case 4: {
                return LOG_ID;
            }
            case 5: {
                return TRANSACTION;
            }
            case 6: {
                return THREAD;
            }
        }
        throw new IllegalArgumentException("Unknown region memory type: " + n);
    }

    private RegionResourceType(String string, int n) {
        this.typeName = string;
        this.flag = n;
    }

    public String toString() {
        return "RegionResourceType." + this.typeName;
    }

    int getFlag() {
        return this.flag;
    }
}

