/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.Cursor;
import com.sleepycat.db.CursorConfig;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.LockMode;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.db.SecondaryDatabase;
import com.sleepycat.db.internal.Dbc;

public class SecondaryCursor
extends Cursor {
    SecondaryCursor(SecondaryDatabase secondaryDatabase, Dbc dbc, CursorConfig cursorConfig) throws DatabaseException {
        super(secondaryDatabase, dbc, cursorConfig);
    }

    public SecondaryDatabase getSecondaryDatabase() {
        return (SecondaryDatabase)super.getDatabase();
    }

    @Override
    public Cursor dup(boolean bl) throws DatabaseException {
        return this.dupSecondary(bl);
    }

    public SecondaryCursor dupSecondary(boolean bl) throws DatabaseException {
        return new SecondaryCursor(this.getSecondaryDatabase(), this.dbc.dup(bl ? 23 : 0), this.config);
    }

    public OperationStatus getCurrent(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.pget(databaseEntry, databaseEntry2, databaseEntry3, 6 | LockMode.getFlag(lockMode) | (databaseEntry3 == null ? 0 : databaseEntry3.getMultiFlag())));
    }

    public OperationStatus getFirst(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.pget(databaseEntry, databaseEntry2, databaseEntry3, 7 | LockMode.getFlag(lockMode) | (databaseEntry3 == null ? 0 : databaseEntry3.getMultiFlag())));
    }

    public OperationStatus getLast(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.pget(databaseEntry, databaseEntry2, databaseEntry3, 0xF | LockMode.getFlag(lockMode) | (databaseEntry3 == null ? 0 : databaseEntry3.getMultiFlag())));
    }

    public OperationStatus getNext(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.pget(databaseEntry, databaseEntry2, databaseEntry3, 0x10 | LockMode.getFlag(lockMode) | (databaseEntry3 == null ? 0 : databaseEntry3.getMultiFlag())));
    }

    public OperationStatus getNextDup(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.pget(databaseEntry, databaseEntry2, databaseEntry3, 0x11 | LockMode.getFlag(lockMode) | (databaseEntry3 == null ? 0 : databaseEntry3.getMultiFlag())));
    }

    public OperationStatus getNextNoDup(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.pget(databaseEntry, databaseEntry2, databaseEntry3, 0x12 | LockMode.getFlag(lockMode) | (databaseEntry3 == null ? 0 : databaseEntry3.getMultiFlag())));
    }

    public OperationStatus getPrev(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.pget(databaseEntry, databaseEntry2, databaseEntry3, 0x18 | LockMode.getFlag(lockMode) | (databaseEntry3 == null ? 0 : databaseEntry3.getMultiFlag())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus getPrevDup(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, LockMode lockMode) throws DatabaseException {
        Object object = this.dbc.dup(23);
        try {
            Object object2;
            int n = ((Dbc)object).get(DatabaseEntry.IGNORE, DatabaseEntry.IGNORE, 0x18 | LockMode.getFlag(lockMode));
            if (n == 0) {
                object2 = ((Dbc)object).dup(23);
                try {
                    n = ((Dbc)object2).get(DatabaseEntry.IGNORE, DatabaseEntry.IGNORE, 0x11 | LockMode.getFlag(lockMode));
                }
                finally {
                    ((Dbc)object2).close();
                }
            }
            if (n == 0) {
                n = ((Dbc)object).pget(databaseEntry, databaseEntry2, databaseEntry3, 6 | LockMode.getFlag(lockMode) | (databaseEntry3 == null ? 0 : databaseEntry3.getMultiFlag()));
            }
            if (n == 0) {
                object2 = this.dbc;
                this.dbc = object;
                object = object2;
            }
            object2 = OperationStatus.fromInt(n);
            return object2;
        }
        finally {
            ((Dbc)object).close();
        }
    }

    public OperationStatus getPrevNoDup(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.pget(databaseEntry, databaseEntry2, databaseEntry3, 0x1A | LockMode.getFlag(lockMode) | (databaseEntry3 == null ? 0 : databaseEntry3.getMultiFlag())));
    }

    public OperationStatus getRecordNumber(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.pget(DatabaseEntry.IGNORE, databaseEntry, databaseEntry2, 0xB | LockMode.getFlag(lockMode)));
    }

    public OperationStatus getSearchKey(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.pget(databaseEntry, databaseEntry2, databaseEntry3, 0x1B | LockMode.getFlag(lockMode) | (databaseEntry3 == null ? 0 : databaseEntry3.getMultiFlag())));
    }

    public OperationStatus getSearchKeyRange(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.pget(databaseEntry, databaseEntry2, databaseEntry3, 0x1C | LockMode.getFlag(lockMode) | (databaseEntry3 == null ? 0 : databaseEntry3.getMultiFlag())));
    }

    public OperationStatus getSearchBoth(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.pget(databaseEntry, databaseEntry2, databaseEntry3, 8 | LockMode.getFlag(lockMode) | (databaseEntry3 == null ? 0 : databaseEntry3.getMultiFlag())));
    }

    public OperationStatus getSearchBothRange(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.pget(databaseEntry, databaseEntry2, databaseEntry3, 0xA | LockMode.getFlag(lockMode) | (databaseEntry3 == null ? 0 : databaseEntry3.getMultiFlag())));
    }

    public OperationStatus getSearchRecordNumber(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.pget(databaseEntry, databaseEntry2, databaseEntry3, 0x1D | LockMode.getFlag(lockMode) | (databaseEntry3 == null ? 0 : databaseEntry3.getMultiFlag())));
    }
}

