/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.array;

import org.basex.query.QueryContext;
import org.basex.query.expr.Expr;
import org.basex.query.value.Value;
import org.basex.query.value.array.ArrBuilder;
import org.basex.query.value.array.ItemArrayBuilder;
import org.basex.query.value.array.TreeArrayBuilder;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.SeqType;

public final class ArrayBuilder {
    private final QueryContext qc;
    private ArrBuilder array;
    private final long capacity;
    private Value single;

    public ArrayBuilder() {
        this(null);
    }

    public ArrayBuilder(QueryContext qc) {
        this(qc, -1L);
    }

    public ArrayBuilder(QueryContext qc, long capacity) {
        this.qc = qc;
        this.capacity = qc != null ? capacity : Integer.MIN_VALUE;
    }

    public ArrayBuilder add(Value value) {
        Value sngl = this.single;
        if (sngl != null) {
            this.single = null;
            this.array = this.capacity != Integer.MIN_VALUE && sngl.size() == 1L && value.size() == 1L ? new ItemArrayBuilder(this.qc, this.capacity) : new TreeArrayBuilder();
            this.add(sngl);
        }
        if (this.array != null) {
            this.array = this.array.add(value);
        } else {
            this.single = value;
        }
        return this;
    }

    public XQArray array() {
        return this.array(SeqType.ARRAY);
    }

    public XQArray array(ArrayType type) {
        try {
            XQArray xQArray = this.array != null ? this.array.array(type) : (this.single != null ? XQArray.get(this.single) : XQArray.empty());
            return xQArray;
        }
        finally {
            this.array = null;
            this.single = null;
        }
    }

    public XQArray array(Expr expr) {
        return expr != null ? this.array((ArrayType)expr.seqType().type) : this.array();
    }
}

