/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives.node;

import org.basex.data.Data;
import org.basex.data.DataClip;
import org.basex.data.MemData;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.up.NamePool;
import org.basex.query.up.primitives.UpdateType;
import org.basex.query.up.primitives.node.NodeUpdate;
import org.basex.query.util.DataBuilder;
import org.basex.query.util.list.ANodeList;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FTxt;
import org.basex.query.value.type.NodeType;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

abstract class NodeCopy
extends NodeUpdate {
    ANodeList nodes;
    DataClip insseq;

    NodeCopy(UpdateType type, int pre, Data data, InputInfo info, ANodeList nodes) {
        super(type, pre, data, info);
        this.nodes = nodes;
    }

    @Override
    public final void prepare(MemData memData, QueryContext qc) throws QueryException {
        ANodeList list = NodeCopy.mergeNodeCacheText(this.nodes);
        this.nodes = null;
        int start = memData.meta.size;
        new DataBuilder(memData, qc).build(list);
        this.insseq = new DataClip(memData, start, memData.meta.size, list.size());
        this.checkLimit(this.insseq.size());
    }

    final void add(NamePool pool) {
        Data d = this.insseq.data;
        int s = this.insseq.start;
        int e = this.insseq.end;
        for (int p = s; p < e; ++p) {
            int k = d.kind(p);
            if (k != 3 && k != 1) continue;
            if (p > s && d.parent(p, k) >= s) break;
            byte[][] qname = d.qname(p, k);
            pool.add(new QNm(qname[0], qname[1]), ANode.type(k));
        }
    }

    private static ANodeList mergeNodeCacheText(ANodeList nl) {
        int ns = nl.size();
        if (ns == 0) {
            return nl;
        }
        ANodeList s = new ANodeList(ns);
        ANode n = (ANode)nl.get(0);
        int c = 0;
        while (c < ns) {
            if (n.type == NodeType.TEXT) {
                TokenBuilder tb = new TokenBuilder();
                while (n.type == NodeType.TEXT) {
                    tb.add(n.string());
                    if (++c == ns) break;
                    n = (ANode)nl.get(c);
                }
                s.add(new FTxt(tb.finish()));
                continue;
            }
            s.add(n);
            if (++c >= ns) continue;
            n = (ANode)nl.get(c);
        }
        return s;
    }

    @Override
    public int size() {
        return this.insseq.fragments;
    }

    public final String toString() {
        return Util.className(this) + "[], " + (this.insseq != null ? this.size() : this.nodes.size()) + " ops]";
    }
}

