/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arith;
import org.basex.query.expr.Calc;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.SingletonSeq;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.util.Util;

public final class FnReplicate
extends StandardFunc {
    @Override
    public Value value(QueryContext qc) throws QueryException {
        boolean once;
        Expr input = this.arg(0);
        long count = this.toLong(this.arg(1).atomItem(qc, this.info), 0L);
        if (count == 0L) {
            return Empty.VALUE;
        }
        if (count == 1L) {
            return input.value(qc);
        }
        boolean bl = once = input instanceof Value || !this.defined(2) || !this.toBooleanOrFalse(this.arg(2), qc);
        if (once) {
            return SingletonSeq.get(input.value(qc), count);
        }
        ValueBuilder vb = new ValueBuilder(qc, this.size());
        for (long c = 0L; c < count; ++c) {
            vb.add(input.value(qc));
        }
        return vb.value(this);
    }

    @Override
    public Iter iter(final QueryContext qc) throws QueryException {
        final Expr input = this.arg(0);
        final long count = this.toLong(this.arg(1), qc);
        if (count <= 0L) {
            return Empty.ITER;
        }
        if (count == 1L) {
            return input.iter(qc);
        }
        boolean repeat = this.toBooleanOrFalse(this.arg(2), qc);
        if (!repeat) {
            return SingletonSeq.get(input.value(qc), count).iter();
        }
        if (input.seqType().one()) {
            return new Iter(){
                long c;
                {
                    this.c = count;
                }

                @Override
                public Item next() throws QueryException {
                    return --this.c >= 0L ? input.item(qc, FnReplicate.this.info) : null;
                }

                @Override
                public Item get(long i) throws QueryException {
                    return input.item(qc, FnReplicate.this.info);
                }

                @Override
                public long size() {
                    return count;
                }
            };
        }
        return new Iter(){
            long c;
            Iter iter;
            {
                this.c = count;
            }

            @Override
            public Item next() throws QueryException {
                while (true) {
                    Item item;
                    if (this.iter == null) {
                        if (--this.c < 0L) {
                            return null;
                        }
                        this.iter = input.iter(qc);
                    }
                    if ((item = this.iter.next()) != null) {
                        return item;
                    }
                    this.iter = null;
                }
            }
        };
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Expr input = this.arg(0);
        Expr count = this.arg(1);
        boolean single = this.singleEval(true);
        if (Function.REPLICATE.is(input) && single == ((FnReplicate)input).singleEval(true)) {
            ExprList args = (ExprList)((Object)new ExprList(2L).add(input.arg(0)));
            args.add(new Arith(this.info, count, input.arg(1), Calc.MULTIPLY).optimize(cc));
            if (!single) {
                args.add(Bln.TRUE);
            }
            return cc.function(Function.REPLICATE, this.info, (Expr[])args.finish());
        }
        long sz = -1L;
        long c = -1L;
        if (count instanceof Value) {
            c = this.toLong(count, cc.qc);
            if (c == 0L) {
                return Empty.VALUE;
            }
            if (c == 1L) {
                return input;
            }
            sz = input.size();
            if (sz != -1L) {
                long l = sz = c > 1L && Util.inBounds(sz, c) ? sz * c : -1L;
            }
        }
        if (input == Empty.VALUE || sz == 0L && single) {
            return input;
        }
        Occ occ = c > 0L ? Occ.ONE_OR_MORE : Occ.ZERO_OR_MORE;
        this.exprType.assign(input.seqType().union(occ), sz).data(input);
        return this;
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        long count;
        Expr input = mode.oneOf(CompileContext.Simplify.STRING, CompileContext.Simplify.NUMBER, CompileContext.Simplify.DATA, CompileContext.Simplify.COUNT, CompileContext.Simplify.DISTINCT) ? this.arg(0).simplifyFor(mode, cc) : this.arg(0);
        Expr expr = this.arg(1);
        if (expr instanceof Itr) {
            Itr itr = (Itr)expr;
            v0 = itr.itr();
        } else {
            v0 = count = -1L;
        }
        if (count > 0L && (this.singleEval(true) || !input.has(Flag.NDT)) && (mode == CompileContext.Simplify.DISTINCT || mode == CompileContext.Simplify.PREDICATE && input.seqType().instanceOf(SeqType.NODE_ZM))) {
            return cc.simplify(this, input, mode);
        }
        if (input != this.arg(0)) {
            Expr[] args = (Expr[])this.exprs.clone();
            args[0] = input;
            return cc.function(Function.REPLICATE, this.info, args);
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean values(boolean limit, CompileContext cc) {
        if (!super.values(false, cc)) return false;
        Expr expr = this.arg(1);
        if (!(expr instanceof Itr)) return false;
        Itr itr = (Itr)expr;
        if (!Util.inBounds(this.arg(0).size(), itr.itr())) return false;
        return true;
    }

    public boolean singleEval(boolean zero) {
        return this.arg(0) instanceof Value || (!this.defined(2) || this.arg(2) == Bln.FALSE) && (zero || this.arg(1) instanceof Itr);
    }
}

