/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.db;

import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.index.IndexAccess;
import org.basex.query.expr.path.NamePart;
import org.basex.query.expr.path.NameTest;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.NodeType;
import org.basex.util.Token;

abstract class DbAccessFn
extends StandardFunc {
    static final QNm Q_BACKUP = new QNm("backup");
    static final QNm Q_SIZE = new QNm("size");
    static final QNm Q_DATE = new QNm("date");
    static final QNm Q_DATABASE = new QNm("database");
    static final QNm Q_COMMENT = new QNm("comment");
    static final QNm Q_RESOURCE = new QNm("resource");
    static final QNm Q_RESOURCES = new QNm("resources");
    static final QNm Q_CONTENT_TYPE = new QNm("content-type");
    static final QNm Q_MODIFIED_DATE = new QNm("modified-date");
    static final QNm Q_DIR = new QNm("dir");
    static final QNm Q_TYPE = new QNm("type");
    static final QNm Q_PATH = new QNm("path");
    static final QNm Q_SYSTEM = new QNm("system");

    DbAccessFn() {
    }

    final String toDbPath(Expr expr, QueryContext qc) throws QueryException {
        return this.toDbPath(this.toString(expr, qc));
    }

    final String toDbPath(String path) throws QueryException {
        String norm = MetaData.normPath(path);
        if (norm == null) {
            throw QueryError.DB_PATH_X.get(this.info, path);
        }
        return norm;
    }

    protected final String toName(Expr expr, boolean empty, QueryContext qc) throws QueryException {
        return this.toName(expr, empty, QueryError.DB_NAME_X, qc);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return this.dataLock(this.arg(0), false, visitor) && super.accept(visitor);
    }

    final Iter attribute(Expr expr, Data data, IndexAccess ia, final QueryContext qc) throws QueryException {
        if (expr == Empty.UNDEFINED) {
            return ia.iter(qc);
        }
        byte[] name = this.toToken(expr, qc);
        QNm qnm = qc.shared.qName(name, this.sc().ns.uri(Token.prefix(name)));
        final NameTest nt = new NameTest(qnm, NamePart.FULL, NodeType.ATTRIBUTE, this.sc().elemNS);
        if (nt.optimize(data) == null) {
            return Empty.ITER;
        }
        final Iter iter = ia.iter(qc);
        return new Iter(){

            @Override
            public Item next() throws QueryException {
                Item item;
                while ((item = qc.next(iter)) != null && !nt.matches(item)) {
                }
                return item;
            }
        };
    }
}

