/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.constr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.List;
import org.basex.query.expr.constr.CItemArray;
import org.basex.query.func.Function;
import org.basex.query.value.array.ArrayBuilder;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.Checks;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjectMap;

public final class CArray
extends Arr {
    public CArray(InputInfo info, Expr ... exprs) {
        super(info, SeqType.ARRAY_O, exprs);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        int el = this.exprs.length;
        if (el == 0) {
            return XQArray.empty();
        }
        if (el == 1) {
            return cc.replaceWith(this, cc.function(Function._UTIL_ARRAY_MEMBER, this.info, this.exprs));
        }
        if (((Checks<Expr>)expr -> expr.seqType().one()).all((Expr[])this.exprs)) {
            return cc.replaceWith(this, new CItemArray(this.info, List.get(cc, this.info, this.exprs)).optimize(cc));
        }
        this.exprType.assign(ArrayType.get(SeqType.union(this.exprs, true)));
        return this.values(false, cc) ? cc.preEval(this) : this;
    }

    @Override
    public XQArray item(QueryContext qc, InputInfo ii) throws QueryException {
        ArrayBuilder ab = new ArrayBuilder(qc);
        for (Expr expr : this.exprs) {
            ab.add(expr.value(qc));
        }
        return ab.array(this);
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Expr expr = this;
        if (mode.oneOf(CompileContext.Simplify.NUMBER, CompileContext.Simplify.DATA)) {
            expr = List.get(cc, this.info, this.simplifyAll(mode, cc));
        }
        return cc.simplify(this, expr, mode);
    }

    @Override
    public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this.copyType(new CArray(this.info, CArray.copyAll((CompileContext)cc, vm, (Expr[])this.exprs)));
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof CArray && super.equals(obj);
    }

    @Override
    public String description() {
        return "squared array constructor";
    }

    @Override
    public void toString(QueryString qs) {
        qs.token("[ ").tokens(this.exprs, ", ").token(" ]");
    }
}

