/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.basex.index.IndexEntry;
import org.basex.util.Token;

public final class IndexCache {
    private final ReferenceQueue<IndexEntry> queue = new ReferenceQueue();
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock(true);
    private BucketEntry[] buckets = new BucketEntry[8];
    private int size;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexEntry get(byte[] key) {
        int hash = Token.hashCode(key);
        this.rwl.readLock().lock();
        try {
            int i = IndexCache.indexFor(hash, this.buckets.length);
            BucketEntry e = this.buckets[i];
            while (e != null) {
                IndexEntry entry = (IndexEntry)e.get();
                if (entry != null && e.hash == hash && Token.eq(entry.key, key)) {
                    IndexEntry indexEntry = entry;
                    return indexEntry;
                }
                e = e.next;
            }
        }
        finally {
            this.rwl.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexEntry add(byte[] key, int count, long offset) {
        int hash = Token.hashCode(key);
        this.rwl.writeLock().lock();
        try {
            BucketEntry current;
            this.purge();
            int i = IndexCache.indexFor(hash, this.buckets.length);
            BucketEntry prev = current = this.buckets[i];
            while (current != null) {
                BucketEntry next = current.next;
                IndexEntry entry = (IndexEntry)current.get();
                if (entry == null) {
                    this.delete(i, current, prev, next);
                } else if (current.hash == hash && Token.eq(entry.key, key)) {
                    IndexCache.update(entry, count, offset);
                    IndexEntry indexEntry = entry;
                    return indexEntry;
                }
                prev = current;
                current = next;
            }
            IndexEntry entry = new IndexEntry(key, count, offset);
            this.add(i, hash, entry);
            IndexEntry indexEntry = entry;
            return indexEntry;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(byte[] key) {
        int hash = Token.hashCode(key);
        this.rwl.writeLock().lock();
        try {
            BucketEntry e;
            this.purge();
            int i = IndexCache.indexFor(hash, this.buckets.length);
            BucketEntry prev = e = this.buckets[i];
            while (e != null) {
                BucketEntry next = e.next;
                IndexEntry entry = (IndexEntry)e.get();
                if (entry == null) {
                    this.delete(i, e, prev, next);
                } else if (e.hash == hash && Token.eq(entry.key, key)) {
                    this.delete(i, e, prev, next);
                    break;
                }
                prev = e;
                e = next;
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    private void purge() {
        Reference<IndexEntry> x;
        block0: while ((x = this.queue.poll()) != null) {
            BucketEntry prev;
            BucketEntry e = (BucketEntry)x;
            int i = IndexCache.indexFor(e.hash, this.buckets.length);
            BucketEntry p = prev = this.buckets[i];
            while (p != null) {
                BucketEntry next = p.next;
                if (p == e) {
                    this.delete(i, e, prev, next);
                    continue block0;
                }
                prev = p;
                p = next;
            }
        }
    }

    private void add(int i, int hash, IndexEntry entry) {
        this.buckets[i] = new BucketEntry(hash, this.buckets[i], entry, this.queue);
        if (++this.size == this.buckets.length) {
            this.rehash();
        }
    }

    private static void update(IndexEntry entry, int size, long offset) {
        entry.size = size;
        entry.offset = offset;
    }

    private void delete(int i, BucketEntry e, BucketEntry p, BucketEntry n) {
        if (p == e) {
            this.buckets[i] = n;
        } else {
            p.next = n;
        }
        e.next = null;
        --this.size;
    }

    private void rehash() {
        this.purge();
        int newSize = this.size << 1;
        BucketEntry[] tmp = new BucketEntry[newSize];
        for (BucketEntry e : this.buckets) {
            this.buckets[i] = null;
            while (e != null) {
                BucketEntry next = e.next;
                int p = IndexCache.indexFor(e.hash, tmp.length);
                e.next = tmp[p];
                tmp[p] = e;
                e = next;
            }
        }
        this.buckets = tmp;
    }

    private static int indexFor(int h, int n) {
        return h & n - 1;
    }

    private static final class BucketEntry
    extends SoftReference<IndexEntry> {
        final int hash;
        BucketEntry next;

        BucketEntry(int h, BucketEntry n, IndexEntry v, ReferenceQueue<IndexEntry> rq) {
            super(v, rq);
            this.hash = h;
            this.next = n;
        }
    }
}

