/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core.xqitem;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Properties;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xquery.XQException;
import net.xqj.core.Factory;
import net.xqj.core.XQToolkit;
import net.xqj.core.exception.XQExceptionImpl;
import net.xqj.core.util.StringWriter;
import net.xqj.core.xqitem.XQItemBase;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public class DeferredXMLXQItem
extends XQItemBase
implements Cloneable {
    private static final int INPUTSTREAM = 0;
    private static final int READER = 1;
    private static final int SOURCE = 2;
    private int inputType;
    private InputStream inputStream;
    private Reader reader;
    private Source source;
    private String uri;

    private DeferredXMLXQItem(Source source) throws XQException {
        XQToolkit.nullValueTest(source, "Source", "XQJDX001");
        this.setSource(source);
    }

    private DeferredXMLXQItem(Reader reader, String uri) throws XQException {
        XQToolkit.nullValueTest(reader, "Reader", "XQJDX002");
        this.setReader(reader, uri);
    }

    private DeferredXMLXQItem(InputStream in, String uri) throws XQException {
        XQToolkit.nullValueTest(in, "InputStream", "XQJDX003");
        this.setInputstream(in, uri);
    }

    static final DeferredXMLXQItem newInstance(Source source) throws XQException {
        return new DeferredXMLXQItem(source);
    }

    static final DeferredXMLXQItem newInstance(Reader reader, String uri) throws XQException {
        return new DeferredXMLXQItem(reader, uri);
    }

    static final DeferredXMLXQItem newInstance(InputStream in, String uri) throws XQException {
        return new DeferredXMLXQItem(in, uri);
    }

    public void setSource(Source source) {
        this.inputType = 2;
        this.source = source;
    }

    private Source getSource() throws XQException {
        Source jaxpSource = null;
        switch (this.inputType) {
            case 0: {
                jaxpSource = Factory.newSource(this.inputStream, this.uri);
                break;
            }
            case 1: {
                jaxpSource = Factory.newSource(this.reader, this.uri);
                break;
            }
            case 2: {
                jaxpSource = this.source;
            }
        }
        return jaxpSource;
    }

    public void setReader(Reader reader, String uri) {
        this.inputType = 1;
        this.reader = reader;
        this.uri = uri;
    }

    public void setInputstream(InputStream in, String uri) {
        this.inputType = 0;
        this.inputStream = in;
        this.uri = uri;
    }

    @Override
    public Node getNode() throws XQException {
        DOMResult result = new DOMResult();
        this.writeItemToResult(result);
        return ((Document)result.getNode()).getDocumentElement();
    }

    @Override
    public Object getObject() throws XQException {
        return this.getNode();
    }

    @Override
    public XMLStreamReader getItemAsStream() throws XQException {
        switch (this.inputType) {
            case 0: {
                return Factory.newXMLStreamReader(this.inputStream, "UTF-8");
            }
            case 1: {
                return Factory.newXMLStreamReader(this.reader);
            }
            case 2: {
                return Factory.newXMLStreamReader(this.source);
            }
        }
        throw new XQExceptionImpl("Unrecognised deferred XML item", "XQJDX004");
    }

    @Override
    public String getItemAsString(Properties properties) throws XQException {
        StringWriter strWriter = new StringWriter();
        this.writeItem(strWriter, properties);
        return strWriter.toString();
    }

    @Override
    public void writeItem(OutputStream out, Properties properties) throws XQException {
        boolean xmlProcessing;
        boolean writingXQuery = XQToolkit.isToWriteXQuery(properties);
        boolean bl = xmlProcessing = !XQToolkit.isToIgnoreXMLProcessing(properties);
        if (writingXQuery) {
            out = Factory.newXQueryCorrector(out);
        }
        if (!xmlProcessing) {
            InputStream __in = null;
            if (this.inputType == 1) {
                try {
                    XQToolkit.bridgeFromReaderToUTF8OutputStream(this.reader, out);
                }
                catch (IOException e) {
                    throw new XQExceptionImpl(e.getMessage(), "XQJDX005", e);
                }
                return;
            }
            if (this.inputType == 0) {
                __in = this.inputStream;
            } else if (this.inputType == 2 && this.source instanceof StreamSource) {
                StreamSource _src = (StreamSource)this.source;
                if (_src.getInputStream() != null) {
                    __in = _src.getInputStream();
                } else {
                    Reader _reader = _src.getReader();
                    try {
                        XQToolkit.bridgeFromReaderToUTF8OutputStream(_reader, out);
                    }
                    catch (IOException e) {
                        throw new XQExceptionImpl(e.getMessage(), "XQJDX007", e);
                    }
                    return;
                }
            }
            if (__in != null) {
                byte[] buffer = new byte[5120];
                try {
                    int read;
                    while ((read = __in.read(buffer)) != -1) {
                        out.write(buffer, 0, read);
                    }
                    out.flush();
                }
                catch (IOException e) {
                    throw new XQExceptionImpl(e.getMessage(), "XQJDX008", e);
                }
                return;
            }
        }
        XQToolkit.transform(this.getSource(), Factory.newResult(out), properties);
    }

    @Override
    public void writeItem(Writer writer, Properties properties) throws XQException {
        boolean xmlProcessing;
        boolean writingXQuery = XQToolkit.isToWriteXQuery(properties);
        boolean bl = xmlProcessing = !XQToolkit.isToIgnoreXMLProcessing(properties);
        if (writingXQuery) {
            writer = Factory.newXQueryCorrector(writer);
        }
        if (!xmlProcessing) {
            Reader __reader = null;
            if (this.inputType == 1) {
                __reader = this.reader;
            } else if (this.inputType == 0) {
                __reader = Factory.newUTF8Reader(this.inputStream);
            } else if (this.inputType == 2 && this.source instanceof StreamSource) {
                StreamSource _src = (StreamSource)this.source;
                Reader reader = __reader = _src.getReader() != null ? _src.getReader() : Factory.newUTF8Reader(_src.getInputStream());
            }
            if (__reader != null) {
                char[] buffer = new char[5120];
                try {
                    int read;
                    while ((read = __reader.read(buffer)) != -1) {
                        writer.write(buffer, 0, read);
                    }
                    writer.flush();
                }
                catch (IOException e) {
                    throw new XQExceptionImpl(e.getMessage(), "XQJDX006", e);
                }
                return;
            }
        }
        XQToolkit.transform(this.getSource(), Factory.newResult(writer), properties);
    }

    @Override
    public void writeItemToSAX(ContentHandler saxhdlr) throws XQException {
        XQToolkit.transform(this.getSource(), Factory.newResult(saxhdlr));
    }

    @Override
    public void writeItemToResult(Result result) throws XQException {
        XQToolkit.transform(this.getSource(), result);
    }

    @Override
    public Object clone() {
        DeferredXMLXQItem newItem = (DeferredXMLXQItem)super.clone();
        ByteArrayOutputStream cachedBuffer = new ByteArrayOutputStream();
        try {
            this.writeItem(cachedBuffer, null);
        }
        catch (XQException e) {
            throw new RuntimeException(e);
        }
        newItem.inputType = 0;
        newItem.inputStream = new ByteArrayInputStream(cachedBuffer.toByteArray());
        return newItem;
    }
}

