/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core;

import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.NoSuchElementException;
import javax.xml.xquery.XQException;
import net.xqj.basic.BasicItem;
import net.xqj.basic.BasicResultSequence;
import net.xqj.core.GenericXQConnection;
import net.xqj.core.XQToolkit;
import net.xqj.core.exception.XQExceptionImpl;
import net.xqj.core.xqitem.AbstractAtomicXQItem;
import net.xqj.core.xqitem.AtomicXQItem;
import net.xqj.core.xqitem.DeferredXMLXQItem;
import net.xqj.core.xqitem.DocumentXQItem;
import net.xqj.core.xqitem.MemoryXMLXQItem;
import net.xqj.core.xqitem.NodeXQItem;
import net.xqj.core.xqitem.StreamingAtomicXQItem;
import net.xqj.core.xqitem.StreamingCustomXQItem;
import net.xqj.core.xqitem.XQItemBase;
import net.xqj.core.xqitem.XQItemBaseIterator;
import net.xqj.core.xqitem.XQItemFactory;
import net.xqj.core.xqitemtype.XQItemTypeFactory;

public class BasicResultSequenceIterator
implements XQItemBaseIterator {
    private final GenericXQConnection conn;
    private BasicResultSequence rs;
    private BasicItem currentItem = null;
    private AtomicXQItem reusableAtomicXQItem = null;
    private StreamingAtomicXQItem reusableStreamingAtomicXQItem = null;
    private MemoryXMLXQItem reusableMemoryXMLXQItem = null;
    private NodeXQItem reusableNodeXQItem = null;
    private DocumentXQItem reusableDocumentXQItem = null;
    private DeferredXMLXQItem reusableDeferredXMLXQItem = null;
    private StreamingCustomXQItem reusableStreamingCustomXQItem = null;

    public BasicResultSequenceIterator(GenericXQConnection conn) {
        this.conn = conn;
    }

    public void reset(BasicResultSequence resultSequence) {
        this.currentItem = null;
        this.rs = resultSequence;
    }

    private AbstractAtomicXQItem createAtomicXQItem(BasicItem item) throws XQException {
        AbstractAtomicXQItem base = null;
        if (item.isStreaming()) {
            if (this.reusableStreamingAtomicXQItem != null) {
                this.reusableStreamingAtomicXQItem.setInputStream(item.getInputStream());
            } else {
                this.reusableStreamingAtomicXQItem = XQItemFactory.newStreamingAtomicXQItem(item.getInputStream());
            }
            base = this.reusableStreamingAtomicXQItem;
        } else {
            CharBuffer cBuffer = item.getCharBuffer();
            if (this.reusableAtomicXQItem != null) {
                this.reusableAtomicXQItem.setTextValue(cBuffer.array(), cBuffer.position(), cBuffer.length());
            } else {
                this.reusableAtomicXQItem = XQItemFactory.newAtomicXQItem(cBuffer.array(), cBuffer.position(), cBuffer.length());
            }
            base = this.reusableAtomicXQItem;
        }
        int type = item.getItemType();
        if (type != 1) {
            base.setItemType(XQItemTypeFactory.createAtomicType(type));
        }
        return base;
    }

    private XQItemBase createXMLXQItem(BasicItem item) throws XQException {
        XQItemBase xqItemBase;
        if (item.isStreaming()) {
            if (this.reusableDeferredXMLXQItem != null) {
                this.reusableDeferredXMLXQItem.setInputstream(item.getInputStream(), item.getURL());
            } else {
                this.reusableDeferredXMLXQItem = XQItemFactory.newDeferredXMLXQItem(item.getInputStream(), item.getURL());
            }
            xqItemBase = this.reusableDeferredXMLXQItem;
        } else {
            if (this.reusableMemoryXMLXQItem != null) {
                this.reusableMemoryXMLXQItem.setTextValue(item.getCharBuffer().array(), item.getCharBuffer().position(), item.getCharBuffer().length());
            } else {
                this.reusableMemoryXMLXQItem = XQItemFactory.newMemoryXMLXQItem(item.getCharBuffer().array(), item.getCharBuffer().position(), item.getCharBuffer().length(), item.getURL(), false);
            }
            xqItemBase = this.reusableMemoryXMLXQItem;
        }
        xqItemBase.setNodeUri(item.getURL());
        return xqItemBase;
    }

    private StreamingCustomXQItem createStreamingCustomXQItem(BasicItem basicItem) throws XQException {
        if (this.reusableStreamingCustomXQItem != null) {
            this.reusableStreamingCustomXQItem.setBasicItem(basicItem);
            this.reusableStreamingCustomXQItem.setNodeUri(basicItem.getURL());
        } else {
            this.reusableStreamingCustomXQItem = XQItemFactory.newStreamingCustomXQItem(basicItem);
        }
        return this.reusableStreamingCustomXQItem;
    }

    private NodeXQItem newNodeXQItem(BasicItem item) throws XQException {
        CharBuffer buffer = null;
        buffer = item.isStreaming() ? CharBuffer.wrap(XQToolkit.forceRead(item.getReader())) : item.getCharBuffer();
        if (this.reusableNodeXQItem != null) {
            this.reusableNodeXQItem.setTextValue(buffer.array(), buffer.position(), buffer.length());
            this.reusableNodeXQItem.setNodeUri(null);
        } else {
            this.reusableNodeXQItem = XQItemFactory.newNodeXQItem(buffer.array(), buffer.position(), buffer.length());
        }
        return this.reusableNodeXQItem;
    }

    public NodeXQItem newAttributeXQItem(BasicItem item) throws XQException {
        if (!item.isStreaming()) {
            return XQItemFactory.newAttributeXQItem(item.getCharBuffer().array(), item.getCharBuffer().position(), item.getCharBuffer().length(), item.getURL());
        }
        byte[] buffer = XQToolkit.forceRead(item.getInputStream());
        String value = new String(buffer, Charset.forName("UTF8"));
        return XQItemFactory.newAttributeXQItem(value, null);
    }

    public NodeXQItem newCommentXQItem(BasicItem item) throws XQException {
        this.newNodeXQItem(item);
        this.reusableNodeXQItem.setItemType(XQItemTypeFactory.createCommentType());
        return this.reusableNodeXQItem;
    }

    public NodeXQItem newTextXQItem(BasicItem item) throws XQException {
        this.newNodeXQItem(item);
        this.reusableNodeXQItem.setItemType(XQItemTypeFactory.createTextType());
        return this.reusableNodeXQItem;
    }

    public NodeXQItem newPIXQItemFromXML(BasicItem item) throws XQException {
        if (item.isStreaming()) {
            throw new XQExceptionImpl("Streaming processing instructions currently unsupported.", "XQJBR002");
        }
        this.reusableNodeXQItem = XQItemFactory.newPIXQItemFromXML(item.getCharBuffer().array(), item.getCharBuffer().position(), item.getCharBuffer().length());
        return this.reusableNodeXQItem;
    }

    public DocumentXQItem newDocumentXQItem(XQItemBase item, boolean isElement) throws XQException {
        if (this.reusableDocumentXQItem != null) {
            this.reusableDocumentXQItem.setValue(item, isElement);
            this.reusableDocumentXQItem.setItemType(isElement ? XQItemTypeFactory.createDocumentElementType(item.getItemType()) : XQItemTypeFactory.createDocumentType());
        } else {
            this.reusableDocumentXQItem = XQItemFactory.newDocumentXQItem(item, isElement);
        }
        return this.reusableDocumentXQItem;
    }

    @Override
    public XQItemBase next() throws NoSuchElementException, XQException {
        if (!this.rs.nextItem()) {
            return null;
        }
        this.currentItem = this.rs.getItem();
        XQItemBase baseItem = null;
        switch (this.currentItem.getItemKind()) {
            case 1: {
                baseItem = this.createAtomicXQItem(this.currentItem);
                break;
            }
            case 2: {
                baseItem = this.newAttributeXQItem(this.currentItem);
                break;
            }
            case 3: {
                baseItem = this.newCommentXQItem(this.currentItem);
                break;
            }
            case 4: {
                baseItem = this.newDocumentXQItem(this.newTextXQItem(this.currentItem), false);
                break;
            }
            case 5: {
                baseItem = this.newDocumentXQItem(this.createXMLXQItem(this.currentItem), true);
                break;
            }
            case 6: {
                throw new XQExceptionImpl("document(schema-element()) datatype not supported.", "XQJBR004");
            }
            case 7: {
                baseItem = this.createXMLXQItem(this.currentItem);
                break;
            }
            case 8: {
                baseItem = this.newTextXQItem(this.currentItem);
                break;
            }
            case 9: {
                baseItem = this.createStreamingCustomXQItem(this.currentItem);
                break;
            }
            case 10: {
                baseItem = this.newPIXQItemFromXML(this.currentItem);
                break;
            }
            case 13: {
                throw new XQExceptionImpl("schema-attribute() datatype not supported.", "XQJBR005");
            }
            case 12: {
                throw new XQExceptionImpl("schema-element() datatype not supported.", "XQJBR006");
            }
            case 11: {
                baseItem = this.newTextXQItem(this.currentItem);
                break;
            }
            default: {
                throw new XQExceptionImpl("Unable to handle result item.\nPlease create a concise, isolated example of your XQuery or what  you were trying to do and submit it to http://xqj.net/issues", "XQJBR007");
            }
        }
        baseItem.setNodeUri(this.currentItem.getURL());
        return baseItem;
    }

    public void remove() {
    }
}

