/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import java.util.Collections;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.SourceInterpreter;
import org.objectweb.asm.tree.analysis.SourceValue;

public class JavaScriptInterfaceDetector
extends Detector
implements Detector.ClassScanner {
    public static final Issue ISSUE = Issue.create("JavascriptInterface", "Missing @JavascriptInterface on methods", "Ensures that interfaces added with addJavascriptInterface are annotated with @JavascriptInterface", "As of API 17, you must annotate methods in objects registered with the `addJavascriptInterface` method with a `@JavascriptInterface` annotation.", Category.SECURITY, 8, Severity.ERROR, new Implementation(JavaScriptInterfaceDetector.class, Scope.CLASS_FILE_SCOPE)).addMoreInfo("http://developer.android.com/reference/android/webkit/WebView.html#addJavascriptInterface(java.lang.Object, java.lang.String)");

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.SLOW;
    }

    @Override
    @Nullable
    public List<String> getApplicableCallOwners() {
        return Collections.singletonList("android/webkit/WebView");
    }

    @Override
    public void checkCall(@NonNull ClassContext context, @NonNull ClassNode classNode, @NonNull MethodNode method, @NonNull MethodInsnNode call) {
        if (context.getMainProject().getTargetSdk() < 17) {
            return;
        }
        if (!call.name.equals("addJavascriptInterface")) {
            return;
        }
        if (context.getDriver().isSuppressed(ISSUE, classNode, method, (AbstractInsnNode)call)) {
            return;
        }
        String type = JavaScriptInterfaceDetector.findFirstArgType(context, classNode, method, call);
        if (type == null) {
            return;
        }
        ClassNode c = context.getDriver().findClass(context, type, 0);
        if (c != null) {
            String owner;
            if (c.methods.isEmpty()) {
                return;
            }
            do {
                if (!JavaScriptInterfaceDetector.containsJavaScriptAnnotation(c)) continue;
                return;
            } while ((owner = context.getDriver().getSuperClass(c.name)) != null && !owner.startsWith("android/") && !owner.startsWith("java/") && !owner.startsWith("javax/") && (c = context.getDriver().findClass(context, owner, 0)) != null);
            Location location = context.getLocation((AbstractInsnNode)call);
            context.report(ISSUE, location, "None of the methods in the added interface have been annotated with @android.webkit.JavascriptInterface; they will not be visible in API 17", null);
        }
    }

    private static boolean containsJavaScriptAnnotation(@NonNull ClassNode classNode) {
        List methodList = classNode.methods;
        for (Object om : methodList) {
            MethodNode m = (MethodNode)om;
            List annotations = m.visibleAnnotations;
            if (annotations == null) continue;
            for (Object oa : annotations) {
                AnnotationNode a = (AnnotationNode)oa;
                if (!a.desc.equals("Landroid/webkit/JavascriptInterface;")) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static String findFirstArgType(ClassContext context, ClassNode classNode, MethodNode method, MethodInsnNode call) {
        Analyzer analyzer = new Analyzer(new SourceInterpreter(){

            @Override
            public SourceValue newOperation(AbstractInsnNode insn) {
                if (insn.getOpcode() == 187) {
                    String desc = ((TypeInsnNode)insn).desc;
                    return new TypeValue(1, desc);
                }
                return super.newOperation(insn);
            }

            @Override
            public SourceValue newValue(Type type) {
                if (type != null && type.getSort() == 0) {
                    return null;
                }
                if (type != null) {
                    return new TypeValue(1, type.getInternalName());
                }
                return super.newValue(type);
            }

            @Override
            public SourceValue copyOperation(AbstractInsnNode insn, SourceValue value) {
                return value;
            }
        });
        try {
            Frame[] frames = analyzer.analyze(classNode.name, method);
            InsnList instructions = method.instructions;
            Frame frame = frames[instructions.indexOf((AbstractInsnNode)call)];
            if (frame.getStackSize() <= 1) {
                return null;
            }
            SourceValue stackValue = (SourceValue)frame.getStack(1);
            if (stackValue instanceof TypeValue) {
                return ((TypeValue)stackValue).getFqcn();
            }
        }
        catch (AnalyzerException e) {
            context.log(e, null, new Object[0]);
        }
        return null;
    }

    private static class TypeValue
    extends SourceValue {
        private final String mFqcn;

        TypeValue(int size, String fqcn) {
            super(size);
            this.mFqcn = fqcn;
        }

        String getFqcn() {
            return this.mFqcn;
        }

        @Override
        public int getSize() {
            return 1;
        }
    }
}

