/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.checks.ApiDetector;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import java.io.File;
import java.util.Collections;
import java.util.List;
import lombok.ast.Annotation;
import lombok.ast.AnnotationElement;
import lombok.ast.AnnotationValue;
import lombok.ast.ArrayInitializer;
import lombok.ast.AstVisitor;
import lombok.ast.Block;
import lombok.ast.ConstructorDeclaration;
import lombok.ast.Expression;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.MethodDeclaration;
import lombok.ast.Modifiers;
import lombok.ast.Node;
import lombok.ast.Select;
import lombok.ast.StrictListAccessor;
import lombok.ast.StringLiteral;
import lombok.ast.TypeBody;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableDefinitionEntry;

public class AnnotationDetector
extends Detector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create("LocalSuppress", "@SuppressLint on invalid element", "Looks for @SuppressLint annotations in locations where it doesn't work for class based checks", "The `@SuppressAnnotation` is used to suppress Lint warnings in Java files. However, while many lint checks analyzes the Java source code, where they can find annotations on (for example) local variables, some checks are analyzing the `.class` files. And in class files, annotations only appear on classes, fields and methods. Annotations placed on local variables disappear. If you attempt to suppress a lint error for a class-file based lint check, the suppress annotation not work. You must move the annotation out to the surrounding method.", Category.CORRECTNESS, 3, Severity.ERROR, new Implementation(AnnotationDetector.class, Scope.JAVA_FILE_SCOPE));

    @Override
    public boolean appliesTo(@NonNull Context context, @NonNull File file) {
        return true;
    }

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public List<Class<? extends Node>> getApplicableNodeTypes() {
        return Collections.singletonList(Annotation.class);
    }

    @Override
    public AstVisitor createJavaVisitor(@NonNull JavaContext context) {
        return new AnnotationChecker(context);
    }

    private static class AnnotationChecker
    extends ForwardingAstVisitor {
        private final JavaContext mContext;

        public AnnotationChecker(JavaContext context) {
            this.mContext = context;
        }

        public boolean visitAnnotation(Annotation node) {
            Node parent;
            String type = node.astAnnotationTypeReference().getTypeName();
            if (("SuppressLint".equals(type) || "android.annotation.SuppressLint".equals(type)) && (parent = node.getParent()) instanceof Modifiers && (parent = parent.getParent()) instanceof VariableDefinition) {
                for (AnnotationElement element : node.astElements()) {
                    ArrayInitializer array;
                    StrictListAccessor expressions;
                    AnnotationValue valueNode = element.astValue();
                    if (valueNode == null) continue;
                    if (valueNode instanceof StringLiteral) {
                        StringLiteral literal = (StringLiteral)valueNode;
                        String id = literal.astValue();
                        if (this.checkId(node, id)) continue;
                        return super.visitAnnotation(node);
                    }
                    if (!(valueNode instanceof ArrayInitializer) || (expressions = (array = (ArrayInitializer)valueNode).astExpressions()) == null) continue;
                    for (Expression arrayElement : expressions) {
                        String id;
                        if (!(arrayElement instanceof StringLiteral) || this.checkId(node, id = ((StringLiteral)arrayElement).astValue())) continue;
                        return super.visitAnnotation(node);
                    }
                }
            }
            return super.visitAnnotation(node);
        }

        private boolean checkId(Annotation node, String id) {
            IssueRegistry registry = this.mContext.getDriver().getRegistry();
            Issue issue = registry.getIssue(id);
            if (issue != null && !issue.getImplementation().getScope().contains((Object)Scope.JAVA_FILE) || issue == ApiDetector.UNSUPPORTED) {
                Node parent = node.getParent();
                while (!(parent == null || parent instanceof MethodDeclaration || parent instanceof ConstructorDeclaration || parent instanceof Block)) {
                    if (parent instanceof TypeBody) {
                        return true;
                    }
                    if (issue == ApiDetector.UNSUPPORTED && parent instanceof VariableDefinition) {
                        VariableDefinition definition = (VariableDefinition)parent;
                        for (VariableDefinitionEntry entry : definition.astVariables()) {
                            Expression initializer = entry.astInitializer();
                            if (!(initializer instanceof Select)) continue;
                            return true;
                        }
                    }
                    if ((parent = parent.getParent()) != null) continue;
                    return true;
                }
                this.mContext.report(ISSUE, (Node)node, this.mContext.getLocation((Node)node), String.format("The @SuppressLint annotation cannot be used on a local variable with the lint check '%1$s': move out to the surrounding method", id), null);
                return false;
            }
            return true;
        }
    }
}

