/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.compiler;

import com.google.clearsilver.jsilver.compiler.JavaExpression;
import com.google.clearsilver.jsilver.compiler.TemplateTranslator;
import com.google.clearsilver.jsilver.compiler.VariableTranslator;
import com.google.clearsilver.jsilver.syntax.analysis.DepthFirstAdapter;
import com.google.clearsilver.jsilver.syntax.node.AAddExpression;
import com.google.clearsilver.jsilver.syntax.node.AAndExpression;
import com.google.clearsilver.jsilver.syntax.node.ADecimalExpression;
import com.google.clearsilver.jsilver.syntax.node.ADescendVariable;
import com.google.clearsilver.jsilver.syntax.node.ADivideExpression;
import com.google.clearsilver.jsilver.syntax.node.AEqExpression;
import com.google.clearsilver.jsilver.syntax.node.AExistsExpression;
import com.google.clearsilver.jsilver.syntax.node.AFunctionExpression;
import com.google.clearsilver.jsilver.syntax.node.AGtExpression;
import com.google.clearsilver.jsilver.syntax.node.AGteExpression;
import com.google.clearsilver.jsilver.syntax.node.AHexExpression;
import com.google.clearsilver.jsilver.syntax.node.ALtExpression;
import com.google.clearsilver.jsilver.syntax.node.ALteExpression;
import com.google.clearsilver.jsilver.syntax.node.AModuloExpression;
import com.google.clearsilver.jsilver.syntax.node.AMultiplyExpression;
import com.google.clearsilver.jsilver.syntax.node.ANameVariable;
import com.google.clearsilver.jsilver.syntax.node.ANeExpression;
import com.google.clearsilver.jsilver.syntax.node.ANegativeExpression;
import com.google.clearsilver.jsilver.syntax.node.ANotExpression;
import com.google.clearsilver.jsilver.syntax.node.ANumericAddExpression;
import com.google.clearsilver.jsilver.syntax.node.ANumericEqExpression;
import com.google.clearsilver.jsilver.syntax.node.ANumericExpression;
import com.google.clearsilver.jsilver.syntax.node.ANumericNeExpression;
import com.google.clearsilver.jsilver.syntax.node.AOrExpression;
import com.google.clearsilver.jsilver.syntax.node.AStringExpression;
import com.google.clearsilver.jsilver.syntax.node.ASubtractExpression;
import com.google.clearsilver.jsilver.syntax.node.AVariableExpression;
import com.google.clearsilver.jsilver.syntax.node.PExpression;
import java.util.LinkedList;

public class EscapingEvaluator
extends DepthFirstAdapter {
    private JavaExpression currentEscapingExpression;
    private boolean propagateEscapeStatus;
    private final VariableTranslator variableTranslator;

    public EscapingEvaluator(VariableTranslator variableTranslator) {
        this.variableTranslator = variableTranslator;
    }

    public JavaExpression computeIfExemptFromEscaping(PExpression expression, boolean propagateEscapeStatus) {
        if (propagateEscapeStatus) {
            return this.computeForPropagateStatus(expression);
        }
        return this.computeEscaping(expression, propagateEscapeStatus);
    }

    private JavaExpression computeForPropagateStatus(PExpression expression) {
        JavaExpression escapeMode = this.computeEscaping(expression, true);
        JavaExpression partiallyEscaped = this.computeEscaping(expression, false);
        JavaExpression escapeModeCheck = JavaExpression.infix(JavaExpression.Type.BOOLEAN, "!=", escapeMode, JavaExpression.symbol("EscapeMode.ESCAPE_NONE"));
        return JavaExpression.infix(JavaExpression.Type.BOOLEAN, "||", escapeModeCheck, partiallyEscaped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaExpression computeEscaping(PExpression expression, boolean propagateEscapeStatus) {
        try {
            assert (this.currentEscapingExpression == null) : "Not reentrant";
            this.propagateEscapeStatus = propagateEscapeStatus;
            expression.apply(this);
            assert (this.currentEscapingExpression != null) : "No escaping calculated";
            JavaExpression javaExpression = this.currentEscapingExpression;
            return javaExpression;
        }
        finally {
            this.currentEscapingExpression = null;
        }
    }

    private void setEscaping(JavaExpression escaping) {
        this.currentEscapingExpression = escaping;
    }

    public void caseAAddExpression(AAddExpression node) {
        node.getLeft().apply(this);
        JavaExpression left = this.currentEscapingExpression;
        node.getRight().apply(this);
        JavaExpression right = this.currentEscapingExpression;
        this.setEscaping(this.or(left, right));
    }

    public void caseAFunctionExpression(AFunctionExpression node) {
        LinkedList<PExpression> argsList = node.getArgs();
        PExpression[] args = argsList.toArray(new PExpression[argsList.size()]);
        final StringBuilder fullFunctionName = new StringBuilder();
        node.getName().apply(new DepthFirstAdapter(){

            public void caseANameVariable(ANameVariable node11) {
                fullFunctionName.append(node11.getWord().getText());
            }

            public void caseADescendVariable(ADescendVariable node12) {
                node12.getParent().apply(this);
                fullFunctionName.append('.');
                node12.getChild().apply(this);
            }
        });
        this.setEscaping(this.function(fullFunctionName.toString(), args));
    }

    private JavaExpression function(String name, PExpression ... csExpressions) {
        if (this.propagateEscapeStatus) {
            return JavaExpression.inlineIf(JavaExpression.Type.UNKNOWN, JavaExpression.callOn(JavaExpression.Type.BOOLEAN, TemplateTranslator.CONTEXT, "isEscapingFunction", JavaExpression.string(name)), JavaExpression.symbol("EscapeMode.ESCAPE_IS_CONSTANT"), JavaExpression.symbol("EscapeMode.ESCAPE_NONE"));
        }
        JavaExpression finalExpression = JavaExpression.BooleanLiteralExpression.FALSE;
        for (int i = 0; i < csExpressions.length; ++i) {
            csExpressions[i].apply(this);
            finalExpression = this.or(finalExpression, this.currentEscapingExpression);
        }
        JavaExpression funcExpr = JavaExpression.callOn(JavaExpression.Type.BOOLEAN, TemplateTranslator.CONTEXT, "isEscapingFunction", JavaExpression.string(name));
        return this.or(finalExpression, funcExpr);
    }

    private JavaExpression or(JavaExpression first, JavaExpression second) {
        if (this.propagateEscapeStatus) {
            return JavaExpression.callOn(JavaExpression.symbol("EscapeMode"), "combineModes", first, second);
        }
        if (first instanceof JavaExpression.BooleanLiteralExpression) {
            JavaExpression.BooleanLiteralExpression expr = (JavaExpression.BooleanLiteralExpression)first;
            if (expr.getValue()) {
                return expr;
            }
            return second;
        }
        if (second instanceof JavaExpression.BooleanLiteralExpression) {
            JavaExpression.BooleanLiteralExpression expr = (JavaExpression.BooleanLiteralExpression)second;
            if (expr.getValue()) {
                return expr;
            }
            return first;
        }
        return JavaExpression.infix(JavaExpression.Type.BOOLEAN, "||", first, second);
    }

    public void caseAVariableExpression(AVariableExpression node) {
        if (this.propagateEscapeStatus) {
            JavaExpression varName = this.variableTranslator.translate(node.getVariable());
            this.setEscaping(JavaExpression.callOn(TemplateTranslator.DATA_CONTEXT, "findVariableEscapeMode", varName));
        } else {
            this.setDefaultEscaping();
        }
    }

    private void setDefaultEscaping() {
        if (this.propagateEscapeStatus) {
            this.setEscaping(JavaExpression.symbol("EscapeMode.ESCAPE_IS_CONSTANT"));
        } else {
            this.setEscaping(JavaExpression.BooleanLiteralExpression.FALSE);
        }
    }

    public void caseAStringExpression(AStringExpression node) {
        this.setDefaultEscaping();
    }

    public void caseADecimalExpression(ADecimalExpression node) {
        this.setDefaultEscaping();
    }

    public void caseAHexExpression(AHexExpression node) {
        this.setDefaultEscaping();
    }

    public void caseANumericExpression(ANumericExpression node) {
        this.setDefaultEscaping();
    }

    public void caseANotExpression(ANotExpression node) {
        this.setDefaultEscaping();
    }

    public void caseAExistsExpression(AExistsExpression node) {
        this.setDefaultEscaping();
    }

    public void caseAEqExpression(AEqExpression node) {
        this.setDefaultEscaping();
    }

    public void caseANumericEqExpression(ANumericEqExpression node) {
        this.setDefaultEscaping();
    }

    public void caseANeExpression(ANeExpression node) {
        this.setDefaultEscaping();
    }

    public void caseANumericNeExpression(ANumericNeExpression node) {
        this.setDefaultEscaping();
    }

    public void caseALtExpression(ALtExpression node) {
        this.setDefaultEscaping();
    }

    public void caseAGtExpression(AGtExpression node) {
        this.setDefaultEscaping();
    }

    public void caseALteExpression(ALteExpression node) {
        this.setDefaultEscaping();
    }

    public void caseAGteExpression(AGteExpression node) {
        this.setDefaultEscaping();
    }

    public void caseAAndExpression(AAndExpression node) {
        this.setDefaultEscaping();
    }

    public void caseAOrExpression(AOrExpression node) {
        this.setDefaultEscaping();
    }

    public void caseANumericAddExpression(ANumericAddExpression node) {
        this.setDefaultEscaping();
    }

    public void caseASubtractExpression(ASubtractExpression node) {
        this.setDefaultEscaping();
    }

    public void caseAMultiplyExpression(AMultiplyExpression node) {
        this.setDefaultEscaping();
    }

    public void caseADivideExpression(ADivideExpression node) {
        this.setDefaultEscaping();
    }

    public void caseAModuloExpression(AModuloExpression node) {
        this.setDefaultEscaping();
    }

    public void caseANegativeExpression(ANegativeExpression node) {
        this.setDefaultEscaping();
    }
}

