/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.api;

import com.android.annotations.NonNull;
import com.google.common.annotations.Beta;

@Beta
public class ResizePolicy {
    private static final int NONE = 0;
    private static final int LEFT_EDGE = 1;
    private static final int RIGHT_EDGE = 2;
    private static final int TOP_EDGE = 4;
    private static final int BOTTOM_EDGE = 8;
    private static final int PRESERVE_RATIO = 16;
    private static final int HORIZONTAL = 3;
    private static final int VERTICAL = 12;
    private static final int ANY = 15;
    private static final ResizePolicy sAny = new ResizePolicy(15);
    private static final ResizePolicy sNone = new ResizePolicy(0);
    private static final ResizePolicy sHorizontal = new ResizePolicy(3);
    private static final ResizePolicy sVertical = new ResizePolicy(12);
    private static final ResizePolicy sScaled = new ResizePolicy(31);
    private final int mFlags;

    private ResizePolicy(int flags) {
        this.mFlags = flags;
    }

    public boolean isResizable() {
        return (this.mFlags & 0xF) != 0;
    }

    public boolean topAllowed() {
        return (this.mFlags & 4) != 0;
    }

    public boolean rightAllowed() {
        return (this.mFlags & 2) != 0;
    }

    public boolean bottomAllowed() {
        return (this.mFlags & 8) != 0;
    }

    public boolean leftAllowed() {
        return (this.mFlags & 1) != 0;
    }

    public boolean isAspectPreserving() {
        return (this.mFlags & 0x10) != 0;
    }

    @NonNull
    public static ResizePolicy full() {
        return sAny;
    }

    @NonNull
    public static ResizePolicy none() {
        return sNone;
    }

    @NonNull
    public static ResizePolicy horizontal() {
        return sHorizontal;
    }

    @NonNull
    public static ResizePolicy vertical() {
        return sVertical;
    }

    @NonNull
    public static ResizePolicy scaled() {
        return sScaled;
    }

    @NonNull
    public static ResizePolicy create(boolean top, boolean right, boolean bottom, boolean left, boolean preserve) {
        int mask = 0;
        if (top) {
            mask |= 4;
        }
        if (right) {
            mask |= 2;
        }
        if (bottom) {
            mask |= 8;
        }
        if (left) {
            mask |= 1;
        }
        if (preserve) {
            mask |= 0x10;
        }
        return new ResizePolicy(mask);
    }
}

