/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import java.io.File;
import java.util.Set;

public class InputPath {
    private final File mFile;
    private final Set<String> mTouchedExtensions;

    public InputPath(File file) {
        this(file, null);
    }

    public InputPath(File file, Set<String> extensionsToCheck) {
        if (file == null) {
            throw new RuntimeException("File in InputPath(File) can't be null");
        }
        this.mFile = file;
        this.mTouchedExtensions = extensionsToCheck;
    }

    public File getFile() {
        return this.mFile;
    }

    public boolean checksForModification(File file) {
        if (this.ignores(file)) {
            return false;
        }
        return this.mTouchedExtensions == null || this.mTouchedExtensions.contains(InputPath.getExtension(file));
    }

    public boolean ignores(File file) {
        return file.getName().startsWith(".");
    }

    protected static String getExtension(File file) {
        return InputPath.getExtension(file.getName());
    }

    protected static String getExtension(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        return fileName.substring(index + 1);
    }
}

