/*
 * Decompiled with CFR 0.152.
 */
package com.google.streamhtmlparser.util;

public class CharacterRecorder {
    public static final int RECORDING_BUFFER_SIZE = 255;
    private final StringBuilder sb;
    private boolean recording;

    public CharacterRecorder() {
        this.sb = new StringBuilder(255);
        this.recording = false;
    }

    public CharacterRecorder(CharacterRecorder aCharacterRecorder) {
        this.recording = aCharacterRecorder.recording;
        this.sb = new StringBuilder(255);
        this.sb.append(aCharacterRecorder.getContent());
    }

    public void startRecording() {
        this.sb.setLength(0);
        this.recording = true;
    }

    public void stopRecording() {
        this.recording = false;
    }

    public void maybeRecord(char input) {
        if (this.recording && this.sb.length() < 255) {
            this.sb.append(input);
        }
    }

    public void clear() {
        this.sb.setLength(0);
    }

    public void reset() {
        this.clear();
        this.recording = false;
    }

    public String getContent() {
        return this.sb.toString();
    }

    public boolean isRecording() {
        return this.recording;
    }

    public String toString() {
        return String.format("In recording: %s; Value: %s", this.isRecording(), this.sb.toString());
    }
}

