/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.ui;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Control;

public final class GridDataBuilder {
    private GridData mGD = new GridData();

    private GridDataBuilder() {
    }

    public static GridDataBuilder create(Control control) {
        GridDataBuilder gdh = new GridDataBuilder();
        control.setLayoutData((Object)gdh.mGD);
        return gdh;
    }

    public GridDataBuilder wHint(int w) {
        this.mGD.widthHint = w;
        return this;
    }

    public GridDataBuilder hHint(int h) {
        this.mGD.heightHint = h;
        return this;
    }

    public GridDataBuilder hIndent(int h) {
        this.mGD.horizontalIndent = h;
        return this;
    }

    public GridDataBuilder hSpan(int h) {
        this.mGD.horizontalSpan = h;
        return this;
    }

    public GridDataBuilder vSpan(int v) {
        this.mGD.verticalSpan = v;
        return this;
    }

    public GridDataBuilder hCenter() {
        this.mGD.horizontalAlignment = 0x1000000;
        return this;
    }

    public GridDataBuilder vCenter() {
        this.mGD.verticalAlignment = 0x1000000;
        return this;
    }

    public GridDataBuilder vTop() {
        this.mGD.verticalAlignment = 128;
        return this;
    }

    public GridDataBuilder vBottom() {
        this.mGD.verticalAlignment = 1024;
        return this;
    }

    public GridDataBuilder hLeft() {
        this.mGD.horizontalAlignment = 16384;
        return this;
    }

    public GridDataBuilder hRight() {
        this.mGD.horizontalAlignment = 131072;
        return this;
    }

    public GridDataBuilder hFill() {
        this.mGD.horizontalAlignment = 4;
        return this;
    }

    public GridDataBuilder vFill() {
        this.mGD.verticalAlignment = 4;
        return this;
    }

    public GridDataBuilder fill() {
        this.mGD.horizontalAlignment = 4;
        this.mGD.verticalAlignment = 4;
        return this;
    }

    public GridDataBuilder hGrab() {
        this.mGD.grabExcessHorizontalSpace = true;
        return this;
    }

    public GridDataBuilder vGrab() {
        this.mGD.grabExcessVerticalSpace = true;
        return this;
    }

    public GridDataBuilder grab() {
        this.mGD.grabExcessHorizontalSpace = true;
        this.mGD.grabExcessVerticalSpace = true;
        return this;
    }
}

