/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.compiler;

import com.google.clearsilver.jsilver.autoescape.AutoEscapeOptions;
import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.compiler.BaseCompiledTemplate;
import com.google.clearsilver.jsilver.compiler.CompilingClassLoader;
import com.google.clearsilver.jsilver.compiler.JSilverCompilationException;
import com.google.clearsilver.jsilver.compiler.TemplateTranslator;
import com.google.clearsilver.jsilver.functions.FunctionExecutor;
import com.google.clearsilver.jsilver.interpreter.TemplateFactory;
import com.google.clearsilver.jsilver.resourceloader.ResourceLoader;
import com.google.clearsilver.jsilver.syntax.TemplateSyntaxTree;
import com.google.clearsilver.jsilver.template.DelegatingTemplateLoader;
import com.google.clearsilver.jsilver.template.Template;
import com.google.clearsilver.jsilver.template.TemplateLoader;
import java.io.StringWriter;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateCompiler
implements DelegatingTemplateLoader {
    private static final Logger logger = Logger.getLogger(TemplateCompiler.class.getName());
    private static final String PACKAGE_NAME = "com.google.clearsilver.jsilver.compiler";
    private static final String CLASS_NAME = "$CompiledTemplate";
    private final TemplateFactory templateFactory;
    private final FunctionExecutor globalFunctionExecutor;
    private final AutoEscapeOptions autoEscapeOptions;
    private TemplateLoader templateLoaderDelegate = this;

    public TemplateCompiler(TemplateFactory templateFactory, FunctionExecutor globalFunctionExecutor, AutoEscapeOptions autoEscapeOptions) {
        this.templateFactory = templateFactory;
        this.globalFunctionExecutor = globalFunctionExecutor;
        this.autoEscapeOptions = autoEscapeOptions;
    }

    @Override
    public void setTemplateLoaderDelegate(TemplateLoader templateLoaderDelegate) {
        this.templateLoaderDelegate = templateLoaderDelegate;
    }

    @Override
    public Template load(String templateName, ResourceLoader resourceLoader, EscapeMode escapeMode) {
        return this.compile(this.templateFactory.find(templateName, resourceLoader, escapeMode), templateName, escapeMode);
    }

    @Override
    public Template createTemp(String name, String content, EscapeMode escapeMode) {
        return this.compile(this.templateFactory.createTemp(content, escapeMode), name, escapeMode);
    }

    private Template compile(TemplateSyntaxTree ast, String templateName, EscapeMode mode) {
        CharSequence javaSource = this.translateAstToJavaSource(ast, mode);
        String errorMessage = "Could not compile template: " + templateName;
        Class<?> templateClass = this.compileAndLoad(javaSource, errorMessage);
        try {
            BaseCompiledTemplate compiledTemplate = (BaseCompiledTemplate)templateClass.newInstance();
            compiledTemplate.setFunctionExecutor(this.globalFunctionExecutor);
            compiledTemplate.setTemplateName(templateName);
            compiledTemplate.setTemplateLoader(this.templateLoaderDelegate);
            compiledTemplate.setEscapeMode(mode);
            compiledTemplate.setAutoEscapeOptions(this.autoEscapeOptions);
            return compiledTemplate;
        }
        catch (InstantiationException e) {
            throw new Error(e);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
    }

    private CharSequence translateAstToJavaSource(TemplateSyntaxTree ast, EscapeMode mode) {
        StringWriter sourceBuffer = new StringWriter(256);
        boolean propagateStatus = this.autoEscapeOptions.getPropagateEscapeStatus() && mode.isAutoEscapingMode();
        ast.apply(new TemplateTranslator(PACKAGE_NAME, CLASS_NAME, sourceBuffer, propagateStatus));
        StringBuffer javaSource = sourceBuffer.getBuffer();
        logger.log(Level.FINEST, "Compiled template:\n{0}", javaSource);
        return javaSource;
    }

    private Class<?> compileAndLoad(CharSequence javaSource, String errorMessage) throws JSilverCompilationException {
        ClassLoader parentClassLoader = this.getClass().getClassLoader();
        DiagnosticCollector<JavaFileObject> diagnosticCollector = new DiagnosticCollector<JavaFileObject>();
        try {
            CompilingClassLoader templateClassLoader = new CompilingClassLoader(parentClassLoader, CLASS_NAME, javaSource, diagnosticCollector);
            return templateClassLoader.loadClass("com.google.clearsilver.jsilver.compiler.$CompiledTemplate");
        }
        catch (Exception e) {
            this.throwExceptionWithLotsOfDiagnosticInfo(javaSource, errorMessage, diagnosticCollector.getDiagnostics(), e);
            return null;
        }
    }

    private void throwExceptionWithLotsOfDiagnosticInfo(CharSequence javaSource, String errorMessage, List<Diagnostic<? extends JavaFileObject>> diagnostics, Exception cause) throws JSilverCompilationException {
        StringBuilder message = new StringBuilder(errorMessage).append('\n');
        message.append("------ Source code ------\n").append(javaSource);
        message.append("------ Compiler messages ------\n");
        for (Diagnostic<? extends JavaFileObject> diagnostic : diagnostics) {
            message.append(diagnostic).append('\n');
        }
        message.append("------ ------\n");
        throw new JSilverCompilationException(message.toString(), cause);
    }
}

