' My solution to http://www.rosettacode.org/wiki/String_comparison#uBasic.2F4tH
' Copyright J.L. Bezemer 2022

Print "Case sensitive"
Print "=============="
Print Show (FUNC(_Eval(FUNC(_StrCmp (Dup ("Dog"), Dup ("Dog"))))))
Print Show (FUNC(_Eval(FUNC(_StrCmp (Dup ("Dog"), Dup ("Cat"))))))
Print Show (FUNC(_Eval(FUNC(_StrCmp (Dup ("Dog"), Dup ("Rat"))))))
Print Show (FUNC(_Eval(FUNC(_StrCmp (Dup ("Dog"), Dup ("dog"))))))
Print Show (FUNC(_Eval(FUNC(_StrCmp (Dup ("Dog"), Dup ("Pig"))))))

Print

Print "Case insensitive"
Print "================"
Print Show (FUNC(_Eval(Comp ("Dog", "Dog"))))
Print Show (FUNC(_Eval(Comp ("Dog", "Cat"))))
Print Show (FUNC(_Eval(Comp ("Dog", "Rat"))))
Print Show (FUNC(_Eval(Comp ("Dog", "dog"))))
Print Show (FUNC(_Eval(Comp ("Dog", "Pig"))))

End

_StrCmp                                ' case sensitive compare
  Param (2)
  Local (3)
                                       ' up to the maximum length
  For c@ = 0 To Max (Len (a@), Len (b@)) - 1
    d@ = Iif (c@ < Len (a@), Peek (a@, c@), 0)
    e@ = Iif (c@ < Len (b@), Peek (b@, c@), 0)
    While (d@ = e@)                    ' while retrieved characters are equal
  Next

Return (d@ - e@)                       ' return comparison

_Eval                                  ' evaluate result
  Param (1)
  If a@ = 0 Then Return (Dup ("Equal"))
  If a@ > 0 Then Return (Dup ("Second before First"))
Return (Dup ("First before Second"))

