# Zettlr Icons

In this folder, you may find various versions of the official Logo of Zettlr:

- `./icon.xcf` The original source file of the logo.
- `./png/` Contains PNG-exports of various sizes from 16px up to 1024px.
- `./icon.ico` A Windows-compatible ICO-export.
- `./icon.icns` A macOS-compatible ICNS-export.
- `./icon.code.icns` A macOS-compatible ICNS-export intended for visualising code files.
- `./dmg/dmg_back.xcf` The original source file for the macOS DMG-background.
- `./dmg/dmg_back.tiff` The compiled TIFF-background for macOS DMG-packages.
- `dmg_back@1x.png`, `dmg_back@2x.png`, and `dmg_back@3x.png` Differently sized raw images that will be compiled into the final `dmg_back.tiff`.
- `./dmg/tiffutil.sh` A small script that can be used to compile the three source images into the final TIFF. macOS-only compatible.

## Corporate Identity

In case you should need this information somewhere during development, here's the CI for the logo:

- The "Z" is the lowercase Zeta character (ζ, Unicode-codepoint `U+03B6`)
- Font: Raleway Heavy
- Colors: #1cb27e (background), #ffffff (foreground)

## Licence - All rights reserved

Please note that the icon source files are provided for your and our convenience. You are only allowed to use these files in accordance with our rules on where and how to use the icons. We reserve the right to limit usage for ends we deem not in accordance with our policy.

Mostly, whenever you create a derivative of the logo which is being used in a PR to enhance the application, this is fine (further details can be discussed in the PR). If you are unsure whether or not your intended use-case is fine with us, don't hesitate to get in contact with us: info@zettlr.com.
