##! Events generated by the QUIC analyzer.
##!
##! See See `RFC9000 <https://tools.ietf.org/html/rfc9000>`__.

## Generated for a QUIC Initial packet.
##
## c: The connection.
##
## is_orig: True if the packet is from the the connection's originator.
##
## version: The Version field.
##
## dcid: The Destination Connection ID field.
##
## scid: The Source Connection ID field.
##
global QUIC::initial_packet: event(c: connection, is_orig: bool, version: count, dcid: string, scid: string);


## Generated for a QUIC Retry packet.
##
## c: The connection.
##
## is_orig: True if the packet is from the the connection's originator.
##
## version: The Version field.
##
## dcid: The Destination Connection ID field.
##
## scid: The Source Connection ID field.
##
## retry_token: The Retry Token field.
##
## integrity_tag: The Retry Integrity Tag field.
global QUIC::retry_packet: event(c: connection, is_orig: bool, version: count, dcid: string, scid: string, retry_token: string, retry_integrity_tag: string);


## Generated for a QUIC Handshake packet.
##
## c: The connection.
##
## is_orig: True if the packet is from the the connection's originator.
##
## version: The Version field.
##
## dcid: The Destination Connection ID field.
##
## scid: The Source Connection ID field.
global QUIC::handshake_packet: event(c: connection, is_orig: bool, version: count, dcid: string, scid: string);

## Generated for a QUIC 0-RTT packet.
##
## c: The connection.
##
## is_orig: True if the packet is from the the connection's originator.
##
## version: The Version field.
##
## dcid: The Destination Connection ID field.
##
## scid: The Source Connection ID field.
global QUIC::zero_rtt_packet: event(c: connection, is_orig: bool, version: count, dcid: string, scid: string);


## Generated for a QUIC CONNECTION_CLOSE frame.
##
## c: The connection.
##
## is_orig: True if the packet is from the the connection's originator.
##
## version: The Version field.
##
## dcid: The Destination Connection ID field.
##
## scid: The Source Connection ID field.
##
## error_code: Count indicating the reason for closing this connection.
##
## reason_phrase: Additional diagnostic information for the closure.
##
## .. note:: Packets with CONNECTION_CLOSE frames are usually encrypted after connection establishment and not visible to Zeek.
global QUIC::connection_close_frame: event(c: connection, is_orig: bool, version: count, dcid: string, scid: string, error_code: count, reason_phrase: string);
