" See LICENSE file for license and copyright information

" This is a sample plugin that can be used for synctex forward synchronization.
" It currently uses latexsuite to obtain the file name of the document. If you
" are not using latexsuite, it should be enough to adopt the calculation of
" 'output' accordingly.

" avoid re-execution
if exists("b:did_zathura_synctex_plugin") || !exists("Tex_GetMainFileName")
  finish
endif
let b:did_zathura_synctex_plugin = 1

function! Zathura_Open() 
    let pdf_file = Tex_GetMainFileName(":p:r").".pdf"
    if filereadable(pdf_file)
        system("zathura" . pdf_file)
    else 
        echoerr "Could not open PDF."
    endif
endfunction

function! Zathura_SyncTexForward()
  let source = expand("%:p")
  let input = shellescape(line(".").":".col(".").":".source)
  let output = Tex_GetMainFileName(":p:r").".pdf"
  let execstr = "zathura --synctex-forward=".input." ".shellescape(output)
  silent call system(execstr)
endfunction

function! Zathura_SyncTexBackward()
  let source = expand("%:p")
  let input = shellescape(line(".").":".col(".").":".source)
  let output = Tex_GetMainFileName(":p:r").".pdf"
  let execstr = "zathura --synctex-forward=".input." ".shellescape(output)
  silent call system(execstr)
endfunction

function! UpdatePDF()
endfunction

nnoremap <silent> <buffer> <LocalLeader>o :call Zathura_Open()<CR>
nnoremap <silent> <buffer> <LocalLeader>f :call Zathura_SyncTexForward()<CR>
nnoremap <silent> <buffer> <LocalLeader>r :call Zathura_SyncTexBackward()<CR>

" The autocommands
autocmd CursorMoved *.tex silent call UpdatePDF()
autocmd CursorMovedI *.tex silent call UpdatePDF()
autocmd CursorHold *.tex silent call UpdatePDF()
autocmd CursorHoldI *.tex silent call UpdatePDF()

" Welcome message
echohl ErrorMsg | echo "See ':help live-latex-preview' for help with the plugin" 
