/*
 *  main.m: main function of GSMBrowser.app
 *
 *  Copyright (c) 2003 Free Software Foundation, Inc.
 *  
 *  Author: Marko Riedel
 *  Date: March 2003
 *
 *  With code fragments from MemoryPanel, ImageViewer, Finger, GDraw 
 *  and GShisen.
 *
 *  This sample program is part of GNUstep.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#import <locale.h>
#import <stdio.h>
#import <stdlib.h>

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>

#import "Controller.h"

int main(int argc, const char **argv, char **env)
{
   NSAutoreleasePool *pool;
   NSApplication *app;
   NSMenu *mainMenu, *subMenu;
   NSMenu *menu;
   NSMenuItem *menuItem, *subMenuItem;
   Controller *controller;

   setlocale(LC_NUMERIC, "C");
   printf("locale %s\n", setlocale(LC_NUMERIC, NULL));

#ifdef _GPSText_DEBUG
   GSDebugAllocationActive(YES);
#endif

   pool = [NSAutoreleasePool new];
   app = [NSApplication sharedApplication];

   //
   // Create the Menu 
   //


   // Main Menu
   mainMenu = AUTORELEASE ([NSMenu new]);

   // Info SubMenu
   menuItem = (NSMenuItem *)[mainMenu addItemWithTitle:@"Info" 
			action:NULL 
			keyEquivalent:@""];
   menu = AUTORELEASE ([NSMenu new]);
   [mainMenu setSubmenu:menu forItem:menuItem];
   [menu addItemWithTitle:@"Info Panel..." 
	 action:@selector(orderFrontStandardInfoPanel:) 
	 keyEquivalent:@""];
   [menu addItemWithTitle:@"Preferences..." 
	 action:@selector(runPreferencesPanel:) 
	 keyEquivalent:@""];
   [menu addItemWithTitle:@"Help..." 
	 action:@selector(orderFrontHelpPanel:)
	 keyEquivalent:@"?"];

   // File SubMenu
   menuItem = (NSMenuItem *)[mainMenu addItemWithTitle:@"File" 
			action:NULL 
			keyEquivalent:@""];
   menu = AUTORELEASE ([NSMenu new]);
   [mainMenu setSubmenu:menu forItem:menuItem];
   [[menu addItemWithTitle:@"Open Text/Image"
          action:@selector(openFile:)
          keyEquivalent:@"o"] setTag:OPEN_TEXT];
   [[menu addItemWithTitle:@"Open Image"
          action:@selector(openFile:)
          keyEquivalent:@"o"] setTag:OPEN_IMAGE];
   [[menu addItemWithTitle:@"Open PostScript/PDF"
          action:@selector(openFile:)
          keyEquivalent:@""] setTag:OPEN_POSTSCRIPT];
   [menu addItemWithTitle:@"Save Text/Image as PostScript"
	 action:@selector(a2psSave:)
	 keyEquivalent:@""];
   [menu addItemWithTitle:@"Save current page as TIFF"
	 action:@selector(tiffSave:)
	 keyEquivalent:@""];
   [menu addItemWithTitle:@"Save pasteboard as TIFF"
	 action:@selector(saveTIFFImageFromPB:)
	 keyEquivalent:@""];

   // Windows SubMenu
   menuItem = (NSMenuItem *)[mainMenu addItemWithTitle:@"Windows" 
                        action: NULL 
                        keyEquivalent:@""];
   menu = AUTORELEASE ([NSMenu new]);
   [mainMenu setSubmenu: menu forItem: menuItem];
   [menu addItemWithTitle: @"Arrange"
         action: @selector(arrangeInFront:)
         keyEquivalent: @""];
   [menu addItemWithTitle: @"Miniaturize"
         action: @selector(performMiniaturize:)
         keyEquivalent: @"m"];
   [menu addItemWithTitle: @"Close"
         action: @selector(performClose:)
         keyEquivalent: @"w"];
   [menu addItemWithTitle: @"Close All"
         action: @selector(closeAll:)
         keyEquivalent: @""];
   [app setWindowsMenu: menu];

   // Preview Menu
   menuItem = (NSMenuItem *)[mainMenu addItemWithTitle:@"Preview" 
			action:NULL 
			keyEquivalent:@""];
   menu = AUTORELEASE ([NSMenu new]);
   [mainMenu setSubmenu:menu forItem:menuItem];
   [menu addItemWithTitle:@"Current"
         action:@selector(a2psPreview:)
         keyEquivalent:@""];
   [menu addItemWithTitle:@"All"
         action:@selector(previewAll:)
         keyEquivalent:@""];

   // Option SubMenu
   menuItem = (NSMenuItem *)[mainMenu addItemWithTitle:@"Options" 
			action:NULL 
			keyEquivalent:@""];
   menu = AUTORELEASE ([NSMenu new]);
   [mainMenu setSubmenu:menu forItem:menuItem];
   [menu addItemWithTitle:@"Display"
	 action:@selector(a2psDisplayOptions:)
	 keyEquivalent:@""];
   [menu addItemWithTitle:@"Reset"
	 action:@selector(a2psResetOptions:)
	 keyEquivalent:@""];

   // Resolution SubMenu
   menuItem = (NSMenuItem *)[mainMenu addItemWithTitle:@"Resolution" 
			action:NULL 
			keyEquivalent:@""];
   menu = AUTORELEASE ([NSMenu new]);
   [mainMenu setSubmenu:menu forItem:menuItem];
   [menu addItemWithTitle:@"Fit window"
         action:@selector(useContentDimensions:)
         keyEquivalent:@""];
   [[menu addItemWithTitle:@"Very Low (21 dpi)"
          action:@selector(a2psResolution:)
          keyEquivalent:@""] setTag:21];
   [[menu addItemWithTitle:@"Low (36 dpi)"
          action:@selector(a2psResolution:)
          keyEquivalent:@""] setTag:36];
   [[menu addItemWithTitle:@"Medium I (72 dpi)"
          action:@selector(a2psResolution:)
          keyEquivalent:@""] setTag:72];
   [[menu addItemWithTitle:@"Medium II (90 dpi)"
          action:@selector(a2psResolution:)
          keyEquivalent:@""] setTag:90];
   [[menu addItemWithTitle:@"Medium III (108 dpi)"
          action:@selector(a2psResolution:)
          keyEquivalent:@""] setTag:108];
   [[menu addItemWithTitle:@"High (144 dpi)"
          action:@selector(a2psResolution:)
          keyEquivalent:@""] setTag:144];

   // Page SubMenu
   menuItem = (NSMenuItem *)[mainMenu addItemWithTitle:@"Page" 
			action:NULL 
			keyEquivalent:@""];
   menu = AUTORELEASE ([NSMenu new]);
   [mainMenu setSubmenu:menu forItem:menuItem];
   [[menu addItemWithTitle:@"First"
          action:@selector(a2psFirst:)
          keyEquivalent:@""] setTag:-1];
   [[menu addItemWithTitle:@"Page-10"
          action:@selector(a2psPage:)
          keyEquivalent:@""] setTag:-10];
   [[menu addItemWithTitle:@"Page-5"
          action:@selector(a2psPage:)
          keyEquivalent:@""] setTag:-5];
   [[menu addItemWithTitle:@"Previous"
          action:@selector(a2psPage:)
          keyEquivalent:@""] setTag:-1];
   [[menu addItemWithTitle:@"Next"
          action:@selector(a2psPage:)
          keyEquivalent:@""] setTag:+1];
   [[menu addItemWithTitle:@"Page+5"
          action:@selector(a2psPage:)
          keyEquivalent:@""] setTag:+5];
   [[menu addItemWithTitle:@"Page+10"
          action:@selector(a2psPage:)
          keyEquivalent:@""] setTag:+10];
   [[menu addItemWithTitle:@"Last"
          action:@selector(a2psLast:)
          keyEquivalent:@""] setTag:+1];

   // Print MenuItem
   [mainMenu addItemWithTitle:@"Print"
	 action:@selector(a2psPrint:)
	 keyEquivalent:@""];
   
   // Hide MenuItem
   [mainMenu addItemWithTitle:@"Hide" 
	     action:@selector(hide:)
	     keyEquivalent:@"h"];	

   // Quit MenuItem
   [mainMenu addItemWithTitle:@"Quit" 
	     action:@selector(terminate:)
	     keyEquivalent:@"q"];	

   [app setMainMenu:mainMenu];

   controller = [Controller new];
   [app setDelegate:controller];

   NSApplicationMain(argc, argv);

   [[NSUserDefaults standardUserDefaults] synchronize];

   // RELEASE (controller);
   // RELEASE (pool);
   return 0;
}

