#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>

#import "KnobView.h"

typedef enum {
    OPEN_TEXT = 0,
    OPEN_IMAGE,
    OPEN_POSTSCRIPT
} OPEN_TYPE;

#define _GPSText_DEBUG 1

#define OpenCmdLineFile @"OpenCmdLineFile"

@interface Controller : NSObject
{
    NSMutableArray *openers;
    BOOL initIsDone;

    NSPanel *prefs;
    NSTextField *a2psf, *gsf, *lprf;

    NSPanel *optPanel;
    NSButton *optCheckBox;
    NSPopUpButton *optChooser;
    NSBox *optBox;
    id currentOption;

    NSPanel *progPanel;
    KnobView *progInd;
    BOOL interrupted;

    NSString *imgFmt;
    NSArray *imageTypes;
    NSArray *psTypes;
}

- init;

- (BOOL)application:(NSApplication *)theApp openFile:(NSString *)filename;
- (void)applicationDidFinishLaunching:(NSNotification *)aNotification;
- (void)applicationWillTerminate:(NSNotification *)aNotification;

- (void)openCmdLineFile:(NSNotification *)aNotification;


- previewAll:(id)sender;
- closeAll:(id)sender;

- (NSString *)imgFmt;
- setImgFmt:(NSString *)fmt;

- optSetEnabled:(id)sender;
- changeOption:(id)sender;


- makeOptions;
- rescanOptions;

- (NSSize)mediumSizeFor:(id)sender;

- a2psDisplayOptions:(id)sender;
- a2psResetOptions:(id)sender;


- makePreferences;
- runPreferencesPanel:(id)sender;

- makeProgPanel;
- progStop:(id)sender;

- browseBinary:(id)sender;

- (BOOL)checkBinary:(NSString *)name title:(NSString *)tstr;

- checkFields;

- readDefaults:(id)sender;
- setDefaults:(id)sender;
- setEntered:(id)sender;
- cancelPreferences:(id)sender;

- (NSString *)a2psStr;
- (NSString *)gsStr;
- (NSString *)lprStr;
- (NSMutableArray *)lprCommand;

- (NSMutableArray *)getA2PSArgs;
- (NSMutableArray *)getGSArgs;

- openFile:(id)sender;
- saveTIFFImageFromPB:(id)sender;

- (NSString *)tempNameExt:(NSString *)pathExt;


- (BOOL)waitForTaskToFinish:(NSTask *)aTask
                description:(NSString *)desc;
- (NSArray *)runCommand:(NSString *)cmd arguments:(NSArray *)args;

- (void)windowWillClose:(NSNotification *)aNotification;
- (void)windowDidResize:(NSNotification *)aNotification;
- (void)windowDidMove:(NSNotification *)aNotification;

@end


