#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>

#define MARKDELAY 1.5
#define MARKPAUSE 0.1

@interface PrevImageView : NSView
{
    NSImage *image;
}

- (id)initWithFrame:(NSRect)frameRect;

- (NSImage *)image;
- setImage:(NSImage *)anImage;

- (void)drawRect:(NSRect)aRect;
- (void)mouseDown:(NSEvent *)theEvent;

@end


#define DEFAULT_RESOLUTION 36

@interface Preview : NSWindow
{
    @public
    id con;

    NSScrollView *pageScroller;
    NSMatrix *pageMatrix;

    NSScrollView *scrollView;
    PrevImageView *imgView;

    int current, pages;

    NSString *imgPath, *imgDir, *imgFmt;

    BOOL useContentDimensions;
    NSSize csize;
    int resolution;

    NSArray *tasks, *readPipes, *readData;
    NSInvocation *pageInv;
    NSTimer *pageTimer;
}

- initWithController:(id)theCon
             andPath:(NSString *)path
          resolution:(int)rval;

- (NSString *)path;

- (NSString *)imgFmt;
- setImgFmt:(NSString *)fmt;

- countPages:(NSString *)path done:(BOOL)dflag;

- prepareForRead;
- a2psRead;

- (NSString *)gsDimensionArg;

- setResolution:(int)res;
- useContentDimensions:(id)sender;

- a2psResolution:(id)sender;

- setPage:(int)page;
- (NSImage *)imageLoadCompleteHook:(NSImage *)img;

- tiffSave:(id)sender;

- a2psFirst:(id)sender;
- a2psLast:(id)sender;

- a2psPage:(id)sender;
- a2psGoto:(id)sender;

- a2psPreview:(id)sender;

- (BOOL)printFile:(NSString *)path;

- (BOOL)validateMenuItem:(id <NSMenuItem>)menuItem;

- allPagesDone;

- cleanupPreview;

@end

@interface TextPreview  : Preview

- a2psPreview:(id)sender;

- (BOOL)saveToFile:(NSString *)path opTitle:(NSString *)ot;
- a2psSave:(id)sender;

- allPagesDone;
@end

@interface PostScriptOrPDFPreview  : Preview

- a2psPreview:(id)sender;
- a2psPrint:(id)sender;

- allPagesDone;
@end

#define IMAGE_DEFAULT_DPI 72

@interface ImagePreview  : TextPreview

- a2psPreview:(id)sender;

- (NSImage *)imageLoadCompleteHook:(NSImage *)img;

@end

