function(search_header_file config_h defmacro outvar)
  cmake_parse_arguments(search_header_file "STRIP_QUOTES" "" "" ${ARGN})
  if(EXISTS "${config_h}")
    set(_regexp "^#define[ \t]+${defmacro}[ \t]+")
    file(STRINGS "${config_h}" _string REGEX "${_regexp}")
    string(REGEX REPLACE "${_regexp}(.+)$" "\\1" _string "${_string}")
    if(search_header_file_STRIP_QUOTES)
      string(REPLACE "\"" "" _string "${_string}")
    endif()
  else()
    set(_string ${outvar}-NOTFOUND)
  endif()
  set(${outvar} ${_string} PARENT_SCOPE)
endfunction()
