/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.samples;

import java.io.IOException;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.ParsingException;

public class XHTMLQualifier {
    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Usage: java nu.xom.samples.XHTMLQualifier URL");
            return;
        }
        Builder builder = new Builder();
        try {
            Document document = builder.build(stringArray[0]);
            Element element = document.getRootElement();
            XHTMLQualifier.qualify(element);
            System.out.println(document.toXML());
        }
        catch (ParsingException parsingException) {
            System.out.println(stringArray[0] + " is not well-formed.");
            System.out.println(parsingException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    public static void qualify(Element element) {
        if (element.getNamespaceURI().equals("")) {
            element.setNamespaceURI("http://www.w3.org/1999/xhtml");
        }
        Elements elements = element.getChildElements();
        for (int i = 0; i < elements.size(); ++i) {
            XHTMLQualifier.qualify(elements.get(i));
        }
    }
}

