/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.benchmarks;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.ParsingException;
import nu.xom.Serializer;
import nu.xom.Text;

class DocumentModifier {
    DocumentModifier() {
    }

    public static void main(String[] stringArray) {
        if (stringArray.length <= 0) {
            System.out.println("Usage: java nu.xom.benchmarks.DocumentModifier URL");
            return;
        }
        DocumentModifier documentModifier = new DocumentModifier();
        Builder builder = new Builder();
        try {
            Document document = builder.build(stringArray[0]);
            DocType docType = document.getDocType();
            if (docType != null) {
                document.removeChild((Node)docType);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Serializer serializer = new Serializer((OutputStream)byteArrayOutputStream);
            serializer.write(document);
            serializer.flush();
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            DocumentModifier.warmup(builder, documentModifier, byArray, 5);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(byArray));
            System.gc();
            System.gc();
            System.gc();
            long l = System.currentTimeMillis();
            Document document2 = builder.build((InputStream)bufferedInputStream);
            long l2 = System.currentTimeMillis();
            System.out.println(l2 - l + "ms to build the document");
            long l3 = System.currentTimeMillis();
            DocumentModifier.performTask(documentModifier, document2);
            long l4 = System.currentTimeMillis();
            System.out.println(l4 - l3 + "ms to modify the document");
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
        catch (ParsingException parsingException) {
            System.out.println((Object)parsingException);
        }
    }

    private static void warmup(Builder builder, DocumentModifier documentModifier, byte[] byArray, int n) throws IOException, ParsingException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(byArray));
        Document document = builder.build((InputStream)bufferedInputStream);
        for (int i = 0; i < n; ++i) {
            DocumentModifier.performTask(documentModifier, document);
        }
    }

    private static void performTask(DocumentModifier documentModifier, Document document) throws IOException {
        documentModifier.followNode((Node)document);
    }

    public void followNode(Node node) throws IOException {
        if (node instanceof Text) {
            if (node.getValue().trim().length() == 0) {
                node.detach();
            } else {
                Element element = new Element("dummy");
                ParentNode parentNode = node.getParent();
                parentNode.insertChild((Node)element, parentNode.indexOf(node));
                node.detach();
                element.appendChild(node);
            }
            return;
        }
        if (node instanceof Element) {
            Element element = (Element)node;
            element.addAttribute(new Attribute("class", "original"));
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.followNode(node.getChild(i));
            }
        } else {
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.followNode(node.getChild(i));
            }
        }
    }
}

