/* VERSION 0.1 */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <X11/X.h>
#include <X11/xpm.h>
#include <math.h>
#include <values.h>
#include "xutils.h"
#include "wmBinClock_master.xpm"
#include "wmBinClock_mask.xbm"

#define GRAYX 64
#define GRAYY 2
#define REDX 72
#define REDY 2


/* 
 *  Delay between refreshes (in microseconds) 
 */
#define DELAY 10000L
#define DEFAULT_UPDATEDELAY 900L

void ButtonPressEvent(XButtonEvent *);
void KeyPressEvent(XKeyEvent *);
char *StringToUpper(char *);

int UpToDate = 0;
long UpdateDelay;
int GotFirstClick1, GotDoubleClick1;
int GotFirstClick2, GotDoubleClick2;
int GotFirstClick3, GotDoubleClick3;
int DblClkDelay;


int main(int argc, char *argv[])
{
    XEvent event;
    struct tm *tmworld;
    time_t t;
    char tempstr[20];
    int m;
    int clockarray[10][10];
    Window myWindow;
    int i, j;
    m = 101;
    initXwindow(argc, argv);
    myWindow =
	openXwindow(argc, argv, wmBinClock_master_xpm,
		    wmBinClock_mask_bits, wmBinClock_mask_width,
		    wmBinClock_mask_height);


    DblClkDelay = 32000;
    UpToDate = 0;
    while (1) {

	if (DblClkDelay > 15) {

	    DblClkDelay = 0;
	    GotFirstClick1 = 0;
	    GotDoubleClick1 = 0;
	    GotFirstClick2 = 0;
	    GotDoubleClick2 = 0;
	    GotFirstClick3 = 0;
	    GotDoubleClick3 = 0;

	} else {

	    ++DblClkDelay;

	}


	/* 
	 *   Process any pending X events.
	 */
	while (XPending(display)) {
	    XNextEvent(display, &event);
	    switch (event.type) {
	    case Expose:
		RedrawWindow();
		break;
	    case ButtonPress:
		ButtonPressEvent(&event.xbutton);
		break;
	    case KeyPress:
		KeyPressEvent(&event.xkey);
		break;
	    case ButtonRelease:
		break;
	    case EnterNotify:
		XSetInputFocus(display, PointerRoot, RevertToParent,
			       CurrentTime);
		break;
	    case LeaveNotify:
		XSetInputFocus(display, PointerRoot, RevertToParent,
			       CurrentTime);
		break;

	    }
	}



	copyXPMArea(5, 69, 54, 54, 5, 5);

	t = time(0);
	tmworld = localtime(&t);

	sprintf(tempstr, "%02i%02i%02i",
		tmworld->tm_hour, tmworld->tm_min, tmworld->tm_sec);

	for (i = 0; i < 6; i++) {
	    clockarray[i][0] = 0;
	    clockarray[i][1] = 0;
	    clockarray[i][2] = 0;
	    clockarray[i][3] = 0;

	    switch (tempstr[i]) {

	    case '1':
		clockarray[i][3] = 1;
		break;
	    case '2':
		clockarray[i][2] = 1;
		break;
	    case '3':
		clockarray[i][3] = 1;
		clockarray[i][2] = 1;
		break;
	    case '4':
		clockarray[i][1] = 1;
		break;
	    case '5':
		clockarray[i][3] = 1;
		clockarray[i][1] = 1;
		break;
	    case '6':
		clockarray[i][2] = 1;
		clockarray[i][1] = 1;
		break;
	    case '7':
		clockarray[i][3] = 1;
		clockarray[i][2] = 1;
		clockarray[i][1] = 1;
		break;
	    case '8':
		clockarray[i][0] = 1;
		break;
	    case '9':
		clockarray[i][0] = 1;
		clockarray[i][3] = 1;
		break;
	    }
	}
	for (i = 0; i < 6; i++) {
	    for (j = 0; j < 4; j++) {
		if (clockarray[i][j] == 1)
		    copyXPMArea(REDX, REDY, 8, 8, 6 + (i * 9),
				10 + (j * 10));
		else
		    copyXPMArea(GRAYX, GRAYY, 8, 8, 6 + (i * 9),
				10 + (j * 10));
	    }
	}

	RedrawWindow();

	usleep(DELAY);
    }
}




void ButtonPressEvent(XButtonEvent * xev)
{

    /*
     *  Process single clicks.
     */
    DblClkDelay = 0;
    if ((xev->button == Button1) && (xev->type == ButtonPress)) {

	if (GotFirstClick1)
	    GotDoubleClick1 = 1;
	else
	    GotFirstClick1 = 1;

    } else if ((xev->button == Button2) && (xev->type == ButtonPress)) {

	if (GotFirstClick2)
	    GotDoubleClick2 = 1;
	else
	    GotFirstClick2 = 1;

    } else if ((xev->button == Button3) && (xev->type == ButtonPress)) {

	if (GotFirstClick3)
	    GotDoubleClick3 = 1;
	else
	    GotFirstClick3 = 1;

    }




    /*
     *  We got a double click on Mouse Button1 (i.e. the left one)
     */
    if (GotDoubleClick1) {
	GotFirstClick1 = 0;
	GotDoubleClick1 = 0;
    }


    /*
     *  We got a double click on Mouse Button2 (i.e. the left one)
     */
    if (GotDoubleClick2) {
	GotFirstClick2 = 0;
	GotDoubleClick2 = 0;
    }


    /*
     *  We got a double click on Mouse Button3 (i.e. the left one)
     */
    if (GotDoubleClick3) {
	GotFirstClick3 = 0;
	GotDoubleClick3 = 0;
    }

    return;


}




/*
 *  This routine handles key presses.
 *
 */
void KeyPressEvent(XKeyEvent * xev)
{

    return;

}


