export function SindarinAssignment(str, val) {
  this.identifier = str;
  this.value = val;
  this.writeToSindarin = () => this.identifier + ' = ' + this.value;
}


export function sindarinWriteHeader() {
  const date = new Date();
  let string = '# This Sindarin script was automatically generated by the Whizard-GUI\n';
  string += '# Date: ' + (date.getMonth() + 1) + '-' +
    date.getDate() + '-' + date.getFullYear();
  string += ', ' + date.getHours() + ':' + date.getMinutes() + 'h\n\n';
  return string;
}


// TODO: (bcn 2016-06-30) these are identically but maybe one could add more
// logic to commmand?
export function SindarinCommand(str) {
  this.command = str;
  this.writeToSindarin = () => this.command;
}


export function SindarinAdditionalCode(s) {
  this.as = s;
  this.writeToSindarin = () => this.as;
}


function SindarinWriteBody() {
  let string = '';
  for (let i = 0; i < this.list.length; i++) {
    string += this.list[i].writeToSindarin() + '\n';
  }
  return string;
}


function constructSindarinFromList() {
  let string = sindarinWriteHeader();
  string += this.writeBody();
  string += this.writeProcesses();
  return string;
}


export function SindarinWriteProcesses() {
  let string = '';
  for (let i = 0; i < this.processList.length; i++) {
    string += this.processList[i].writeToSindarin(i) + '\n';
  }
  return string;
}


export function SindarinGenerator(sindarinList, processList) {
  this.list = sindarinList;
  this.processList = processList;
  this.construct = constructSindarinFromList;
  this.writeProcesses = SindarinWriteProcesses;
  this.writeBody = SindarinWriteBody;
}
