(* targets_Kmatrix.ml --

   Copyright (C) 1999-2015 by

       Wolfgang Kilian <kilian@physik.uni-siegen.de>
       Thorsten Ohl <ohl@physik.uni-wuerzburg.de>
       Juergen Reuter <juergen.reuter@physik.uni-freiburg.de>
       with contributions from
       Marco Sekulla <sekulla@physik.uni-siegen.de>
       Christian Speckner <christian.speckner@physik.uni-freiburg.de>

   WHIZARD is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   WHIZARD is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  *)

module Fortran =
  struct

    open Format

    let nl = print_newline

(* Special functions for the K matrix approach. This might be generalized
   to other functions that have to have access to the parameters and
   coupling constants. At the moment, this is hardcoded. *)

    let print pure_functions = 
      let pure =
        if pure_functions then
          "pure "
        else 
          "" in
      printf "  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"; nl ();
      printf "  !!! Special K matrix functions"; nl (); 
      printf "  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"; nl (); 
      nl();
      printf "  %sfunction width_res (z,res,w_wkm,m,g) result (w)" pure; nl ();
      printf "      real(kind=default), intent(in) :: z, w_wkm, m, g"; nl ();
      printf "      integer, intent(in) :: res"; nl ();
      printf "      real(kind=default) :: w"; nl ();
      printf "      if (z.eq.0 .AND. w_wkm.eq.0 ) then"; nl ();
      printf "        w = 0"; nl ();
      printf "      else"; nl ();
      printf "        if (w_wkm.eq.0) then"; nl ();
      printf "          select case (res)"; nl ();
      printf "            case (1) !!! Scalar isosinglet"; nl ();
      printf "              w = g**2 /32._default/Pi * m**3"; nl ();
      printf "            case (2) !!! Scalar isoquintet"; nl ();
      printf "              w = g**2/128._default/Pi * m**3"; nl ();
      printf "            case (3) !!! Vector isotriplet"; nl ();
      printf "              w = g**2/48._default/Pi * m"; nl ();
      printf "            case (4) !!! Tensor isosinglet"; nl ();
      printf "              w = g**2/960._default/Pi * m**3"; nl ();
      printf "            case (5) !!! Tensor isoquintet"; nl ();
      printf "              w = g**2/3840._default/Pi * m**3"; nl ();
      printf "            case default"; nl ();
      printf "              w = 0"; nl ();
      printf "          end select"; nl ();
      printf "        else"; nl ();
      printf "          w = w_wkm"; nl ();
      printf "        end if"; nl ();
      printf "      end if"; nl ();
      printf "  end function width_res"; nl ();          
      nl ();
      printf "  %sfunction s0stu (s, m) result (s0)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s, m"; nl ();
      printf "      real(kind=default) :: s0"; nl ();
      printf "      if (m.ge.1.0e08) then"; nl ();
      printf "        s0 = 0"; nl ();  
      printf "      else"; nl ();
      printf "        s0 = m**2 - s/2 + m**4/s * log(m**2/(s+m**2))"; nl ();
      printf "      end if"; nl ();
      printf "  end function s0stu"; nl(); 
      nl ();
      printf "  %sfunction s1stu (s, m) result (s1)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s, m"; nl ();
      printf "      real(kind=default) :: s1"; nl ();
      printf "      if (m.ge.1.0e08) then"; nl ();
      printf "        s1 = 0"; nl ();  
      printf "      else"; nl ();
      printf "        s1 = 2*m**4/s + s/6 + m**4/s**2*(2*m**2+s) &"; nl();
      printf "             * log(m**2/(s+m**2))"; nl ();
      printf "      end if"; nl ();
      printf "  end function s1stu"; nl(); 
      nl ();
      printf "  %sfunction s2stu (s, m) result (s2)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s, m"; nl ();
      printf "      real(kind=default) :: s2"; nl ();
      printf "      if (m.ge.1.0e08) then"; nl ();
      printf "        s2 = 0"; nl ();  
      printf "      else"; nl ();
      printf "        s2 = m**4/s**2 * (6*m**2 + 3*s) + &"; nl();
      printf "             m**4/s**3 * (6*m**4 + 6*m**2*s + s**2) &"; nl();
      printf "             * log(m**2/(s+m**2))"; nl ();
      printf "      end if"; nl ();
      printf "  end function s2stu"; nl(); 
      nl ();
      printf " !! %sfunction s3stu (s, m) result (s3)" pure; nl ();
      printf " !!     real(kind=default), intent(in) :: s, m"; nl ();
      printf " !!     real(kind=default) :: s3"; nl ();
      printf " !!     if (m.ge.1.0e08) then"; nl ();
      printf " !!       s3 = 0"; nl ();  
      printf " !!     else"; nl ();
      printf " !!       s3 = m**4/s**3 * (60*m**4 + 60*m**2*s+11*s**2) + &"; nl();
      printf " !!            m**4/s**4 *(2*m**2+s) (10*m**4 + 10*m**2*s + s**2) &"; nl();
      printf " !!            * log(m**2/(s+m**2))"; nl ();
      printf " !!     end if"; nl ();
      printf " !!  end function s3stu"; nl(); 
      nl ();
      printf "  %sfunction p0stu (s, m) result (p0)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s, m"; nl ();
      printf "      real(kind=default) :: p0"; nl ();
      printf "      if (m.ge.1.0e08) then"; nl ();
      printf "        p0 = 0"; nl ();  
      printf "      else"; nl ();
      printf "        p0 = 1._default + (2*s+m**2)*log(m**2/(s+m**2))/s"; nl ();
      printf "      end if"; nl (); 
      printf "  end function p0stu"; nl(); 
      nl ();
      printf "  %sfunction p1stu (s, m) result (p1)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s, m"; nl ();
      printf "      real(kind=default) :: p1"; nl ();
      printf "      if (m.ge.1.0e08) then"; nl ();
      printf "        p1 = 0"; nl ();  
      printf "      else"; nl ();
      printf "        p1 = (m**2 + 2*s)/s**2 * (2*s+(2*m**2+s) &"; nl(); 
      printf "                * log(m**2/(s+m**2)))"; nl ();
      printf "      end if"; nl ();
      printf "  end function p1stu"; nl(); 
      nl ();
      printf "  %sfunction d0stu (s, m) result (d0)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s, m"; nl ();
      printf "      real(kind=default) :: d0"; nl ();
      printf "      if (m.ge.1.0e08) then"; nl ();
      printf "        d0 = 0"; nl ();  
      printf "      else"; nl ();
      printf "        d0 = (2*m**2+11*s)/2 + (m**4+6*m**2*s+6*s**2) &"; nl();
      printf "              /s * log(m**2/(s+m**2))"; nl ();
      printf "      end if"; nl ();
      printf "  end function d0stu"; nl(); 
      nl ();
      printf "  %sfunction d1stu (s, m) result (d1)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s, m"; nl ();
      printf "      real(kind=default) :: d1"; nl ();
      printf "      if (m.ge.1.0e08) then"; nl ();
      printf "        d1 = 0"; nl ();  
      printf "      else"; nl ();
      printf "        d1 = (s*(12*m**4 + 72*m**2*s + 73*s**2) &"; nl();
      printf "            + 6*(2*m**2 + s)*(m**4 + 6*m**2*s + 6*s**2) &"; nl();
      printf "            * log(m**2/(s+m**2)))/6/s**2"; nl ();
      printf "      end if"; nl ();
      printf "  end function d1stu"; nl(); 
      nl ();
      printf "  %sfunction da00 (cc, s, m) result (amp_00)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: a00_0, a00_a, a00_f"; nl ();
      printf "      complex(kind=default), dimension(1:7) :: a00"; nl ();
      printf "      complex(kind=default) :: ii, jj, amp_00"; nl ();
      printf "      real(kind=default) :: kappal, kappam, kappat"; nl ();
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      jj = s**2 * ii"; nl ();
      printf "      kappal = 0*((mass(23)**2+mass(24)**2)/m(4)**2-2*mass(23)**2*mass(24)**2/m(4)**4)"; nl ();
      printf "      kappam = 0*((mass(23)**4+mass(24)**4)/m(4)**2/(mass(23)**2+mass(24)**2) &"; nl (); 
      printf "                 - 2*mass(23)**2*mass(24)**2/m(4)**4)"; nl ();
      printf "      kappat = 0*mass(23)**2*mass(24)**2/m(4)**4"; nl ();
      printf "      !!! Longitudinal"; nl ();
      printf "      !!! Scalar isosinglet"; nl ();
      printf "      a00(1) = - cc(1)**2 * s0stu(s,m(1)) / 2 "; nl ();
      printf "      if (cc(1) /= 0) then"; nl ();
      printf "        a00(1) = a00(1) - 3/4.0_default *cc(1)**2 * &"; nl (); 
      printf "                  s**2/cmplx(s-m(1)**2,m(1)*wkm(1),default) "; nl ();
      printf "      end if"; nl ();
      printf "      !!! Scalar isoquintet"; nl ();
      printf "      a00(2) = -7*cc(2)**2 * s0stu(s,m(2))/8.0_default"; nl ();
      printf "      if (cc(2) /= 0) then"; nl ();
      printf "        a00(2) = a00(2) - 1/16.0_default *cc(2)**2 * &"; nl (); 
      printf "                  s**2/cmplx(s-m(2)**2,m(2)*wkm(2),default) "; nl ();
      printf "      end if"; nl ();
      printf "      !!! Vector isotriplet"; nl ();
      printf "      a00(3) = -cc(3)**2*(4*p0stu(s,m(3)) + 6*s/m(3)**2)"; nl ();
      printf "      !!! Tensor isosinglet"; nl ();
      printf "      a00(4) = -cc(4)**2 * (d0stu(s,m(4))/12.0_default)"; nl ();
      printf "      if ( (cc(4) /= 0).and.(cc(13) /= 2)) then"; nl ();
      printf "        a00(4) = a00(4) + cc(4)**2 * (cc(13) - 2.0_default) * &"; nl (); 
      printf "                   cc(13)* ( 1.0_default / 16.0_default *  &"; nl (); 
      printf "                  s**2/cmplx(s-m(4)**2,m(4)*wkm(4),default)& "; nl ();
      printf "                   + s0stu(s,m(4))/24.0_default)"; nl ();
      printf "      end if"; nl ();
      printf "      !!! Tensor isoquintet"; nl ();
      printf "      a00(5) = -7*cc(5)**2 * d0stu(s,m(5))/ 48.0_default "; nl ();
      printf "      !!! Transversal"; nl ();
      printf "      !!! Tensor isosinglet"; nl ();
      printf "      a00(6) = - cc(9)**2/Pi/vev**6*mass(23)**2*mass(24)**2* s**2 &"; nl ();
      printf "                * ((2-2*s/m(4)**2+s**2/m(4)**4)+kappat/2._default )/4"; nl ();
      printf "      if (a00(6) /= 0) then"; nl ();
      printf "        a00(6) = a00(6)/cmplx(s-m(4)**2, - w_res/Pi * real(a00(6),default)/32,default) "; nl ();
      printf "      end if"; nl ();
      printf "      a00(6) = a00(6) - cc(9)**2/Pi/vev**6*mass(23)**2*mass(24)**2 * (s0stu(s,m(4)) &"; nl ();
      printf "               * (3*(1._default+2*s/m(4)**2+2*s**2/m(4)**4)+kappat ))/12"; nl ();
      printf "      !!! Mixed"; nl ();
      printf "      !!! Tensor isosinglet"; nl ();
      printf "      a00(7) = - cc(11)*cc(9)*cc(4)/Pi/vev**4*(mass(23)**2+mass(24)**2) * s**2 &"; nl (); 
      printf "               *  ((1._default-4*s/m(4)**2+2*s**2/m(4)**4)+kappam )/4"; nl ();
      printf "      if (a00(7) /= 0) then"; nl ();
      printf "        a00(7) = a00(7)/cmplx(s-m(4)**2, - w_res/Pi/32 * real(a00(7),default),default) "; nl ();
      printf "      end if"; nl ();
      printf "      a00(7) = a00(7) - cc(11)*cc(9)*cc(4)/Pi/vev**4*(mass(23)**2+mass(24)**2) * (s0stu(s,m(4)) &"; nl ();
      printf "              * (12*s/m(4)**2+12*s**2/m(4)**4+2*kappam ))/12"; nl ();
      printf "      !!! Fudge-Higgs"; nl ();
      printf "      a00_f = 2.*fudge_higgs*s/vev**2"; nl ();
      printf "      a00_f = a00_f !!! - 0*5*(1._default-ghvva)**2/vev**2*mass(25)**2"; nl (); 
      printf "      !!! Low energy theory alphas"; nl ();
      printf "      a00_0 = (7*fs0 + 11*fs1)/ 6.0_default *s**2"; nl ();
      printf "      a00_a =  a00_0 "; nl ();
      printf "      !!! Unitarize"; nl ();
      printf "      if (fudge_km /= 0) then"; nl ();
      printf "        amp_00 = sum(a00)+a00_f+a00_a"; nl();
      printf "        if (amp_00 /= 0) then"; nl ();
      printf "          amp_00 = - a00_a - a00_f - part_r * (sum(a00) - a00(3)) &"; nl ();
      printf "            + 1/(real(1/amp_00,default)-ii)"; nl();
      printf "      !!! Validation !!!"; nl ();
      printf "      !!! amp_00 = - a00_a - a00_f - part_r * (sum(a00) - a00(3))"; nl();
      printf "        end if"; nl ();
      printf "      else"; nl ();
      printf "        amp_00 = (1-part_r) * sum(a00) + part_r * a00(3)"; nl ();
      printf "      end if"; nl ();
      printf "      if (unit_limit) then"; nl ();
      printf "        amp_00 = 32 * Pi * ( (0._default,0.5_default) + 0.5_default * &"; nl ();
      printf "                 exp(cmplx(0._default,Pi * (amp00 - 0.5_default),default) ) ) "; nl ();
      printf "      end if"; nl ();
      printf "      amp_00 = vev**4/s**2 * amp_00"; nl ();
      printf "  end function da00"; nl();
      nl ();
      printf "  %sfunction da02 (cc, s, m) result (amp_02)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: a02_0, a02_a"; nl ();
      printf "      complex(kind=default), dimension(1:7) :: a02"; nl ();
      printf "      complex(kind=default) :: ii, jj, amp_02"; nl ();
      printf "      real(kind=default) :: kappal, kappam, kappat"; nl ();
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      jj = s**2*ii"; nl ();
      printf "      kappal = cc(12)*((mass(23)**2+mass(24)**2)/m(4)**2-2*mass(23)**2*mass(24)**2/m(4)**4)"; nl ();
      printf "      kappam = cc(12)*((mass(23)**4+mass(24)**4)/m(4)**2/(mass(23)**2+mass(24)**2) &"; nl (); 
      printf "           - 2*mass(23)**2*mass(24)**2/m(4)**4)"; nl ();
      printf "      kappat = cc(12)*mass(23)**2*mass(24)**2/m(4)**4"; nl ();
      printf "      !!! Longitudinal"; nl ();
      printf "      !!! Scalar  isosinglet"; nl ();
      printf "      a02(1) = -cc(1)**2/2.0_default * s2stu(s,m(1))"; nl ();
      printf "      !!! Scalar isoquintet"; nl ();
      printf "      a02(2) = -7*cc(2)**2 * s2stu(s,m(2)) / 8.0_default"; nl ();
      printf "      !!! Vector isotriplet"; nl (); 
      printf "      a02(3) = -4*cc(3)**2*(2*s+m(3)**2)*s2stu(s,m(3))/m(3)**4"; nl ();
      printf "      !!! Tensor isosinglet"; nl (); 
      printf "      a02(4) = - cc(4)**2 / 12.0_default * &"; nl ();
      printf "             ((1._default+6*s/m(4)**2+6*s**2/m(4)**4)) * s2stu(s,m(4))"; nl ();
      printf "      if (cc(4) /= 0) then"; nl ();
      printf "        a02(4) = a02(4) - cc(4)**2/40.0_default &"; nl (); 
      printf "                  * s**2/cmplx(s-m(4)**2,m(4)*wkm(4),default)"; nl ();
      printf "      end if"; nl ();
      printf "      if ( (cc(4) /= 0).and.(cc(13) /= 2)) then"; nl ();
      printf "        a02(4) = a02(4) + cc(4)**2 * (cc(13) - 2.0_default) * &"; nl (); 
      printf "                 cc(13) * s2stu(s,m(4))/24.0_default"; nl ();
      printf "      end if"; nl ();
      printf "      !!! Tensor isoquintet"; nl ();
      printf "      a02(5) = -cc(5)**2 * 7.0_default / 48.0_default *(1._default+6* &"; nl ();
      printf "               s/m(5)**2+6*s**2/m(5)**4)*s2stu(s,m(5)) "; nl (); 
      printf "      if (cc(5) /= 0) then"; nl ();
      printf "        a02(5) = a02(5) - cc(5)**2/480.0_default &"; nl (); 
      printf "                  * s**2/cmplx(s-m(5)**2,m(5)*wkm(5),default)"; nl ();
      printf "      end if"; nl ();
      printf "      !!! Transversal"; nl ();
      printf "      !!! Tensor isosinglet"; nl ();
      printf "      a02(6) = - cc(9)**2/Pi/vev**6*mass(23)**2*mass(24)**2 * s**2/40"; nl ();
      printf "      if (a02(6) /= 0) then"; nl ();
      printf "        a02(6) = a02(6)/cmplx(s-m(4)**2, - w_res/32/Pi * real(a02(6),default),default) "; nl ();
      printf "      end if"; nl ();
      printf "      a02(6) = a02(6) - cc(9)**2/Pi/vev**6*mass(23)**2*mass(24)**2 * (s2stu(s,m(4)) &"; nl ();
      printf "             * (3*(1._default+2*s/m(4)**2+2*s**2/m(4)**4)+kappat ))/12"; nl ();
      printf "      !!! Mixed"; nl ();
      printf "      !!! Tensor isosinglet"; nl ();
      printf "      a02(7) = - cc(11)*cc(9)*cc(4)/Pi/vev**4*(mass(23)**2+mass(24)**2) &"; nl (); 
      printf "               * s**2/20"; nl ();
      printf "      if (a02(7) /= 0) then"; nl ();
      printf "        a02(7) = a02(7)/cmplx(s-m(4)**2, - w_res/Pi/32 * real(a02(7),default),default) "; nl ();
      printf "      end if"; nl ();
      printf "      a02(7) = a02(7) - cc(11)*cc(9)*cc(4)/Pi/vev**4*(mass(23)**2+mass(24)**2) * (s2stu(s,m(4)) &"; nl ();
      printf "              * (12*s/m(4)**2+12*s**2/m(4)**4+2*kappam ))/12"; nl ();
      printf "      !!! Low energy theory alphas"; nl ();
      printf "      a02_0 = (2*fs0 + fs1) / 30._default *  s**2"; nl ();
      printf "      a02_a = a02_0 "; nl ();
      printf "      !!! Unitarize"; nl ();
      printf "      if (fudge_km /= 0) then"; nl ();
      printf "        amp_02 = sum(a02)+a02_a"; nl();
      printf "        if (amp_02 /= 0) then"; nl ();
      printf "          amp_02 = - a02_a - part_r * (sum(a02) - a02(3)) &"; nl ();
      printf "                   + 1/(real(1/amp_02,default)-ii)"; nl();
      printf "      !!! Validation !!!"; nl ();
      printf "      !!! amp_02 = - a02_a - part_r * (sum(a02) - a02(3))"; nl();
      printf "        end if"; nl ();
      printf "      else"; nl ();
      printf "        amp_02 = (1._default-part_r) * sum(a02) + part_r * a02(3)"; nl ();
      printf "      end if"; nl ();
      printf "      if (unit_limit) then"; nl ();
      printf "        amp_02 = 32 * Pi * ( (0.0_default,0.5_default) + 0.5_default * &"; nl ();
      printf "                 exp(cmplx(0._default,Pi * (amp02 - 0.5_default),default) ) ) "; nl ();
      printf "      end if"; nl ();
      printf "     amp_02 = vev**4/s**2 * amp_02"; nl ();
      printf "  end function da02"; nl(); 
      nl ();
      printf "  %sfunction da11 (cc, s, m) result (amp_11)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: a11_0, a11_a, a11_f"; nl ();
      printf "      complex(kind=default), dimension(1:7) :: a11"; nl ();
      printf "      complex(kind=default) :: ii, jj, amp_11"; nl ();
      printf "      real(kind=default) :: kappal, kappam, kappat"; nl ();
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      jj = s**2*ii"; nl ();
      printf "      kappal = cc(12)*((mass(23)**2+mass(24)**2)/m(4)**2-2*mass(23)**2*mass(24)**2/m(4)**4)"; nl ();
      printf "      kappam = cc(12)*((mass(23)**4+mass(24)**4)/m(4)**2/(mass(23)**2+mass(24)**2) &"; nl (); 
      printf "               - 2*mass(23)**2*mass(24)**2/m(4)**4)"; nl ();
      printf "      kappat = cc(12)*mass(23)**2*mass(24)**2/m(4)**4"; nl ();
      printf "      !!! Longitudinal"; nl ();
      printf "      !!! Scalar isosinglet"; nl ();
      printf "      a11(1) = - cc(1)**2/2.0_default * s1stu(s,m(1))"; nl ();
      printf "      !!! Scalar isoquintet"; nl ();
      printf "      a11(2) = 3*cc(2)**2 * s1stu(s,m(2)) / 8.0_default"; nl ();
      printf "      !!! Vector isotriplet"; nl ();
      printf "      a11(3) = - cc(3)**2 * &"; nl ();
      printf "                 (s/m(3)**2 + 2 * p1stu(s,m(3)))"; nl ();
      printf "      if (cc(3) /= 0) then"; nl ();
      printf "        a11(3) = a11(3) -2 * cc(3)**2 * &"; nl (); 
      printf "                 s/cmplx(s-m(3)**2,m(3)*wkm(3),default)/3 "; nl ();
      printf "      end if"; nl ();
      printf "      !!! Tensor isosinglet"; nl ();
      printf "      a11(4) = - cc(4)**2* d1stu(s,m(4)) &"; nl ();
      printf "               /12.0_default "; nl ();
      printf "      if ( (cc(4) /= 0).and.(cc(13) /= 2)) then"; nl ();
      printf "        a11(4) = a11(4) + cc(4)**2 * (cc(13) - 2.0_default) * &"; nl (); 
      printf "                 cc(13) * s1stu(s,m(4))/24.0_default "; nl ();
      printf "      end if"; nl ();
      printf "      !!! Tensor isoquintet"; nl ();
      printf "      a11(5) =  cc(5)**2 / 16.0_default * d1stu(s,m(5)) "; nl ();
      printf "      !!! Transversal"; nl ();
      printf "      !!! Tensor isosinglet"; nl ();
      printf "      a11(6) = -cc(9)**2/Pi/vev**6*mass(23)**2*mass(24)**2/12._default * (s1stu(s,m(4)) * &"; nl ();
      printf "             (3*(1._default+2*s/m(4)**2+2*s**2/m(4)**4)+kappat ) - (s/m(4)**2+s**2/m(4)**4)*s)"; nl ();
      printf "      !!! Mixed"; nl ();
      printf "      !!! Tensor isosinglet"; nl ();
      printf "      a11(7) = -cc(11)*cc(9)*cc(4)/Pi/vev**4*(mass(23)**2+mass(24)**2)/12._default &"; nl ();
      printf "               * (s1stu(s,m(4)) * (12*s/m(4)**2+12*s**2/m(4)**4+2*kappam ) &"; nl ();
      printf "               - 2*(s/m(4)**2+s**2/m(4)**4)*s)"; nl ();
      printf "      !!! Fudge-Higgs"; nl ();
      printf "      a11_f = fudge_higgs*s/vev**2/3"; nl ();
      printf "      !!! Low energy theory alphas"; nl ();
      printf "      a11_0 = (fs0 - 2*fs1) / 12.0_default * s**2  "; nl ();
      printf "      a11_a = a11_0"; nl ();
      printf "      !!! Unitarize"; nl ();
      printf "      if (fudge_km /= 0) then"; nl ();
      printf "        amp_11 = sum(a11)+a11_f+a11_a"; nl();
      printf "        if (amp_11 /= 0) then"; nl ();
      printf "          amp_11 = -a11_a - part_r * (sum(a11) - a11(3))&"; nl ();
      printf "               + 1/(real(1/amp_11,default)-ii)"; nl();
      printf "      !!! Validation !!!"; nl ();
      printf "      !!! amp_11 = - a11_a - part_r * (sum(a11) - a11(3))"; nl();
      printf "        end if"; nl ();
      printf "      else"; nl ();
      printf "        amp_11 = (1._default-part_r) * sum(a11) + part_r * a11(3)"; nl ();
      printf "      end if"; nl ();
      printf "      if (unit_limit) then"; nl ();
      printf "        amp_11 = 32 * Pi * ( (0.0_default,0.5_default) + 0.5_default * &"; nl ();
      printf "                 exp(cmplx(0._default,Pi * (amp11 - 0.5_default),default) ) ) "; nl ();
      printf "      end if"; nl ();
      printf "     amp_11 = vev**4/s**2 * amp_11"; nl ();
      printf "  end function da11"; nl(); 
      nl ();
      printf "  %sfunction da20 (cc, s, m) result (amp_20)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: a20_0, a20_a, a20_f"; nl ();
      printf "      complex(kind=default), dimension(1:7) :: a20"; nl ();
      printf "      complex(kind=default) :: ii, jj, amp_20"; nl ();
      printf "      real(kind=default) :: kappal, kappam, kappat"; nl ();
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      jj = s**2*ii"; nl ();
      printf "      !!! Scalar isosinglet"; nl ();
      printf "      kappal = cc(12)*((mass(23)**2+mass(24)**2)/m(4)**2-2*mass(23)**2*mass(24)**2/m(4)**4)"; nl ();
      printf "      kappam = cc(12)*((mass(23)**4+mass(24)**4)/m(4)**2/(mass(23)**2+mass(24)**2) &"; nl (); 
      printf "               - 2*mass(23)**2*mass(24)**2/m(4)**4)"; nl ();
      printf "      kappat = cc(12)*mass(23)**2*mass(24)**2/m(4)**4"; nl ();
      printf "      !!! Longitudinal"; nl ();
      printf "      a20(1) = -cc(1)**2/2.0_default * s0stu(s,m(1))"; nl ();
      printf "      !!! Scalar isoquintet"; nl ();
      printf "      a20(2) = - cc(2)**2 * s0stu(s,m(2)) /8.0_default"; nl ();
      printf "      if (cc(2) /= 0) then"; nl ();
      printf "        a20(2) = a20(2) - cc(2)**2 /4.0_default *&"; nl (); 
      printf "                 s**2/cmplx(s-m(2)**2,m(2)*wkm(2),default)"; nl ();
      printf "      end if"; nl ();
      printf "      !!! Vector isotriplet"; nl ();
      printf "      a20(3) = cc(3)**2*(2*p0stu(s,m(3)) + 3*s/m(3)**2)"; nl ();
      printf "      !!! Tensor isosinglet"; nl ();
      printf "      a20(4) = - cc(4)**2* d0stu(s,m(4)) &"; nl ();
      printf "               /12.0_default "; nl (); 
      printf "      if ( (cc(4) /= 0).and.(cc(13) /= 2)) then"; nl ();
      printf "        a20(4) = a20(4) + cc(4)**2 * (cc(13) - 2.0_default) * &"; nl (); 
      printf "                 cc(13) * s0stu(s,m(4))/24.0_default "; nl ();
      printf "      end if"; nl ();
      printf "      !!! Tensor isoquintet"; nl ();
      printf "      a20(5) = - cc(5)**2/ 48.0_default * d0stu(s,m(5)) "; nl ();
      printf "      !!! Transversal"; nl ();
      printf "      !!! Tensor isosinglet"; nl ();
      printf "      a20(6) = -cc(9)**2/Pi/vev**6*mass(23)**2*mass(24)**2/12._default * (s0stu(s,m(4)) &"; nl ();
      printf "             * (3*(1._default+2*s/m(4)**2+2*s**2/m(4)**4)+kappat ) &"; nl ();
      printf "             - 3*(s/m(4)**2-s**2/m(4)**4)*s)"; nl ();
      printf "      !!! Mixed"; nl ();
      printf "      !!! Tensor isosinglet"; nl ();
      printf "      a20(7) = -cc(11)*cc(9)*cc(4)/Pi/vev**4*(mass(23)**2+mass(24)**2)/12._default &"; nl ();
      printf "               * (s0stu(s,m(4)) * (12*s/m(4)**2+12*s**2/m(4)**4+2*kappam ) &"; nl ();
      printf "               - 6*(s/m(4)**2-s**2/m(4)**4)*s)"; nl ();
      printf "      !!! Fudge-Higgs"; nl ();
      printf "      a20_f = - fudge_higgs*s/vev**2"; nl ();
      printf "      a20_f = a20_f !!! - 0*2*(1._default-ghvva)**2/vev**2*mass(25)**2"; nl (); 
      printf "      !!! Low energy theory alphas"; nl ();
      printf "      a20_0 =  (2*fs0 + fs1) / 3.0_default * s**2"; nl ();
      printf "      a20_a = a20_0 "; nl ();
      printf "      !!! Unitarize"; nl ();
      printf "      if (fudge_km /= 0) then"; nl ();
      printf "        amp_20 = sum(a20)+a20_f+a20_a"; nl();
      printf "        if (amp_20 /= 0) then"; nl ();
      printf "          amp_20 = - a20_a - a20_f - part_r * (sum(a20) - a20(3)) &"; nl ();
      printf "                   + 1/(real(1/amp_20,default)-ii)"; nl();
      printf "      !!! Validation !!!"; nl ();
      printf "      !!! amp_20 = - a20_a - a20_f - part_r * (sum(a20) - a20(3)) "; nl();
      printf "        end if"; nl ();
      printf "      else"; nl ();
      printf "        amp_20 = (1-part_r) * sum(a20) + part_r * a20(3)"; nl ();
      printf "      end if"; nl ();
      printf "      if (unit_limit) then"; nl ();
      printf "        amp_20 = 32 * Pi * ( (0.0_default,0.5_default) + 0.5_default * &"; nl ();
      printf "                 exp(cmplx(0._default,Pi * (amp20 - 0.5_default),default) ) ) "; nl ();
      printf "      end if"; nl ();
      printf "     amp_20 = vev**4/s**2 * amp_20"; nl ();
      printf "  end function da20"; nl(); 
      nl ();
      printf "  %sfunction da22 (cc, s, m) result (amp_22)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: a22_0, a22_1, a22_a, a22_r"; nl ();
      printf "      complex(kind=default), dimension(1:7) :: a22"; nl ();
      printf "      complex(kind=default) :: ii, jj, amp_22"; nl ();
      printf "      real(kind=default) :: kappal, kappam, kappat"; nl ();
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      jj = s**2*ii"; nl ();
      printf "      kappal = cc(12)*((mass(23)**2+mass(24)**2)/m(4)**2-2*mass(23)**2*mass(24)**2/m(4)**4)"; nl ();
      printf "      kappam = cc(12)*((mass(23)**4+mass(24)**4)/m(4)**2/(mass(23)**2+mass(24)**2) &"; nl (); 
      printf "                 - 2*mass(23)**2*mass(24)**2/m(4)**4)"; nl ();
      printf "      kappat = cc(12)*mass(23)**2*mass(24)**2/m(4)**4"; nl ();
      printf "      !!! Longitudinal"; nl ();
      printf "      !!! Scalar isosinglet"; nl ();
      printf "      a22(1) = - cc(1)**2/2.0_default * s2stu(s,m(1))"; nl ();
      printf "      !!! Scalar isoquintet"; nl ();
      printf "      a22(2) = - cc(2)**2 * s2stu(s,m(2))/ 8.0_default"; nl ();
      printf "      !!! Vector triplet"; nl ();
      printf "      a22(3) = 2*cc(3)**2*(2*s+m(3)**2)*s2stu(s,m(3))/m(3)**4"; nl ();
      printf "      !!! Tensor isosinglet"; nl ();
      printf "      a22(4) = - cc(4)**2*((1._default + 6*s/m(4)**2 &"; nl ();
      printf "            +6*s**2/m(4)**4)*s2stu(s,m(4))/12.0_default)"; nl ();
      printf "      if ( (cc(4) /= 0).and.(cc(13) /= 2)) then"; nl ();
      printf "        a22(4) = a22(4) + cc(4)**2 * (cc(13) - 2.0_default) * &"; nl (); 
      printf "                  cc(13) * s2stu(s,m(4)) / 24.0_default "; nl ();
      printf "      end if"; nl ();
      printf "      !!! Tensor isoquintet"; nl ();
      printf "      a22(5) = - cc(5)**2/48._default * &"; nl ();
      printf "                 ((1._default+6*s/m(5)**2+6*s**2/m(5)**4 ) &"; nl (); 
      printf "                 * s2stu(s,m(5)))"; nl ();
      printf "      if (cc(5) /= 0) then"; nl ();
      printf "        a22(5) = a22(5) - cc(5)**2/120._default * &"; nl (); 
      printf "               s**2/cmplx(s-m(5)**2,m(5)*wkm(5),default)"; nl ();
      printf "      end if"; nl ();
      printf "      !!! Transversal"; nl ();
      printf "      !!! Tensor isosinglet"; nl ();
      printf "      a22(6) = -cc(9)**2/Pi/vev**6*mass(23)**2*mass(24)**2 * (s2stu(s,m(4)) &"; nl ();
      printf "              * (3*(1._default+2*s/m(4)**2+2*s**2/m(4)**4)+kappat ))/12"; nl ();
      printf "      !!! Mixed"; nl ();
      printf "      !!! Tensor isosinglet"; nl ();
      printf "      a22(7) = -cc(11)*cc(9)*cc(4)/Pi/vev**4*(mass(23)**2+mass(24)**2) * (s2stu(s,m(4)) &"; nl ();
      printf "              * (12*s/m(4)**2+12*s**2/m(4)**4+2*kappam ))/12"; nl ();
      printf "      !!! Low energy theory alphas"; nl ();
      printf "      a22_0 = (fs0 + 2*fs1)/60._default*s**2 "; nl ();
      printf "      a22_a = a22_0"; nl ();
      printf "      !!! Unitarize"; nl ();
      printf "      if (fudge_km /= 0) then"; nl ();
      printf "        amp_22 = sum(a22)+a22_a"; nl();
      printf "        if (amp_22 /= 0) then"; nl ();
      printf "          amp_22 = - a22_a - part_r * (sum(a22) - a22(3)) & "; nl ();
      printf "                + 1/(real(1/amp_22,default)-ii)"; nl();
      printf "      !!! Validation !!!"; nl ();
      printf "      !!! amp_22 = - a22_a - part_r * (sum(a22) - a22(3))"; nl();
      printf "        end if"; nl ();
      printf "      else"; nl ();
      printf "        amp_22 = (1-part_r) * sum(a22) + part_r * a22(3)"; nl ();
      printf "      end if"; nl ();
      printf "      if (unit_limit) then"; nl ();
      printf "        amp_22 = 32 * Pi * ( (0.0_default,0.5_default) + 0.5_default * &"; nl ();
      printf "                 exp(cmplx(0._default,Pi * (amp22 - 0.5_default),default) ) )"; nl ();
      printf "      end if"; nl ();
      printf "     amp_22 = vev**4/s**2 * amp_22"; nl ();
      printf "  end function da22"; nl();
      nl ();
      printf "  %sfunction s0stu_t (s, m) result (s0)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s, m"; nl ();
      printf "      real(kind=default) :: s0"; nl ();
      printf "      if (m.ge.1.0e08) then"; nl ();
      printf "        s0 = 0"; nl ();  
      printf "      else"; nl ();
      printf "        s0 = (m**2/3 - m**4/(2*s) + m**6/s**2 - s/4 + m**8/s**3 * log(m**2/(m**2+s)))"; nl ();
      printf "      end if"; nl ();
      printf "  end function s0stu_t"; nl(); 
      nl ();      
      printf "  %sfunction dat00_0 (cc, s, m) result (ampt_00)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: ii, ampt_00"; nl (); 
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      ampt_00 = -g**4*6*ft0*s**2"; nl ();            
      printf "      if (ampt_00 /= 0) then"; nl ();
      printf "        ampt_00 = 1/(1/ampt_00 - ii) - ampt_00"; nl ();
      printf "      else"; nl ();
      printf "        ampt_00 = 0"; nl ();
      printf "      end if "; nl ();
      printf "      if (fudge_km == 0) then"; nl ();    
      printf "        ampt_00 = 0"; nl ();
      printf "      end if"; nl ();  
      printf "      ampt_00 = ampt_00 / (s**2 * g**4)"; nl ();
      printf "  end function dat00_0"; nl ();
      nl ();
      printf "  %sfunction dat02_0 (cc, s, m) result (ampt_02)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: ii, ampt_02"; nl (); 
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      ampt_02 = -g**4*2/5*ft0*s**2"; nl ();      
      printf "      if (ampt_02 /= 0) then"; nl ();
      printf "        ampt_02 = 1/(1/ampt_02 - ii) - ampt_02"; nl ();
      printf "      else"; nl ();
      printf "        ampt_02 = 0"; nl ();
      printf "      end if "; nl ();
      printf "      if (fudge_km == 0) then"; nl ();    
      printf "        ampt_02 = 0"; nl ();
      printf "      end if"; nl ();    
      printf "      ampt_02 = ampt_02 / (s**2 * g**4)"; nl ();      
      printf "  end function dat02_0"; nl ();  
      nl ();    
      printf "  %sfunction dat12_0 (cc, s, m) result (ampt_12)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: ii, ampt_12"; nl ();    
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      ampt_12 = -g**4*2/5*ft0*s**2"; nl ();        
      printf "      if (ampt_12 /= 0) then"; nl ();
      printf "        ampt_12 = 1/(1/ampt_12 - ii) - ampt_12"; nl ();
      printf "      else"; nl ();
      printf "        ampt_12 = 0"; nl ();
      printf "      end if "; nl ();
      printf "      if (fudge_km == 0) then"; nl ();    
      printf "        ampt_12 = 0"; nl ();
      printf "      end if"; nl ();    
      printf "      ampt_12 = ampt_12 / (s**2 * g**4)"; nl ();      
      printf "  end function dat12_0"; nl ();
      nl ();             
      printf "  %sfunction dat22_0 (cc, s, m) result (ampt_22)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: ii, ampt_22"; nl ();     
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      ampt_22 = -g**4*2/5*ft0*s**2"; nl ();     
      printf "      if (ampt_22 /= 0) then"; nl ();
      printf "        ampt_22 = 1/(1/ampt_22 - ii) - ampt_22"; nl ();
      printf "      else"; nl ();
      printf "        ampt_22 = 0"; nl ();
      printf "      end if "; nl ();
      printf "      if (fudge_km == 0) then"; nl ();    
      printf "        ampt_22 = 0"; nl ();
      printf "      end if"; nl ();
      printf "      ampt_22 = ampt_22 / (s**2 * g**4)"; nl ();      
      printf "  end function dat22_0"; nl ();      
      nl ();      
      printf "  %sfunction dat00_1 (cc, s, m) result (ampt_00)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: ii, ampt_00"; nl (); 
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      ampt_00 = - g**4*3*ft1*s**2"; nl ();              
      printf "      if (ampt_00 /= 0) then"; nl ();
      printf "        ampt_00 = 1/(1/ampt_00 - ii) - ampt_00"; nl ();
      printf "      else"; nl ();
      printf "        ampt_00 = 0"; nl ();
      printf "      end if "; nl ();
      printf "      if (fudge_km == 0) then"; nl ();    
      printf "        ampt_00 = 0"; nl ();
      printf "      end if"; nl ();  
      printf "      ampt_00 = ampt_00 / (s**2 * g**4)"; nl ();
      printf "  end function dat00_1"; nl ();
      nl ();
      printf "  %sfunction dat02_1 (cc, s, m) result (ampt_02)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: ii, ampt_02"; nl (); 
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      ampt_02 = - g**4*1/5*ft1*s**2"; nl ();    
      printf "      if (ampt_02 /= 0) then"; nl ();
      printf "        ampt_02 = 1/(1/ampt_02 - ii) - ampt_02"; nl ();
      printf "      else"; nl ();
      printf "        ampt_02 = 0"; nl ();
      printf "      end if "; nl ();
      printf "      if (fudge_km == 0) then"; nl ();    
      printf "        ampt_02 = 0"; nl ();
      printf "      end if"; nl ();    
      printf "      ampt_02 = ampt_02 / (s**2 * g**4)"; nl ();      
      printf "  end function dat02_1"; nl ();  
      nl ();    
      printf "  %sfunction dat12_1 (cc, s, m) result (ampt_12)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: ii, ampt_12"; nl ();    
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      ampt_12 = - g**4*1/5*ft1*s**2"; nl ();         
      printf "      if (ampt_12 /= 0) then"; nl ();
      printf "        ampt_12 = 1/(1/ampt_12 - ii) - ampt_12"; nl ();
      printf "      else"; nl ();
      printf "        ampt_12 = 0"; nl ();
      printf "      end if "; nl ();
      printf "      if (fudge_km == 0) then"; nl ();    
      printf "        ampt_12 = 0"; nl ();
      printf "      end if"; nl ();    
      printf "      ampt_12 = ampt_12 / (s**2 * g**4)"; nl ();      
      printf "  end function dat12_1"; nl ();
      nl ();             
      printf "  %sfunction dat22_1 (cc, s, m) result (ampt_22)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: ii, ampt_22"; nl ();     
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      ampt_22 = - g**4*1/5*ft1*s**2"; nl ();        
      printf "      if (ampt_22 /= 0) then"; nl ();
      printf "        ampt_22 = 1/(1/ampt_22 - ii) - ampt_22"; nl ();
      printf "      else"; nl ();
      printf "        ampt_22 = 0"; nl ();
      printf "      end if "; nl ();
      printf "      if (fudge_km == 0) then"; nl ();    
      printf "        ampt_22 = 0"; nl ();
      printf "      end if"; nl ();
      printf "      ampt_22 = ampt_22 / (s**2 * g**4)"; nl ();      
      printf "  end function dat22_1"; nl ();
      nl ();      
      printf "  %sfunction dat00_2 (cc, s, m) result (ampt_00)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: ii, ampt_00"; nl (); 
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      ampt_00 = -g**4*3/2*ft2*s**2"; nl ();      
      printf "      if (ampt_00 /= 0) then"; nl ();
      printf "        ampt_00 = 1/(1/ampt_00 - ii) - ampt_00"; nl ();
      printf "      else"; nl ();
      printf "        ampt_00 = 0"; nl ();
      printf "      end if "; nl ();
      printf "      if (fudge_km == 0) then"; nl ();    
      printf "        ampt_00 = 0"; nl ();
      printf "      end if"; nl ();  
      printf "      ampt_00 = ampt_00 / (s**2 * g**4)"; nl ();
      printf "  end function dat00_2"; nl ();
      nl ();
      printf "  %sfunction dat02_2 (cc, s, m) result (ampt_02)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: ii, ampt_02"; nl (); 
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      ampt_02 = -g**4*1/10*ft2*s**2"; nl ();        
      printf "      if (ampt_02 /= 0) then"; nl ();
      printf "        ampt_02 = 1/(1/ampt_02 - ii) - ampt_02"; nl ();
      printf "      else"; nl ();
      printf "        ampt_02 = 0"; nl ();
      printf "      end if "; nl ();
      printf "      if (fudge_km == 0) then"; nl ();    
      printf "        ampt_02 = 0"; nl ();
      printf "      end if"; nl ();    
      printf "      ampt_02 = ampt_02 / (s**2 * g**4)"; nl ();      
      printf "  end function dat02_2"; nl ();  
      nl ();    
      printf "  %sfunction dat11_2 (cc, s, m) result (ampt_11)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: ii, ampt_11"; nl ();    
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      ampt_11 = -g**4*1/6*ft2*s**2"; nl ();       
      printf "      if (ampt_11 /= 0) then"; nl ();
      printf "        ampt_11 = 1/(1/ampt_11 - ii) - ampt_11"; nl ();
      printf "      else"; nl ();
      printf "        ampt_11 = 0"; nl ();
      printf "      end if "; nl ();
      printf "      if (fudge_km == 0) then"; nl ();    
      printf "        ampt_11 = 0"; nl ();
      printf "      end if"; nl ();    
      printf "      ampt_11 = ampt_11 / (s**2 * g**4)"; nl ();      
      printf "  end function dat11_2"; nl ();
      nl ();             
      printf "  %sfunction dat22_2 (cc, s, m) result (ampt_22)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: ii, ampt_22"; nl ();     
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      ampt_22 = -g**4*1/10*ft2*s**2"; nl ();       
      printf "      if (ampt_22 /= 0) then"; nl ();
      printf "        ampt_22 = 1/(1/ampt_22 - ii) - ampt_22"; nl ();
      printf "      else"; nl ();
      printf "        ampt_22 = 0"; nl ();
      printf "      end if "; nl ();
      printf "      if (fudge_km == 0) then"; nl ();    
      printf "        ampt_22 = 0"; nl ();
      printf "      end if"; nl ();
      printf "      ampt_22 = ampt_22 / (s**2 * g**4)"; nl ();      
      printf "  end function dat22_2"; nl ();
      nl ();
      printf "  %sfunction dat00_rsi (cc, s, m) result (ampt_00)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: ii, ampt_00"; nl (); 
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      ampt_00 = 3*g**4*gkm(6)**2*s**2/cmplx(s-m(1)**2,m(1)*wkm(1),default)"; nl ();           
      printf "      if (ampt_00 /= 0) then"; nl ();
      printf "        ampt_00 = 1/(1/ampt_00 - ii) - ampt_00"; nl ();
      printf "      else"; nl ();
      printf "        ampt_00 = 0"; nl ();
      printf "      end if "; nl ();
      printf "      if (fudge_km == 0) then"; nl ();    
      printf "        ampt_00 = 0"; nl ();
      printf "      end if"; nl ();  
      printf "      ampt_00 = ampt_00 / (s**2 * g**4)"; nl ();
      printf "  end function dat00_rsi"; nl ();
      nl ();
      printf "  %sfunction dat02_rsi (cc, s, m) result (ampt_02)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: ii, ampt_02"; nl (); 
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();  
      printf "      ampt_02 = - g**4*4/5*cc(6)**2*s0stu_t(s,m(1))"; nl ();         
      printf "      if (ampt_02 /= 0) then"; nl ();
      printf "        ampt_02 = 1/(1/ampt_02 - ii) - ampt_02"; nl ();
      printf "      else"; nl ();
      printf "        ampt_02 = 0"; nl ();
      printf "      end if "; nl ();
      printf "      if (fudge_km == 0) then"; nl ();    
      printf "        ampt_02 = 0"; nl ();
      printf "      end if"; nl ();    
      printf "      ampt_02 = ampt_02 / (s**2 * g**4)"; nl ();      
      printf "  end function dat02_rsi"; nl ();  
      nl ();    
      printf "  %sfunction dat12_rsi (cc, s, m) result (ampt_12)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: ii, ampt_12"; nl ();    
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      ampt_12 = - g**4*4/5*cc(6)**2*s0stu_t(s,m(1))"; nl ();        
      printf "      if (ampt_12 /= 0) then"; nl ();
      printf "        ampt_12 = 1/(1/ampt_12 - ii) - ampt_12"; nl ();
      printf "      else"; nl ();
      printf "        ampt_12 = 0"; nl ();
      printf "      end if "; nl ();
      printf "      if (fudge_km == 0) then"; nl ();    
      printf "        ampt_12 = 0"; nl ();
      printf "      end if"; nl ();    
      printf "      ampt_12 = ampt_12 / (s**2 * g**4)"; nl ();      
      printf "  end function dat12_rsi"; nl ();
      nl ();             
      printf "  %sfunction dat22_rsi (cc, s, m) result (ampt_22)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: ii, ampt_22"; nl ();     
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      ampt_22 = - g**4*4/5*cc(6)**2*s0stu_t(s,m(1))"; nl ();        
      printf "      if (ampt_22 /= 0) then"; nl ();
      printf "        ampt_22 = 1/(1/ampt_22 - ii) - ampt_22"; nl ();
      printf "      else"; nl ();
      printf "        ampt_22 = 0"; nl ();
      printf "      end if "; nl ();
      printf "      if (fudge_km == 0) then"; nl ();    
      printf "        ampt_22 = 0"; nl ();
      printf "      end if"; nl ();
      printf "      ampt_22 = ampt_22 / (s**2 * g**4)"; nl ();      
      printf "  end function dat22_rsi"; nl ();      
      nl ();   
      printf "  %sfunction dam00 (cc, s, m) result (ampm_00)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: ii, ampm_00"; nl (); 
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      ampm_00 = g**2*3/2*fm0*s**2"; nl ();      
      printf "      if (ampm_00 /= 0) then"; nl ();
      printf "        ampm_00 = 1/(1/ampm_00 - ii) - ampm_00"; nl ();
      printf "      else"; nl ();
      printf "        ampm_00 = 0"; nl ();
      printf "      end if "; nl ();
      printf "      if (fudge_km == 0) then"; nl ();    
      printf "        ampm_00 = 0"; nl ();
      printf "      end if"; nl ();  
      printf "      ampm_00 = ampm_00 / (s**2)"; nl ();
      printf "  end function dam00"; nl ();
      nl ();
      printf "  %sfunction dam01 (cc, s, m) result (ampm_01)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: ii, ampm_01"; nl (); 
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      ampm_01 = -g**2*1/8*fm0*s**2"; nl ();      
      printf "      if (ampm_01 /= 0) then"; nl ();
      printf "        ampm_01 = 1/(1/ampm_01 - ii) - ampm_01"; nl ();
      printf "      else"; nl ();
      printf "        ampm_01 = 0"; nl ();
      printf "      end if "; nl ();
      printf "      if (fudge_km == 0) then"; nl ();    
      printf "        ampm_01 = 0"; nl ();
      printf "      end if"; nl ();  
      printf "      ampm_01 = ampm_01 / (s**2)"; nl ();
      printf "  end function dam01"; nl ();
      nl ();
      printf "  %sfunction dam02 (cc, s, m) result (ampm_02)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: ii, ampm_02"; nl (); 
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      ampm_02 = g**2*1/40*fm0*s**2"; nl ();      
      printf "      if (ampm_02 /= 0) then"; nl ();
      printf "        ampm_02 = 1/(1/ampm_02 - ii) - ampm_02"; nl ();
      printf "      else"; nl ();
      printf "        ampm_02 = 0"; nl ();
      printf "      end if "; nl ();
      printf "      if (fudge_km == 0) then"; nl ();    
      printf "        ampm_02 = 0"; nl ();
      printf "      end if"; nl ();  
      printf "      ampm_02 = ampm_02 / (s**2)"; nl ();
      printf "  end function dam02"; nl ();
      nl (); 
      printf "  %sfunction dam11 (cc, s, m) result (ampm_11)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: ii, ampm_11"; nl (); 
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      ampm_11 = -g**2*1/8*fm0*s**2"; nl ();      
      printf "      if (ampm_11 /= 0) then"; nl ();
      printf "        ampm_11 = 1/(1/ampm_11 - ii) - ampm_11"; nl ();
      printf "      else"; nl ();
      printf "        ampm_11 = 0"; nl ();
      printf "      end if "; nl ();
      printf "      if (fudge_km == 0) then"; nl ();    
      printf "        ampm_11 = 0"; nl ();
      printf "      end if"; nl ();  
      printf "      ampm_11 = ampm_11 / (s**2)"; nl ();
      printf "  end function dam11"; nl ();
      nl ();
      printf "  %sfunction dam12 (cc, s, m) result (ampm_12)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: ii, ampm_12"; nl (); 
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      ampm_12 = g**2*1/40*fm0*s**2"; nl ();      
      printf "      if (ampm_12 /= 0) then"; nl ();
      printf "        ampm_12 = 1/(1/ampm_12 - ii) - ampm_12"; nl ();
      printf "      else"; nl ();
      printf "        ampm_12 = 0"; nl ();
      printf "      end if "; nl ();
      printf "      if (fudge_km == 0) then"; nl ();    
      printf "        ampm_12 = 0"; nl ();
      printf "      end if"; nl ();  
      printf "      ampm_12 = ampm_12 / (s**2)"; nl ();
      printf "  end function dam12"; nl ();
      nl ();  
      printf "  %sfunction dam21 (cc, s, m) result (ampm_21)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: ii, ampm_21"; nl (); 
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      ampm_21 = -g**2*1/8*fm0*s**2"; nl ();      
      printf "      if (ampm_21 /= 0) then"; nl ();
      printf "        ampm_21 = 1/(1/ampm_21 - ii) - ampm_21"; nl ();
      printf "      else"; nl ();
      printf "        ampm_21 = 0"; nl ();
      printf "      end if "; nl ();
      printf "      if (fudge_km == 0) then"; nl ();    
      printf "        ampm_21 = 0"; nl ();
      printf "      end if"; nl ();  
      printf "      ampm_21 = ampm_21 / (s**2)"; nl ();
      printf "  end function dam21"; nl ();
      nl ();
      printf "  %sfunction dam22 (cc, s, m) result (ampm_22)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: ii, ampm_22"; nl (); 
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      ampm_22 = g**2*1/40*fm0*s**2"; nl ();      
      printf "      if (ampm_22 /= 0) then"; nl ();
      printf "        ampm_22 = 1/(1/ampm_22 - ii) - ampm_22"; nl ();
      printf "      else"; nl ();
      printf "        ampm_22 = 0"; nl ();
      printf "      end if "; nl ();
      printf "      if (fudge_km == 0) then"; nl ();    
      printf "        ampm_22 = 0"; nl ();
      printf "      end if"; nl ();  
      printf "      ampm_22 = ampm_22 / (s**2)"; nl ();
      printf "  end function dam22"; nl ();
      nl ();      
      printf "  %sfunction dam00_1 (cc, s, m) result (ampm_00)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: ii, ampm_00"; nl (); 
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      ampm_00 = g**2*3/8*fm1*s**2"; nl ();      
      printf "      if (ampm_00 /= 0) then"; nl ();
      printf "        ampm_00 = 1/(1/ampm_00 - ii) - ampm_00"; nl ();
      printf "      else"; nl ();
      printf "        ampm_00 = 0"; nl ();
      printf "      end if "; nl ();
      printf "      if (fudge_km == 0) then"; nl ();    
      printf "        ampm_00 = 0"; nl ();
      printf "      end if"; nl ();  
      printf "      ampm_00 = ampm_00 / (s**2)"; nl ();
      printf "  end function dam00_1"; nl ();
      nl ();
      printf "  %sfunction dam01_1 (cc, s, m) result (ampm_01)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: ii, ampm_01"; nl (); 
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      ampm_01 = -g**2*1/32*fm1*s**2"; nl ();      
      printf "      if (ampm_01 /= 0) then"; nl ();
      printf "        ampm_01 = 1/(1/ampm_01 - ii) - ampm_01"; nl ();
      printf "      else"; nl ();
      printf "        ampm_01 = 0"; nl ();
      printf "      end if "; nl ();
      printf "      if (fudge_km == 0) then"; nl ();    
      printf "        ampm_01 = 0"; nl ();
      printf "      end if"; nl ();  
      printf "      ampm_01 = ampm_01 / (s**2)"; nl ();
      printf "  end function dam01_1"; nl ();
      nl ();
      printf "  %sfunction dam02_1 (cc, s, m) result (ampm_02)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: ii, ampm_02"; nl (); 
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      ampm_02 = g**2*1/160*fm1*s**2"; nl ();      
      printf "      if (ampm_02 /= 0) then"; nl ();
      printf "        ampm_02 = 1/(1/ampm_02 - ii) - ampm_02"; nl ();
      printf "      else"; nl ();
      printf "        ampm_02 = 0"; nl ();
      printf "      end if "; nl ();
      printf "      if (fudge_km == 0) then"; nl ();    
      printf "        ampm_02 = 0"; nl ();
      printf "      end if"; nl ();  
      printf "      ampm_02 = ampm_02 / (s**2)"; nl ();
      printf "  end function dam02_1"; nl ();
      nl (); 
      printf "  %sfunction dam11_1 (cc, s, m) result (ampm_11)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: ii, ampm_11"; nl (); 
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      ampm_11 = -g**2*1/32*fm1*s**2"; nl ();      
      printf "      if (ampm_11 /= 0) then"; nl ();
      printf "        ampm_11 = 1/(1/ampm_11 - ii) - ampm_11"; nl ();
      printf "      else"; nl ();
      printf "        ampm_11 = 0"; nl ();
      printf "      end if "; nl ();
      printf "      if (fudge_km == 0) then"; nl ();    
      printf "        ampm_11 = 0"; nl ();
      printf "      end if"; nl ();  
      printf "      ampm_11 = ampm_11 / (s**2)"; nl ();
      printf "  end function dam11_1"; nl ();
      nl ();
      printf "  %sfunction dam12_1 (cc, s, m) result (ampm_12)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: ii, ampm_12"; nl (); 
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      ampm_12 = g**2*1/160*fm1*s**2"; nl ();      
      printf "      if (ampm_12 /= 0) then"; nl ();
      printf "        ampm_12 = 1/(1/ampm_12 - ii) - ampm_12"; nl ();
      printf "      else"; nl ();
      printf "        ampm_12 = 0"; nl ();
      printf "      end if "; nl ();
      printf "      if (fudge_km == 0) then"; nl ();    
      printf "        ampm_12 = 0"; nl ();
      printf "      end if"; nl ();  
      printf "      ampm_12 = ampm_12 / (s**2)"; nl ();
      printf "  end function dam12_1"; nl ();
      nl ();  
      printf "  %sfunction dam21_1 (cc, s, m) result (ampm_21)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: ii, ampm_21"; nl (); 
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      ampm_21 = -g**2*1/32*fm1*s**2"; nl ();      
      printf "      if (ampm_21 /= 0) then"; nl ();
      printf "        ampm_21 = 1/(1/ampm_21 - ii) - ampm_21"; nl ();
      printf "      else"; nl ();
      printf "        ampm_21 = 0"; nl ();
      printf "      end if "; nl ();
      printf "      if (fudge_km == 0) then"; nl ();    
      printf "        ampm_21 = 0"; nl ();
      printf "      end if"; nl ();  
      printf "      ampm_21 = ampm_21 / (s**2)"; nl ();
      printf "  end function dam21_1"; nl ();
      nl ();
      printf "  %sfunction dam22_1 (cc, s, m) result (ampm_22)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: ii, ampm_22"; nl (); 
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      ampm_22 = g**2*1/160*fm1*s**2"; nl ();      
      printf "      if (ampm_22 /= 0) then"; nl ();
      printf "        ampm_22 = 1/(1/ampm_22 - ii) - ampm_22"; nl ();
      printf "      else"; nl ();
      printf "        ampm_22 = 0"; nl ();
      printf "      end if "; nl ();
      printf "      if (fudge_km == 0) then"; nl ();    
      printf "        ampm_22 = 0"; nl ();
      printf "      end if"; nl ();  
      printf "      ampm_22 = ampm_22 / (s**2)"; nl ();
      printf "  end function dam22_1"; nl ();
      nl ();   
      printf "  %sfunction dam00_7 (cc, s, m) result (ampm_00)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: ii, ampm_00"; nl (); 
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      ampm_00 = g**2*3/16*fm7*s**2"; nl ();      
      printf "      if (ampm_00 /= 0) then"; nl ();
      printf "        ampm_00 = 1/(1/ampm_00 - ii) - ampm_00"; nl ();
      printf "      else"; nl ();
      printf "        ampm_00 = 0"; nl ();
      printf "      end if "; nl ();
      printf "      if (fudge_km == 0) then"; nl ();    
      printf "        ampm_00 = 0"; nl ();
      printf "      end if"; nl ();  
      printf "      ampm_00 = ampm_00 / (s**2)"; nl ();
      printf "  end function dam00_7"; nl ();
      nl ();
      printf "  %sfunction dam01_7 (cc, s, m) result (ampm_01)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: ii, ampm_01"; nl (); 
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      ampm_01 = g**2*3/32*fm7*s**2"; nl ();      
      printf "      if (ampm_01 /= 0) then"; nl ();
      printf "        ampm_01 = 1/(1/ampm_01 - ii) - ampm_01"; nl ();
      printf "      else"; nl ();
      printf "        ampm_01 = 0"; nl ();
      printf "      end if "; nl ();
      printf "      if (fudge_km == 0) then"; nl ();    
      printf "        ampm_01 = 0"; nl ();
      printf "      end if"; nl ();  
      printf "      ampm_01 = ampm_01 / (s**2)"; nl ();
      printf "  end function dam01_7"; nl ();
      nl ();
      printf "  %sfunction dam02_7 (cc, s, m) result (ampm_02)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: ii, ampm_02"; nl (); 
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      ampm_02 = g**2*1/160*fm7*s**2"; nl ();      
      printf "      if (ampm_02 /= 0) then"; nl ();
      printf "        ampm_02 = 1/(1/ampm_02 - ii) - ampm_02"; nl ();
      printf "      else"; nl ();
      printf "        ampm_02 = 0"; nl ();
      printf "      end if "; nl ();
      printf "      if (fudge_km == 0) then"; nl ();    
      printf "        ampm_02 = 0"; nl ();
      printf "      end if"; nl ();  
      printf "      ampm_02 = ampm_02 / (s**2)"; nl ();
      printf "  end function dam02_7"; nl ();
      nl (); 
      printf "  %sfunction dam11_7 (cc, s, m) result (ampm_11)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: ii, ampm_11"; nl (); 
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      ampm_11 = g**2*3/32*fm7*s**2"; nl ();      
      printf "      if (ampm_11 /= 0) then"; nl ();
      printf "        ampm_11 = 1/(1/ampm_11 - ii) - ampm_11"; nl ();
      printf "      else"; nl ();
      printf "        ampm_11 = 0"; nl ();
      printf "      end if "; nl ();
      printf "      if (fudge_km == 0) then"; nl ();    
      printf "        ampm_11 = 0"; nl ();
      printf "      end if"; nl ();  
      printf "      ampm_11 = ampm_11 / (s**2)"; nl ();
      printf "  end function dam11_7"; nl ();
      nl ();
      printf "  %sfunction dam12_7 (cc, s, m) result (ampm_12)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: ii, ampm_12"; nl (); 
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      ampm_12 = g**2*1/160*fm7*s**2"; nl ();      
      printf "      if (ampm_12 /= 0) then"; nl ();
      printf "        ampm_12 = 1/(1/ampm_12 - ii) - ampm_12"; nl ();
      printf "      else"; nl ();
      printf "        ampm_12 = 0"; nl ();
      printf "      end if "; nl ();
      printf "      if (fudge_km == 0) then"; nl ();    
      printf "        ampm_12 = 0"; nl ();
      printf "      end if"; nl ();  
      printf "      ampm_12 = ampm_12 / (s**2)"; nl ();
      printf "  end function dam12_7"; nl ();
      nl ();  
      printf "  %sfunction dam21_7 (cc, s, m) result (ampm_21)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: ii, ampm_21"; nl (); 
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      ampm_21 = g**2*3/32*fm7*s**2"; nl ();      
      printf "      if (ampm_21 /= 0) then"; nl ();
      printf "        ampm_21 = 1/(1/ampm_21 - ii) - ampm_21"; nl ();
      printf "      else"; nl ();
      printf "        ampm_21 = 0"; nl ();
      printf "      end if "; nl ();
      printf "      if (fudge_km == 0) then"; nl ();    
      printf "        ampm_21 = 0"; nl ();
      printf "      end if"; nl ();  
      printf "      ampm_21 = ampm_21 / (s**2)"; nl ();
      printf "  end function dam21_7"; nl ();
      nl ();
      printf "  %sfunction dam22_7 (cc, s, m) result (ampm_22)" pure; nl ();
      printf "      real(kind=default), intent(in) :: s"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: ii, ampm_22"; nl (); 
      printf "      ii = cmplx(0.0,1/32._default/Pi,default)"; nl ();
      printf "      ampm_22 = g**2*1/160*fm7*s**2"; nl ();      
      printf "      if (ampm_22 /= 0) then"; nl ();
      printf "        ampm_22 = 1/(1/ampm_22 - ii) - ampm_22"; nl ();
      printf "      else"; nl ();
      printf "        ampm_22 = 0"; nl ();
      printf "      end if "; nl ();
      printf "      if (fudge_km == 0) then"; nl ();    
      printf "        ampm_22 = 0"; nl ();
      printf "      end if"; nl ();  
      printf "      ampm_22 = ampm_22 / (s**2)"; nl ();
      printf "  end function dam22_7"; nl ();
      nl (); 
      printf "  %sfunction dalh4_s (cc,m,k) result (alh4_s)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: alh4_s"; nl ();
      printf "      real(kind=default) :: s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      alh4_s = 16.0_default * cc(14) / vev**4 *((da00(cc,s,m) &"; nl ();
      printf "               + 2*da20(cc,s,m))/12 &"; nl (); 
      printf "               - 5*(da02(cc,s,m)+2*da22(cc,s,m))/6)"; nl ();
      printf "  end function dalh4_s"; nl ();
      nl ();
      printf "  @[<5>"; 
      printf "  %sfunction dalh4_t (cc,m,k) result (alh4_t)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: alh4_t"; nl ();
      printf "      real(kind=default) :: s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      alh4_t = 80.0_default * cc(14) / vev**4 *(da02(cc,s,m) &"; nl ();
      printf "               + 2*da22(cc,s,m))/4"; nl (); 
      printf "  end function dalh4_t"; nl ();
      nl ();
      printf "  %sfunction dalhw0_s (cc,m,k) result (alhw0_s)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: alhw0_s"; nl ();
      printf "      real(kind=default) :: s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      alhw0_s = - 8.0_default * cc(14) * g**2/vev**2 * &"; nl ();
      printf "                 ((da00(cc,s,m) &"; nl ();
      printf "                - da20(cc,s,m))/24 &"; nl ();
      printf "                - 5*(da02(cc,s,m) - da22(cc,s,m))/12)"; nl ();
      printf "  end function dalhw0_s"; nl ();
      nl ();
      printf "  %sfunction dalhw0_t (cc,m,k) result (alhw0_t)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: alhw0_t"; nl ();
      printf "      real(kind=default) :: s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      alhw0_t = - 5.0_default * cc(14) * g**2/ vev**2 * &"; nl ();
      printf "                (da02(cc,s,m) - &"; nl ();
      printf "                da22(cc,s,m))"; nl (); 
      printf "  end function dalhw0_t"; nl ();
      nl ();
      printf "  %sfunction dalhz0_s (cc,m,k) result (alhz0_s)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: alhz0_s"; nl ();
      printf "      alhz0_s = dalhw0_s(cc,m,k) / costhw**2"; nl();
      printf "  end function dalhz0_s"; nl ();
      nl ();
      printf "  %sfunction dalhz0_t (cc,m,k) result (alhz0_t)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: alhz0_t"; nl ();
      printf "      alhz0_t = dalhw0_t(cc,m,k) / costhw**2"; nl();
      printf "  end function dalhz0_t"; nl ();
      nl ();
      printf "  %sfunction dalhw1_s (cc,m,k) result (alhw1_s)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: alhw1_s"; nl ();
      printf "      real(kind=default) :: s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      alhw1_s = - cc(14)*g**2/vev**2*(da20(cc,s,m)/2 &"; nl ();
      printf "                - 5*da22(cc,s,m))"; nl (); 
      printf "  end function dalhw1_s"; nl ();
      nl ();  
      printf "  %sfunction dalhw1_t (cc,m,k) result (alhw1_t)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: alhw1_t"; nl ();
      printf "      real(kind=default) :: s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      alhw1_t = - cc(14)*g**2/vev**2*(- 3*da11(cc,s,m)/2 &"; nl ();
      printf "                + 3*5*da22(cc,s,m)/2)"; nl (); 
      printf "  end function dalhw1_t"; nl ();
      nl ();  
      printf "  %sfunction dalhw1_u (cc,m,k) result (alhw1_u)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: alhw1_u"; nl ();
      printf "      real(kind=default) :: s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      alhw1_u = - cc(14)*g**2/vev**2*(3*da11(cc,s,m)/2 &"; nl ();
      printf "                + 3*5*da22(cc,s,m)/2)"; nl (); 
      printf "  end function dalhw1_u"; nl ();
      nl ();
      printf "  %sfunction dalhz1_s (cc,m,k) result (alhz1_s)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: alhz1_s"; nl ();
      printf "      alhz1_s = dalhw1_s(cc,m,k) / costhw**2"; nl ();
      printf "  end function dalhz1_s"; nl ();
      nl ();  
      printf "  %sfunction dalhz1_t (cc,m,k) result (alhz1_t)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: alhz1_t"; nl ();
      printf "      alhz1_t = dalhw1_t(cc,m,k) / costhw**2"; nl ();
      printf "  end function dalhz1_t"; nl ();
      nl ();  
      printf "  %sfunction dalhz1_u (cc,m,k) result (alhz1_u)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: alhz1_u"; nl ();
      printf "      alhz1_u = dalhw1_u(cc,m,k) / costhw**2"; nl ();
      printf "  end function dalhz1_u"; nl ();
      nl ();  
      printf "  %sfunction dalzz0_s (cc,m,k) result (alzz0_s)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: alzz0_s"; nl ();
      printf "      real(kind=default) :: s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      alzz0_s = 2*g**4/costhw**2*((da00(cc,s,m) &"; nl ();
      printf "                - da20(cc,s,m))/24 &"; nl ();
      printf "                - 5*(da02(cc,s,m) - da22(cc,s,m))/12)"; nl ();
      printf "  end function dalzz0_s"; nl ();
      nl ();  
      printf "  %sfunction dalzz0_t (cc,m,k) result (alzz0_t)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: alzz0_t"; nl ();
      printf "      real(kind=default) :: s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      alzz0_t = 5*g**4/costhw**2*(da02(cc,s,m) - &"; nl ();
      printf "                da22(cc,s,m))/4"; nl (); 
      printf "  end function dalzz0_t"; nl ();
      nl ();
      printf "  %sfunction dalzz1_s (cc,m,k) result (alzz1_s)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: alzz1_s"; nl ();
      printf "      real(kind=default) :: s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      alzz1_s = g**4/costhw**2*(da20(cc,s,m)/8 &"; nl ();
      printf "                - 5*da22(cc,s,m)/4)"; nl (); 
      printf "  end function dalzz1_s"; nl ();
      nl ();  
      printf "  %sfunction dalzz1_t (cc,m,k) result (alzz1_t)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: alzz1_t"; nl ();
      printf "      real(kind=default) :: s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      alzz1_t = g**4/costhw**2*(- 3*da11(cc,s,m)/8 &"; nl ();
      printf "                + 3*5*da22(cc,s,m)/8)"; nl (); 
      printf "  end function dalzz1_t"; nl ();
      nl ();  
      printf "  %sfunction dalzz1_u (cc,m,k) result (alzz1_u)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: alzz1_u"; nl ();
      printf "      real(kind=default) :: s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      alzz1_u = g**4/costhw**2*(3*da11(cc,s,m)/8 &"; nl ();
      printf "                + 3*5*da22(cc,s,m)/8)"; nl (); 
      printf "  end function dalzz1_u"; nl ();
      nl ();  
      printf "  %sfunction dalww0_s (cc,m,k) result (alww0_s)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: alww0_s"; nl ();
      printf "      real(kind=default) :: s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      alww0_s = g**4*((2*da00(cc,s,m) + da20(cc,s,m))/24 &"; nl ();
      printf "                  - 5*(2*da02(cc,s,m) + da22(cc,s,m))/12)"; nl (); 
      printf "  end function dalww0_s"; nl ();
      nl ();  
      printf "  %sfunction dalww0_t (cc,m,k) result (alww0_t)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: alww0_t"; nl ();
      printf "      real(kind=default) :: s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      alww0_t = g**4*(2*(5.)*da02(cc,s,m) - 3*da11(cc,s,m) &"; nl ();
      printf "                + 5*da22(cc,s,m))/8"; nl (); 
      printf "  end function dalww0_t"; nl ();
      nl ();  
      printf "  %sfunction dalww0_u (cc,m,k) result (alww0_u)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: alww0_u"; nl ();
      printf "      real(kind=default) :: s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      alww0_u = g**4*(2*(5.)*da02(cc,s,m) + 3*da11(cc,s,m) &"; nl (); 
      printf "                + 5*da22(cc,s,m))/8"; nl (); 
      printf "  end function dalww0_u"; nl ();
      nl ();
      printf "  %sfunction dalww2_s (cc,m,k) result (alww2_s)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: alww2_s"; nl ();
      printf "      real(kind=default) :: s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      alww2_s = g**4*(da20(cc,s,m) - 2*5*da22(cc,s,m))/4 "; nl (); 
      printf "  end function dalww2_s"; nl ();
      nl ();
      printf "  %sfunction dalww2_t (cc,m,k) result (alww2_t)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: alww2_t"; nl ();
      printf "      real(kind=default) :: s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      alww2_t = 3*5*g**4*da22(cc,s,m)/4"; nl (); 
      printf "  end function dalww2_t"; nl ();
      nl ();
      printf "  %sfunction dalz4_s (cc,m,k) result (alz4_s)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: alz4_s"; nl ();
      printf "      real(kind=default) :: s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      alz4_s = g**4/costhw**4*((da00(cc,s,m) &"; nl ();
      printf "               + 2*da20(cc,s,m))/12 &"; nl (); 
      printf "               - 5*(da02(cc,s,m)+2*da22(cc,s,m))/6)"; nl ();
      printf "  end function dalz4_s"; nl ();
      nl ();
      printf "  @[<5>"; 
      printf "  %sfunction dalz4_t (cc,m,k) result (alz4_t)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();
      printf "      complex(kind=default) :: alz4_t"; nl ();
      printf "      real(kind=default) :: s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      alz4_t = g**4/costhw**4*5*(da02(cc,s,m) &"; nl ();
      printf "               + 2*da22(cc,s,m))/4"; nl (); 
      printf "  end function dalz4_t"; nl ();
      nl ();
      printf " %sfunction datzz0_s_0 (cc,m,k) result (atzz0_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atzz0_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atzz0_s = -4*g**4*costhw**2*dat00_0(cc,s,m)/3"; nl();
      printf "  end function datzz0_s_0"; nl ();  
      nl ();
      printf " %sfunction datzz0_t_0 (cc,m,k) result (atzz0_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atzz0_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atzz0_t = -4*g**4*costhw**2*5*(dat02_0(cc,s,m) - dat22_0(cc,s,m))/3"; nl();
      printf "  end function datzz0_t_0"; nl ();  
      nl ();
      printf " %sfunction datzz0_u_0 (cc,m,k) result (atzz0_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atzz0_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atzz0_u = -4*g**4*costhw**2*5*(dat02_0(cc,s,m) - dat22_0(cc,s,m))/3"; nl();
      printf "  end function datzz0_u_0"; nl ();  
      nl ();
      printf " %sfunction datzz1_s_0 (cc,m,k) result (atzz1_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atzz1_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atzz1_s = 0"; nl();
      printf "  end function datzz1_s_0"; nl ();   
      nl ();
      printf " %sfunction datzz1_t_0 (cc,m,k) result (atzz1_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atzz1_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atzz1_t = -4*g**4*costhw**2*5*(dat12_0(cc,s,m) + dat22_0(cc,s,m))/2"; nl();
      printf "  end function datzz1_t_0"; nl ();  
      nl ();
      printf " %sfunction datzz1_u_0 (cc,m,k) result (atzz1_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atzz1_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atzz1_u = -4*g**4*costhw**2*5*(-dat12_0(cc,s,m) + dat22_0(cc,s,m))/2"; nl();
      printf "  end function datzz1_u_0"; nl (); 
      nl ();
      printf " %sfunction datww0_s_0 (cc,m,k) result (atww0_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atww0_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atww0_s = -4*g**4*2*dat00_0(cc,s,m)/6"; nl();
      printf "  end function datww0_s_0"; nl ();   
      nl ();
      printf " %sfunction datww0_t_0 (cc,m,k) result (atww0_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atww0_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atww0_t = -4*g**4*5*(2*dat02_0(cc,s,m) + 3*dat12_0(cc,s,m) &"; nl();
      printf "              + dat22_0(cc,s,m))/6"; nl ();
      printf "  end function datww0_t_0"; nl ();        
      nl ();   
      printf " %sfunction datww0_u_0 (cc,m,k) result (atww0_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atww0_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atww0_u = -4*g**4*5*(2*dat02_0(cc,s,m) - 3*dat12_0(cc,s,m) &"; nl();
      printf "              + dat22_0(cc,s,m))/6"; nl ();
      printf "  end function datww0_u_0"; nl ();        
      nl ();    
      printf " %sfunction datww2_s_0 (cc,m,k) result (atww2_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atww2_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atww2_s = 0"; nl();
      printf "  end function datww2_s_0"; nl ();        
      nl ();    
      printf " %sfunction datww2_t_0 (cc,m,k) result (atww2_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atww2_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atww2_t = -4*g**4*5*dat22_0(cc,s,m)"; nl();
      printf "  end function datww2_t_0"; nl ();        
      nl (); 
      printf " %sfunction datww2_u_0 (cc,m,k) result (atww2_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atww2_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atww2_u = -4*g**4*5*dat22_0(cc,s,m)"; nl();
      printf "  end function datww2_u_0"; nl ();  
      nl ();   
      printf " %sfunction datz4_s_0 (cc,m,k) result (atz4_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atz4_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atz4_s = -4*g**4*costhw**4*dat00_0(cc,s,m)/3"; nl();
      printf "  end function datz4_s_0"; nl (); 
      nl ();   
      printf " %sfunction datz4_t_0 (cc,m,k) result (atz4_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atz4_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atz4_t = -4*g**4*costhw**4*5*(dat02_0(cc,s,m) + 2*dat22_0(cc,s,m))/3"; nl();
      printf "  end function datz4_t_0"; nl (); 
      nl ();   
      printf " %sfunction datz4_u_0 (cc,m,k) result (atz4_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atz4_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atz4_u = -4*g**4*costhw**4*5*(dat02_0(cc,s,m) + 2*dat22_0(cc,s,m))/3"; nl();
      printf "  end function datz4_u_0"; nl ();       
      nl (); 
      printf " %sfunction data4_s_0 (cc,m,k) result (ata4_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ata4_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ata4_s = datz4_s_0 (cc,m,k) / costhw**4 * sinthw**4"; nl();
      printf "  end function data4_s_0"; nl (); 
      nl ();   
      printf " %sfunction data4_t_0 (cc,m,k) result (ata4_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ata4_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ata4_t = datz4_t_0 (cc,m,k) / costhw**4 * sinthw**4"; nl();
      printf "  end function data4_t_0"; nl (); 
      nl ();   
      printf " %sfunction data4_u_0 (cc,m,k) result (ata4_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ata4_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ata4_u = datz4_u_0 (cc,m,k) / costhw**4 * sinthw**4"; nl();
      printf "  end function data4_u_0"; nl ();
      nl ();        
      printf " %sfunction dataw0_s_0 (cc,m,k) result (ataw0_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ataw0_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ataw0_s = datzz0_s_0(cc,m,k) / costhw**2 * sinthw**2"; nl();
      printf "  end function dataw0_s_0"; nl ();       
      nl ();    
      printf " %sfunction dataw0_t_0 (cc,m,k) result (ataw0_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ataw0_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ataw0_t = datzz0_t_0(cc,m,k) / costhw**2 * sinthw**2"; nl();
      printf "  end function dataw0_t_0"; nl ();       
      nl (); 
      printf " %sfunction dataw0_u_0 (cc,m,k) result (ataw0_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ataw0_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ataw0_u = datzz0_u_0(cc,m,k) / costhw**2 * sinthw**2"; nl();
      printf "  end function dataw0_u_0"; nl ();       
      nl ();  
      printf " %sfunction dataw1_s_0 (cc,m,k) result (ataw1_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ataw1_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ataw1_s = datzz1_s_0(cc,m,k) / costhw**2 * sinthw**2"; nl();
      printf "  end function dataw1_s_0"; nl ();       
      nl ();    
      printf " %sfunction dataw1_t_0 (cc,m,k) result (ataw1_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ataw1_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ataw1_t = datzz1_t_0(cc,m,k) / costhw**2 * sinthw**2"; nl();
      printf "  end function dataw1_t_0"; nl ();       
      nl (); 
      printf " %sfunction dataw1_u_0 (cc,m,k) result (ataw1_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ataw1_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ataw1_u = datzz1_u_0(cc,m,k) / costhw**2 * sinthw**2"; nl();
      printf "  end function dataw1_u_0"; nl ();      
      nl ();    
      printf " %sfunction dataz_s_0 (cc,m,k) result (ataz_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ataz_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ataz_s = datz4_s_0(cc,m,k) / costhw**2 * sinthw**2"; nl();
      printf "  end function dataz_s_0"; nl ();       
      nl ();    
      printf " %sfunction dataz_t_0 (cc,m,k) result (ataz_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ataz_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ataz_t = datz4_t_0(cc,m,k) / costhw**2 * sinthw**2"; nl();
      printf "  end function dataz_t_0"; nl ();       
      nl (); 
      printf " %sfunction dataz_u_0 (cc,m,k) result (ataz_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ataz_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ataz_u = datz4_u_0(cc,m,k) / costhw**2 * sinthw**2"; nl();
      printf "  end function dataz_u_0"; nl ();       
      nl ();     
      printf " %sfunction datazw0_s_0 (cc,m,k) result (atazw0_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atazw0_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atazw0_s = datzz0_s_0(cc,m,k) / costhw * sinthw"; nl();
      printf "  end function datazw0_s_0"; nl ();       
      nl ();    
      printf " %sfunction datazw0_t_0 (cc,m,k) result (atazw0_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atazw0_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atazw0_t = datzz0_t_0(cc,m,k) / costhw * sinthw"; nl();
      printf "  end function datazw0_t_0"; nl ();       
      nl (); 
      printf " %sfunction datazw0_u_0 (cc,m,k) result (atazw0_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atazw0_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atazw0_u = datzz0_u_0(cc,m,k) / costhw * sinthw"; nl();
      printf "  end function datazw0_u_0"; nl ();       
      nl ();  
      printf " %sfunction datazw1_s_0 (cc,m,k) result (atazw1_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atazw1_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atazw1_s = datzz1_s_0(cc,m,k) / costhw * sinthw"; nl();
      printf "  end function datazw1_s_0"; nl ();       
      nl ();    
      printf " %sfunction datazw1_t_0 (cc,m,k) result (atazw1_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atazw1_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atazw1_t = datzz1_t_0(cc,m,k) / costhw * sinthw"; nl();
      printf "  end function datazw1_t_0"; nl ();       
      nl (); 
      printf " %sfunction datazw1_u_0 (cc,m,k) result (atazw1_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atazw1_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atazw1_u = datzz1_u_0(cc,m,k) / costhw * sinthw"; nl();
      printf "  end function datazw1_u_0"; nl ();
      nl ();
      printf " %sfunction dat3az_s_0 (cc,m,k) result (at3az_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: at3az_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      at3az_s = datz4_s_0(cc,m,k) / costhw**3 * sinthw**3"; nl();
      printf "  end function dat3az_s_0"; nl ();       
      nl ();    
      printf " %sfunction dat3az_t_0 (cc,m,k) result (at3az_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: at3az_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      at3az_t = datz4_t_0(cc,m,k) / costhw**3 * sinthw**3"; nl();
      printf "  end function dat3az_t_0"; nl ();       
      nl (); 
      printf " %sfunction dat3az_u_0 (cc,m,k) result (at3az_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: at3az_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      at3az_u = datz4_u_0(cc,m,k) / costhw**3 * sinthw**3"; nl();
      printf "  end function dat3az_u_0"; nl ();
      nl ();  
      printf " %sfunction data3z_s_0 (cc,m,k) result (ata3z_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ata3z_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ata3z_s = datz4_s_0(cc,m,k) / costhw * sinthw"; nl();
      printf "  end function data3z_s_0"; nl ();       
      nl ();    
      printf " %sfunction data3z_t_0 (cc,m,k) result (ata3z_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ata3z_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ata3z_t = datz4_t_0(cc,m,k) / costhw * sinthw"; nl();
      printf "  end function data3z_t_0"; nl ();       
      nl (); 
      printf " %sfunction data3z_u_0 (cc,m,k) result (ata3z_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ata3z_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ata3z_u = datz4_u_0(cc,m,k) / costhw * sinthw"; nl();
      printf "  end function data3z_u_0"; nl ();
      nl ();       
      printf " %sfunction datzz0_s_1 (cc,m,k) result (atzz0_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atzz0_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atzz0_s = -4*g**4*costhw**2*dat00_1(cc,s,m)/3"; nl();
      printf "  end function datzz0_s_1"; nl ();  
      nl ();
      printf " %sfunction datzz0_t_1 (cc,m,k) result (atzz0_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atzz0_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atzz0_t = -4*g**4*costhw**2*5*(dat02_1(cc,s,m) - dat22_1(cc,s,m))/3"; nl();
      printf "  end function datzz0_t_1"; nl ();  
      nl ();
      printf " %sfunction datzz0_u_1 (cc,m,k) result (atzz0_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atzz0_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atzz0_u = -4*g**4*costhw**2*5*(dat02_1(cc,s,m) - dat22_1(cc,s,m))/3"; nl();
      printf "  end function datzz0_u_1"; nl ();  
      nl ();
      printf " %sfunction datzz1_s_1 (cc,m,k) result (atzz1_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atzz1_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atzz1_s = 0"; nl();
      printf "  end function datzz1_s_1"; nl ();   
      nl ();
      printf " %sfunction datzz1_t_1 (cc,m,k) result (atzz1_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atzz1_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atzz1_t = -4*g**4*costhw**2*5*(dat12_1(cc,s,m) + dat22_1(cc,s,m))/2"; nl();
      printf "  end function datzz1_t_1"; nl ();  
      nl ();
      printf " %sfunction datzz1_u_1 (cc,m,k) result (atzz1_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atzz1_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atzz1_u = -4*g**4*costhw**2*5*(-dat12_1(cc,s,m) + dat22_1(cc,s,m))/2"; nl();
      printf "  end function datzz1_u_1"; nl (); 
      nl ();
      printf " %sfunction datww0_s_1 (cc,m,k) result (atww0_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atww0_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atww0_s = -4*g**4*2*dat00_1(cc,s,m)/6"; nl();
      printf "  end function datww0_s_1"; nl ();   
      nl ();
      printf " %sfunction datww0_t_1 (cc,m,k) result (atww0_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atww0_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atww0_t = -4*g**4*5*(2*dat02_1(cc,s,m) + 3*dat12_1(cc,s,m) &"; nl();
      printf "              + dat22_1(cc,s,m))/6"; nl ();
      printf "  end function datww0_t_1"; nl ();        
      nl ();   
      printf " %sfunction datww0_u_1 (cc,m,k) result (atww0_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atww0_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atww0_u = -4*g**4*5*(2*dat02_1(cc,s,m) - 3*dat12_1(cc,s,m) &"; nl();
      printf "              + dat22_1(cc,s,m))/6"; nl ();
      printf "  end function datww0_u_1"; nl ();        
      nl ();    
      printf " %sfunction datww2_s_1 (cc,m,k) result (atww2_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atww2_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atww2_s = 0"; nl();
      printf "  end function datww2_s_1"; nl ();        
      nl ();    
      printf " %sfunction datww2_t_1 (cc,m,k) result (atww2_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atww2_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atww2_t = -4*g**4*5*dat22_1(cc,s,m)"; nl();
      printf "  end function datww2_t_1"; nl ();        
      nl (); 
      printf " %sfunction datww2_u_1 (cc,m,k) result (atww2_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atww2_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atww2_u = -4*g**4*5*dat22_1(cc,s,m)"; nl();
      printf "  end function datww2_u_1"; nl ();  
      nl ();   
      printf " %sfunction datz4_s_1 (cc,m,k) result (atz4_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atz4_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atz4_s = -4*g**4*costhw**4*(dat00_1(cc,s,m))/3"; nl();
      printf "  end function datz4_s_1"; nl (); 
      nl ();   
      printf " %sfunction datz4_t_1 (cc,m,k) result (atz4_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atz4_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atz4_t = -4*g**4*costhw**4*5*(dat02_1(cc,s,m) + 2*dat22_1(cc,s,m))/3"; nl();
      printf "  end function datz4_t_1"; nl (); 
      nl ();   
      printf " %sfunction datz4_u_1 (cc,m,k) result (atz4_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atz4_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atz4_u = -4*g**4*costhw**4*5*(dat02_1(cc,s,m) + 2*dat22_1(cc,s,m))/3"; nl();
      printf "  end function datz4_u_1"; nl ();       
      nl ();
      printf " %sfunction data4_s_1 (cc,m,k) result (ata4_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ata4_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ata4_s = datz4_s_1 (cc,m,k) / costhw**4 * sinthw**4"; nl();
      printf "  end function data4_s_1"; nl (); 
      nl ();   
      printf " %sfunction data4_t_1 (cc,m,k) result (ata4_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ata4_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ata4_t = datz4_t_1 (cc,m,k) / costhw**4 * sinthw**4"; nl();
      printf "  end function data4_t_1"; nl (); 
      nl ();   
      printf " %sfunction data4_u_1 (cc,m,k) result (ata4_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ata4_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ata4_u = datz4_u_1 (cc,m,k) / costhw**4 * sinthw**4"; nl();
      printf "  end function data4_u_1"; nl ();
      nl ();        
      printf " %sfunction dataw0_s_1 (cc,m,k) result (ataw0_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ataw0_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ataw0_s = datzz0_s_1(cc,m,k) / costhw**2 * sinthw**2"; nl();
      printf "  end function dataw0_s_1"; nl ();       
      nl ();    
      printf " %sfunction dataw0_t_1 (cc,m,k) result (ataw0_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ataw0_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ataw0_t = datzz0_t_1(cc,m,k) / costhw**2 * sinthw**2"; nl();
      printf "  end function dataw0_t_1"; nl ();       
      nl (); 
      printf " %sfunction dataw0_u_1 (cc,m,k) result (ataw0_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ataw0_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ataw0_u = datzz0_u_1(cc,m,k) / costhw**2 * sinthw**2"; nl();
      printf "  end function dataw0_u_1"; nl ();       
      nl ();  
      printf " %sfunction dataw1_s_1 (cc,m,k) result (ataw1_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ataw1_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ataw1_s = datzz1_s_1(cc,m,k) / costhw**2 * sinthw**2"; nl();
      printf "  end function dataw1_s_1"; nl ();       
      nl ();    
      printf " %sfunction dataw1_t_1 (cc,m,k) result (ataw1_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ataw1_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ataw1_t = datzz1_t_1(cc,m,k) / costhw**2 * sinthw**2"; nl();
      printf "  end function dataw1_t_1"; nl ();       
      nl (); 
      printf " %sfunction dataw1_u_1 (cc,m,k) result (ataw1_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ataw1_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ataw1_u = datzz1_u_1(cc,m,k) / costhw**2 * sinthw**2"; nl();
      printf "  end function dataw1_u_1"; nl ();       
      nl ();    
      printf " %sfunction dataz_s_1 (cc,m,k) result (ataz_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ataz_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ataz_s = datz4_s_1(cc,m,k) / costhw**2 * sinthw**2"; nl();
      printf "  end function dataz_s_1"; nl ();       
      nl ();    
      printf " %sfunction dataz_t_1 (cc,m,k) result (ataz_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ataz_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ataz_t = datz4_t_1(cc,m,k) / costhw**2 * sinthw**2"; nl();
      printf "  end function dataz_t_1"; nl ();       
      nl (); 
      printf " %sfunction dataz_u_1 (cc,m,k) result (ataz_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ataz_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ataz_u = datz4_u_1(cc,m,k) / costhw**2 * sinthw**2"; nl();
      printf "  end function dataz_u_1"; nl (); 
      nl ();        
      printf " %sfunction datazw0_s_1 (cc,m,k) result (atazw0_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atazw0_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atazw0_s = datzz0_s_1(cc,m,k) / costhw * sinthw"; nl();
      printf "  end function datazw0_s_1"; nl ();       
      nl ();    
      printf " %sfunction datazw0_t_1 (cc,m,k) result (atazw0_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atazw0_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atazw0_t = datzz0_t_1(cc,m,k) / costhw * sinthw"; nl();
      printf "  end function datazw0_t_1"; nl ();       
      nl (); 
      printf " %sfunction datazw0_u_1 (cc,m,k) result (atazw0_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atazw0_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atazw0_u = datzz1_u_0(cc,m,k) / costhw * sinthw"; nl();
      printf "  end function datazw0_u_1"; nl ();       
      nl ();  
      printf " %sfunction datazw1_s_1 (cc,m,k) result (atazw1_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atazw1_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atazw1_s = datzz1_s_1(cc,m,k) / costhw * sinthw"; nl();
      printf "  end function datazw1_s_1"; nl ();       
      nl ();    
      printf " %sfunction datazw1_t_1 (cc,m,k) result (atazw1_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atazw1_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atazw1_t = datzz1_t_1(cc,m,k) / costhw * sinthw"; nl();
      printf "  end function datazw1_t_1"; nl ();       
      nl (); 
      printf " %sfunction datazw1_u_1 (cc,m,k) result (atazw1_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atazw1_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atazw1_u = datzz1_u_1(cc,m,k) / costhw * sinthw"; nl();
      printf "  end function datazw1_u_1"; nl ();      
      nl ();
      printf " %sfunction dat3az_s_1 (cc,m,k) result (at3az_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: at3az_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      at3az_s = datz4_s_1(cc,m,k) / costhw**3 * sinthw**3"; nl();
      printf "  end function dat3az_s_1"; nl ();       
      nl ();    
      printf " %sfunction dat3az_t_1 (cc,m,k) result (at3az_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: at3az_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      at3az_t = datz4_t_1(cc,m,k) / costhw**3 * sinthw**3"; nl();
      printf "  end function dat3az_t_1"; nl ();       
      nl (); 
      printf " %sfunction dat3az_u_1 (cc,m,k) result (at3az_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: at3az_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      at3az_u = datz4_u_1(cc,m,k) / costhw**3 * sinthw**3"; nl();
      printf "  end function dat3az_u_1"; nl ();
      nl ();  
      printf " %sfunction data3z_s_1 (cc,m,k) result (ata3z_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ata3z_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ata3z_s = datz4_s_1(cc,m,k) / costhw * sinthw"; nl();
      printf "  end function data3z_s_1"; nl ();       
      nl ();    
      printf " %sfunction data3z_t_1 (cc,m,k) result (ata3z_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ata3z_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ata3z_t = datz4_t_1(cc,m,k) / costhw * sinthw"; nl();
      printf "  end function data3z_t_1"; nl ();       
      nl (); 
      printf " %sfunction data3z_u_1 (cc,m,k) result (ata3z_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ata3z_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ata3z_u = datz4_u_1(cc,m,k) / costhw * sinthw"; nl();
      printf "  end function data3z_u_1"; nl ();
      nl ();      
      printf " %sfunction datzz0_s_2 (cc,m,k) result (atzz0_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atzz0_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atzz0_s = -2*g**4*costhw**2*dat00_2(cc,s,m)/3"; nl();
      printf "  end function datzz0_s_2"; nl ();  
      nl ();
      printf " %sfunction datzz0_t_2 (cc,m,k) result (atzz0_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atzz0_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atzz0_t = -2*g**4*costhw**2*5*(dat02_2(cc,s,m) - dat22_2(cc,s,m))/3"; nl();
      printf "  end function datzz0_t_2"; nl ();  
      nl ();
      printf " %sfunction datzz0_u_2 (cc,m,k) result (atzz0_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atzz0_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atzz0_u = -2*g**4*costhw**2*5*(dat02_2(cc,s,m) - dat22_2(cc,s,m))/3"; nl();
      printf "  end function datzz0_u_2"; nl ();  
      nl ();
      printf " %sfunction datzz1_s_2 (cc,m,k) result (atzz1_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atzz1_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atzz1_s = 0"; nl();
      printf "  end function datzz1_s_2"; nl ();   
      nl ();
      printf " %sfunction datzz1_t_2 (cc,m,k) result (atzz1_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atzz1_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atzz1_t = -2*g**4*costhw**2*(3*dat11_2(cc,s,m) + 5*dat22_2(cc,s,m))/2"; nl();
      printf "  end function datzz1_t_2"; nl ();  
      nl ();
      printf " %sfunction datzz1_u_2 (cc,m,k) result (atzz1_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atzz1_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atzz1_u = -2*g**4*costhw**2*(-3*dat11_2(cc,s,m) + 5*dat22_2(cc,s,m))/2"; nl();
      printf "  end function datzz1_u_2"; nl (); 
      nl ();
      printf " %sfunction datww0_s_2 (cc,m,k) result (atww0_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atww0_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atww0_s = -2*g**4*dat00_2(cc,s,m)/3"; nl();
      printf "  end function datww0_s_2"; nl ();   
      nl ();
      printf " %sfunction datww0_t_2 (cc,m,k) result (atww0_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atww0_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atww0_t = -2*g**4*(9*dat11_2(cc,s,m) + 10*dat02_2(cc,s,m) &"; nl();
      printf "              + 5*dat22_2(cc,s,m))/6"; nl ();
      printf "  end function datww0_t_2"; nl ();        
      nl ();   
      printf " %sfunction datww0_u_2 (cc,m,k) result (atww0_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atww0_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atww0_u = -2*g**4*(-9*dat11_2(cc,s,m) + 10*dat02_2(cc,s,m) &"; nl();
      printf "              + 5*dat22_2(cc,s,m))/6"; nl ();
      printf "  end function datww0_u_2"; nl ();        
      nl ();    
      printf " %sfunction datww2_s_2 (cc,m,k) result (atww2_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atww2_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atww2_s = 0"; nl();
      printf "  end function datww2_s_2"; nl ();        
      nl ();    
      printf " %sfunction datww2_t_2 (cc,m,k) result (atww2_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atww2_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atww2_t = -2*g**4*5*dat22_2(cc,s,m)"; nl();
      printf "  end function datww2_t_2"; nl ();        
      nl (); 
      printf " %sfunction datww2_u_2 (cc,m,k) result (atww2_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atww2_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atww2_u = -2*g**4*5*dat22_2(cc,s,m)"; nl();
      printf "  end function datww2_u_2"; nl ();  
      nl ();   
      printf " %sfunction datz4_s_2 (cc,m,k) result (atz4_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atz4_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atz4_s = -2*g**4*costhw**4*dat00_2(cc,s,m)/3"; nl();
      printf "  end function datz4_s_2"; nl (); 
      nl ();   
      printf " %sfunction datz4_t_2 (cc,m,k) result (atz4_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atz4_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atz4_t = -2*g**4*costhw**4*5*(dat02_2(cc,s,m) + 2*dat22_2(cc,s,m))/3"; nl();
      printf "  end function datz4_t_2"; nl (); 
      nl ();   
      printf " %sfunction datz4_u_2 (cc,m,k) result (atz4_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atz4_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atz4_u = -2*g**4*costhw**4*5*(dat02_2(cc,s,m) + 2*dat22_2(cc,s,m))/3"; nl();
      printf "  end function datz4_u_2"; nl ();       
      nl ();
      printf " %sfunction data4_s_2 (cc,m,k) result (ata4_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ata4_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ata4_s = datz4_s_2 (cc,m,k) / costhw**4 * sinthw**4"; nl();
      printf "  end function data4_s_2"; nl (); 
      nl ();   
      printf " %sfunction data4_t_2 (cc,m,k) result (ata4_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ata4_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ata4_t = datz4_t_2 (cc,m,k) / costhw**4 * sinthw**4"; nl();
      printf "  end function data4_t_2"; nl (); 
      nl ();   
      printf " %sfunction data4_u_2 (cc,m,k) result (ata4_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ata4_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ata4_u = datz4_u_2 (cc,m,k) / costhw**4 * sinthw**4"; nl();
      printf "  end function data4_u_2"; nl ();
      nl ();        
      printf " %sfunction dataw0_s_2 (cc,m,k) result (ataw0_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ataw0_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ataw0_s = datzz0_s_2(cc,m,k) / costhw**2 * sinthw**2"; nl();
      printf "  end function dataw0_s_2"; nl ();       
      nl ();    
      printf " %sfunction dataw0_t_2 (cc,m,k) result (ataw0_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ataw0_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ataw0_t = datzz0_t_2(cc,m,k) / costhw**2 * sinthw**2"; nl();
      printf "  end function dataw0_t_2"; nl ();       
      nl (); 
      printf " %sfunction dataw0_u_2 (cc,m,k) result (ataw0_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ataw0_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ataw0_u = datzz0_u_2(cc,m,k) / costhw**2 * sinthw**2"; nl();
      printf "  end function dataw0_u_2"; nl ();       
      nl ();  
      printf " %sfunction dataw1_s_2 (cc,m,k) result (ataw1_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ataw1_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ataw1_s = datzz1_s_2(cc,m,k) / costhw**2 * sinthw**2"; nl();
      printf "  end function dataw1_s_2"; nl ();       
      nl ();    
      printf " %sfunction dataw1_t_2 (cc,m,k) result (ataw1_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ataw1_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ataw1_t = datzz1_t_2(cc,m,k) / costhw**2 * sinthw**2"; nl();
      printf "  end function dataw1_t_2"; nl ();       
      nl (); 
      printf " %sfunction dataw1_u_2 (cc,m,k) result (ataw1_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ataw1_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ataw1_u = datzz1_u_2(cc,m,k) / costhw**2 * sinthw**2"; nl();
      printf "  end function dataw1_u_2"; nl ();       
      nl ();    
      printf " %sfunction dataz_s_2 (cc,m,k) result (ataz_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ataz_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ataz_s = datz4_s_2(cc,m,k) / costhw**2 * sinthw**2"; nl();
      printf "  end function dataz_s_2"; nl ();       
      nl ();    
      printf " %sfunction dataz_t_2 (cc,m,k) result (ataz_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ataz_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ataz_t = datz4_t_2(cc,m,k) / costhw**2 * sinthw**2"; nl();
      printf "  end function dataz_t_2"; nl ();       
      nl (); 
      printf " %sfunction dataz_u_2 (cc,m,k) result (ataz_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ataz_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ataz_u = datz4_u_2(cc,m,k) / costhw**2 * sinthw**2"; nl();
      printf "  end function dataz_u_2"; nl ();       
      nl ();        
      printf " %sfunction datazw0_s_2 (cc,m,k) result (atazw0_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atazw0_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atazw0_s = datzz0_s_2(cc,m,k) / costhw * sinthw"; nl();
      printf "  end function datazw0_s_2"; nl ();       
      nl ();    
      printf " %sfunction datazw0_t_2 (cc,m,k) result (atazw0_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atazw0_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atazw0_t = datzz0_t_2(cc,m,k) / costhw * sinthw"; nl();
      printf "  end function datazw0_t_2"; nl ();       
      nl (); 
      printf " %sfunction datazw0_u_2 (cc,m,k) result (atazw0_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atazw0_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atazw0_u = datzz0_u_2(cc,m,k) / costhw * sinthw"; nl();
      printf "  end function datazw0_u_2"; nl ();       
      nl ();  
      printf " %sfunction datazw1_s_2 (cc,m,k) result (atazw1_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atazw1_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atazw1_s = datzz1_s_2(cc,m,k) / costhw * sinthw"; nl();
      printf "  end function datazw1_s_2"; nl ();       
      nl ();    
      printf " %sfunction datazw1_t_2 (cc,m,k) result (atazw1_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atazw1_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atazw1_t = datzz1_t_2(cc,m,k) / costhw * sinthw"; nl();
      printf "  end function datazw1_t_2"; nl ();       
      nl (); 
      printf " %sfunction datazw1_u_2 (cc,m,k) result (atazw1_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atazw1_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atazw1_u = datzz1_u_2(cc,m,k) / costhw * sinthw"; nl();
      printf "  end function datazw1_u_2"; nl ();      
      nl ();
      printf " %sfunction dat3az_s_2 (cc,m,k) result (at3az_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: at3az_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      at3az_s = datz4_s_2(cc,m,k) / costhw**3 * sinthw**3"; nl();
      printf "  end function dat3az_s_2"; nl ();       
      nl ();    
      printf " %sfunction dat3az_t_2 (cc,m,k) result (at3az_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: at3az_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      at3az_t = datz4_t_2(cc,m,k) / costhw**3 * sinthw**3"; nl();
      printf "  end function dat3az_t_2"; nl ();       
      nl (); 
      printf " %sfunction dat3az_u_2 (cc,m,k) result (at3az_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: at3az_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      at3az_u = datz4_u_2(cc,m,k) / costhw**3 * sinthw**3"; nl();
      printf "  end function dat3az_u_2"; nl ();
      nl ();  
      printf " %sfunction data3z_s_2 (cc,m,k) result (ata3z_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ata3z_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ata3z_s = datz4_s_2(cc,m,k) / costhw * sinthw"; nl();
      printf "  end function data3z_s_2"; nl ();       
      nl ();    
      printf " %sfunction data3z_t_2 (cc,m,k) result (ata3z_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ata3z_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ata3z_t = datz4_t_2(cc,m,k) / costhw * sinthw"; nl();
      printf "  end function data3z_t_2"; nl ();       
      nl (); 
      printf " %sfunction data3z_u_2 (cc,m,k) result (ata3z_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ata3z_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ata3z_u = datz4_u_2(cc,m,k) / costhw * sinthw"; nl();
      printf "  end function data3z_u_2"; nl ();
      nl ();      
      printf " %sfunction datzz0_s_rsi (cc,m,k) result (atzz0_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atzz0_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atzz0_s = -4*g**4*costhw**2*dat00_rsi(cc,s,m)/3"; nl();
      printf "  end function datzz0_s_rsi"; nl ();  
      nl ();
      printf " %sfunction datzz0_t_rsi (cc,m,k) result (atzz0_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atzz0_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atzz0_t = -4*g**4*costhw**2*5*(dat02_rsi(cc,s,m) - dat22_rsi(cc,s,m))/3"; nl();
      printf "  end function datzz0_t_rsi"; nl ();  
      nl ();
      printf " %sfunction datzz0_u_rsi (cc,m,k) result (atzz0_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atzz0_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atzz0_u = -4*g**4*costhw**2*5*(dat02_rsi(cc,s,m) - dat22_rsi(cc,s,m))/3"; nl();
      printf "  end function datzz0_u_rsi"; nl ();  
      nl ();
      printf " %sfunction datzz1_s_rsi (cc,m,k) result (atzz1_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atzz1_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atzz1_s = 0"; nl();
      printf "  end function datzz1_s_rsi"; nl ();   
      nl ();
      printf " %sfunction datzz1_t_rsi (cc,m,k) result (atzz1_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atzz1_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atzz1_t = -4*g**4*costhw**2*5*(dat12_rsi(cc,s,m) + dat22_rsi(cc,s,m))/2"; nl();
      printf "  end function datzz1_t_rsi"; nl ();  
      nl ();
      printf " %sfunction datzz1_u_rsi (cc,m,k) result (atzz1_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atzz1_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atzz1_u = -4*g**4*costhw**2*5*(-dat12_rsi(cc,s,m) + dat22_rsi(cc,s,m))/2"; nl();
      printf "  end function datzz1_u_rsi"; nl (); 
      nl ();
      printf " %sfunction datww0_s_rsi (cc,m,k) result (atww0_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atww0_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atww0_s = -4*g**4*2*dat00_rsi(cc,s,m)/6"; nl();
      printf "  end function datww0_s_rsi"; nl ();   
      nl ();
      printf " %sfunction datww0_t_rsi (cc,m,k) result (atww0_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atww0_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atww0_t = -4*g**4*5*(2*dat02_rsi(cc,s,m) + 3*dat12_rsi(cc,s,m) &"; nl();
      printf "              + dat22_rsi(cc,s,m))/6"; nl ();
      printf "  end function datww0_t_rsi"; nl ();        
      nl ();   
      printf " %sfunction datww0_u_rsi (cc,m,k) result (atww0_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atww0_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atww0_u = -4*g**4*5*(2*dat02_rsi(cc,s,m) - 3*dat12_rsi(cc,s,m) &"; nl();
      printf "              + dat22_rsi(cc,s,m))/6"; nl ();
      printf "  end function datww0_u_rsi"; nl ();        
      nl ();    
      printf " %sfunction datww2_s_rsi (cc,m,k) result (atww2_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atww2_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atww2_s = 0"; nl();
      printf "  end function datww2_s_rsi"; nl ();        
      nl ();    
      printf " %sfunction datww2_t_rsi (cc,m,k) result (atww2_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atww2_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atww2_t = -4*g**4*5*dat22_rsi(cc,s,m)"; nl();
      printf "  end function datww2_t_rsi"; nl ();        
      nl (); 
      printf " %sfunction datww2_u_rsi (cc,m,k) result (atww2_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atww2_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atww2_u = -4*g**4*5*dat22_rsi(cc,s,m)"; nl();
      printf "  end function datww2_u_rsi"; nl ();  
      nl ();   
      printf " %sfunction datz4_s_rsi (cc,m,k) result (atz4_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atz4_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atz4_s = -4*g**4*costhw**4*dat00_rsi(cc,s,m)/3"; nl();
      printf "  end function datz4_s_rsi"; nl (); 
      nl ();   
      printf " %sfunction datz4_t_rsi (cc,m,k) result (atz4_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atz4_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atz4_t = -4*g**4*costhw**4*5*(dat02_rsi(cc,s,m) + 2*dat22_rsi(cc,s,m))/3"; nl();
      printf "  end function datz4_t_rsi"; nl (); 
      nl ();   
      printf " %sfunction datz4_u_rsi (cc,m,k) result (atz4_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atz4_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atz4_u = -4*g**4*costhw**4*5*(dat02_rsi(cc,s,m) + 2*dat22_rsi(cc,s,m))/3"; nl();
      printf "  end function datz4_u_rsi"; nl ();
      nl ();
      printf " %sfunction data4_s_rsi (cc,m,k) result (ata4_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ata4_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ata4_s = datz4_s_rsi (cc,m,k) / costhw**4 * sinthw**4"; nl();
      printf "  end function data4_s_rsi"; nl (); 
      nl ();   
      printf " %sfunction data4_t_rsi (cc,m,k) result (ata4_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ata4_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ata4_t = datz4_t_rsi (cc,m,k) / costhw**4 * sinthw**4"; nl();
      printf "  end function data4_t_rsi"; nl (); 
      nl ();   
      printf " %sfunction data4_u_rsi (cc,m,k) result (ata4_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ata4_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ata4_u = datz4_u_rsi (cc,m,k) / costhw**4 * sinthw**4"; nl();
      printf "  end function data4_u_rsi"; nl ();
      nl ();        
      printf " %sfunction dataw0_s_rsi (cc,m,k) result (ataw0_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ataw0_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ataw0_s = datzz0_s_rsi(cc,m,k) / costhw**2 * sinthw**2"; nl();
      printf "  end function dataw0_s_rsi"; nl ();       
      nl ();    
      printf " %sfunction dataw0_t_rsi (cc,m,k) result (ataw0_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ataw0_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ataw0_t = datzz0_t_rsi(cc,m,k) / costhw**2 * sinthw**2"; nl();
      printf "  end function dataw0_t_rsi"; nl ();       
      nl (); 
      printf " %sfunction dataw0_u_rsi (cc,m,k) result (ataw0_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ataw0_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ataw0_u = datzz0_u_rsi(cc,m,k) / costhw**2 * sinthw**2"; nl();
      printf "  end function dataw0_u_rsi"; nl ();       
      nl ();  
      printf " %sfunction dataw1_s_rsi (cc,m,k) result (ataw1_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ataw1_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ataw1_s = datzz1_s_rsi(cc,m,k) / costhw**2 * sinthw**2"; nl();
      printf "  end function dataw1_s_rsi"; nl ();       
      nl ();    
      printf " %sfunction dataw1_t_rsi (cc,m,k) result (ataw1_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ataw1_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ataw1_t = datzz1_t_rsi(cc,m,k) / costhw**2 * sinthw**2"; nl();
      printf "  end function dataw1_t_rsi"; nl ();       
      nl (); 
      printf " %sfunction dataw1_u_rsi (cc,m,k) result (ataw1_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ataw1_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ataw1_u = datzz1_u_rsi(cc,m,k) / costhw**2 * sinthw**2"; nl();
      printf "  end function dataw1_u_rsi"; nl ();       
      nl ();    
      printf " %sfunction dataz_s_rsi (cc,m,k) result (ataz_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ataz_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ataz_s = datz4_s_rsi(cc,m,k) / costhw**2 * sinthw**2"; nl();
      printf "  end function dataz_s_rsi"; nl ();       
      nl ();    
      printf " %sfunction dataz_t_rsi (cc,m,k) result (ataz_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ataz_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ataz_t = datz4_t_rsi(cc,m,k) / costhw**2 * sinthw**2"; nl();
      printf "  end function dataz_t_rsi"; nl ();       
      nl (); 
      printf " %sfunction dataz_u_rsi (cc,m,k) result (ataz_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ataz_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ataz_u = datz4_u_rsi(cc,m,k) / costhw**2 * sinthw**2"; nl();
      printf "  end function dataz_u_rsi"; nl ();       
      nl ();        
      printf " %sfunction datazw0_s_rsi (cc,m,k) result (atazw0_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atazw0_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atazw0_s = datzz0_s_rsi(cc,m,k) / costhw * sinthw"; nl();
      printf "  end function datazw0_s_rsi"; nl ();       
      nl ();    
      printf " %sfunction datazw0_t_rsi (cc,m,k) result (atazw0_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atazw0_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atazw0_t = datzz0_t_rsi(cc,m,k) / costhw * sinthw"; nl();
      printf "  end function datazw0_t_rsi"; nl ();       
      nl (); 
      printf " %sfunction datazw0_u_rsi (cc,m,k) result (atazw0_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atazw0_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atazw0_u = datzz0_u_rsi(cc,m,k) / costhw * sinthw"; nl();
      printf "  end function datazw0_u_rsi"; nl ();       
      nl ();  
      printf " %sfunction datazw1_s_rsi (cc,m,k) result (atazw1_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atazw1_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atazw1_s = datzz1_s_rsi(cc,m,k) / costhw * sinthw"; nl();
      printf "  end function datazw1_s_rsi"; nl ();       
      nl ();    
      printf " %sfunction datazw1_t_rsi (cc,m,k) result (atazw1_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atazw1_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atazw1_t = datzz1_t_rsi(cc,m,k) / costhw * sinthw"; nl();
      printf "  end function datazw1_t_rsi"; nl ();       
      nl (); 
      printf " %sfunction datazw1_u_rsi (cc,m,k) result (atazw1_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: atazw1_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      atazw1_u = datzz1_u_rsi(cc,m,k) / costhw * sinthw"; nl();
      printf "  end function datazw1_u_rsi"; nl ();      
      nl ();
      printf " %sfunction dat3az_s_rsi (cc,m,k) result (at3az_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: at3az_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      at3az_s = datz4_s_rsi(cc,m,k) / costhw**3 * sinthw**3"; nl();
      printf "  end function dat3az_s_rsi"; nl ();       
      nl ();    
      printf " %sfunction dat3az_t_rsi (cc,m,k) result (at3az_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: at3az_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      at3az_t = datz4_t_rsi(cc,m,k) / costhw**3 * sinthw**3"; nl();
      printf "  end function dat3az_t_rsi"; nl ();       
      nl (); 
      printf " %sfunction dat3az_u_rsi (cc,m,k) result (at3az_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: at3az_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      at3az_u = datz4_u_rsi(cc,m,k) / costhw**3 * sinthw**3"; nl();
      printf "  end function dat3az_u_rsi"; nl ();
      nl ();  
      printf " %sfunction data3z_s_rsi (cc,m,k) result (ata3z_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ata3z_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ata3z_s = datz4_s_rsi(cc,m,k) / costhw * sinthw"; nl();
      printf "  end function data3z_s_rsi"; nl ();       
      nl ();    
      printf " %sfunction data3z_t_rsi (cc,m,k) result (ata3z_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ata3z_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ata3z_t = datz4_t_rsi(cc,m,k) / costhw * sinthw"; nl();
      printf "  end function data3z_t_rsi"; nl ();           
      nl (); 
      printf " %sfunction data3z_u_rsi (cc,m,k) result (ata3z_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: ata3z_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      ata3z_u = datz4_u_rsi(cc,m,k) / costhw * sinthw"; nl();
      printf "  end function data3z_u_rsi"; nl ();           
      nl ();       
      printf "  %sfunction damhw0_s_0 (cc,m,k) result (amhw0_s)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amhw0_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amhw0_s = 4*cc(14)*dam00(cc,s,m)/3"; nl ();
      printf "  end function damhw0_s_0"; nl ();
      nl ();
      printf "  %sfunction damhw0_t_0 (cc,m,k) result (amhw0_t)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amhw0_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amhw0_t =  - 4*cc(14)*(dam01(cc,s,m) - dam21(cc,s,m) &"; nl ();
      printf "                        - 25*dam02(cc,s,m)/3 + 25*dam22(cc,s,m)/3)/6"; nl (); 
      printf "  end function damhw0_t_0"; nl ();
      nl ();
      printf "  %sfunction damhw0_u_0 (cc,m,k) result (amhw0_u)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amhw0_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amhw0_u = - cc(14)*4*(dam01(cc,s,m) - dam21(cc,s,m) &"; nl ();
      printf "                       + 25*dam02(cc,s,m)/3 - 25*dam22(cc,s,m)/3)/6"; nl (); 
      printf "  end function damhw0_u_0"; nl ();
      nl ();      
      printf "  %sfunction damhz0_s_0 (cc,m,k) result (amhz0_s)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amhz0_s"; nl ();
      printf "      amhz0_s = damhw0_s_0(cc,m,k) * costhw**2"; nl();
      printf "  end function damhz0_s_0"; nl ();
      nl ();
      printf "  %sfunction damhz0_t_0 (cc,m,k) result (amhz0_t)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amhz0_t"; nl ();
      printf "      amhz0_t = damhw0_t_0(cc,m,k) * costhw**2"; nl();
      printf "  end function damhz0_t_0"; nl ();
      nl ();
      printf "  %sfunction damhz0_u_0 (cc,m,k) result (amhz0_u)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amhz0_u"; nl ();
      printf "      amhz0_u = damhw0_u_0(cc,m,k) * costhw**2"; nl();
      printf "  end function damhz0_u_0"; nl ();
      nl ();      
      printf "  %sfunction damhw1_s_0 (cc,m,k) result (amhw1_s)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amhw1_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amhw1_s = 0"; nl (); 
      printf "  end function damhw1_s_0"; nl ();
      nl ();  
      printf "  %sfunction damhw1_t_0 (cc,m,k) result (amhw1_t)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amhw1_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amhw1_t = - 4*cc(14)*(3*dam11(cc,s,m) + 3*dam21(cc,s,m) &"; nl ();
      printf "                         - 25*dam12(cc,s,m) - 25*dam22(cc,s,m))/4"; nl (); 
      printf "  end function damhw1_t_0"; nl ();
      nl ();  
      printf "  %sfunction damhw1_u_0 (cc,m,k) result (amhw1_u)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amhw1_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amhw1_u = - 4*cc(14)*(-3*dam11(cc,s,m) + 3*dam21(cc,s,m) &"; nl ();
      printf "                          - 25*dam12(cc,s,m) + 25*dam22(cc,s,m))/4"; nl (); 
      printf "  end function damhw1_u_0"; nl ();
      nl ();
      printf "  %sfunction damhz1_s_0 (cc,m,k) result (amhz1_s)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amhz1_s"; nl ();
      printf "      amhz1_s = damhw1_s_0(cc,m,k) * costhw**2"; nl ();
      printf "  end function damhz1_s_0"; nl ();
      nl ();  
      printf "  %sfunction damhz1_t_0 (cc,m,k) result (amhz1_t)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amhz1_t"; nl ();
      printf "      amhz1_t = damhw1_t_0(cc,m,k) * costhw**2"; nl ();
      printf "  end function damhz1_t_0"; nl ();
      nl ();  
      printf "  %sfunction damhz1_u_0 (cc,m,k) result (amhz1_u)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amhz1_u"; nl ();
      printf "      amhz1_u = damhw1_u_0(cc,m,k) * costhw**2"; nl ();
      printf "  end function damhz1_u_0"; nl ();
      nl ();            
      printf "  %sfunction damhw0_s_1 (cc,m,k) result (amhw0_s)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amhw0_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amhw0_s = 4*cc(14)*dam00_1(cc,s,m)/3"; nl ();
      printf "  end function damhw0_s_1"; nl ();
      nl ();
      printf "  %sfunction damhw0_t_1 (cc,m,k) result (amhw0_t)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amhw0_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amhw0_t =  - 4*cc(14)*(dam01_1(cc,s,m) - dam21_1(cc,s,m) &"; nl ();
      printf "                        - 25*dam02_1(cc,s,m)/3 + 25*dam22_1(cc,s,m)/3)/6"; nl (); 
      printf "  end function damhw0_t_1"; nl ();
      nl ();
      printf "  %sfunction damhw0_u_1 (cc,m,k) result (amhw0_u)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amhw0_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amhw0_u = - 4*cc(14)*(dam01_1(cc,s,m) - dam21_1(cc,s,m) &"; nl ();
      printf "                       + 25*dam02_1(cc,s,m)/3 - 25*dam22_1(cc,s,m)/3)/6"; nl (); 
      printf "  end function damhw0_u_1"; nl ();
      nl ();      
      printf "  %sfunction damhz0_s_1 (cc,m,k) result (amhz0_s)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amhz0_s"; nl ();
      printf "      amhz0_s = damhw0_s_1(cc,m,k) * costhw**2"; nl();
      printf "  end function damhz0_s_1"; nl ();
      nl ();
      printf "  %sfunction damhz0_t_1 (cc,m,k) result (amhz0_t)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amhz0_t"; nl ();
      printf "      amhz0_t = damhw0_t_1(cc,m,k) * costhw**2"; nl();
      printf "  end function damhz0_t_1"; nl ();
      nl ();
      printf "  %sfunction damhz0_u_1 (cc,m,k) result (amhz0_u)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amhz0_u"; nl ();
      printf "      amhz0_u = damhw0_u_1(cc,m,k) * costhw**2"; nl();
      printf "  end function damhz0_u_1"; nl ();
      nl ();      
      printf "  %sfunction damhw1_s_1 (cc,m,k) result (amhw1_s)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amhw1_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amhw1_s = 0"; nl (); 
      printf "  end function damhw1_s_1"; nl ();
      nl ();  
      printf "  %sfunction damhw1_t_1 (cc,m,k) result (amhw1_t)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amhw1_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amhw1_t = - 4*cc(14)*(3*dam11_1(cc,s,m) + 3*dam21_1(cc,s,m) &"; nl ();
      printf "                         - 25*dam12_1(cc,s,m) - 25*dam22_1(cc,s,m))/4"; nl (); 
      printf "  end function damhw1_t_1"; nl ();
      nl ();  
      printf "  %sfunction damhw1_u_1 (cc,m,k) result (amhw1_u)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amhw1_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amhw1_u = - 4*cc(14)*(-3*dam11_1(cc,s,m) + 3*dam21_1(cc,s,m) &"; nl ();
      printf "                          - 25*dam12_1(cc,s,m) + 25*dam22_1(cc,s,m))/4"; nl (); 
      printf "  end function damhw1_u_1"; nl ();
      nl ();
      printf "  %sfunction damhz1_s_1 (cc,m,k) result (amhz1_s)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amhz1_s"; nl ();
      printf "      amhz1_s = damhw1_s_1(cc,m,k) * costhw**2"; nl ();
      printf "  end function damhz1_s_1"; nl ();
      nl ();  
      printf "  %sfunction damhz1_t_1 (cc,m,k) result (amhz1_t)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amhz1_t"; nl ();
      printf "      amhz1_t = damhw1_t_1(cc,m,k) * costhw**2"; nl ();
      printf "  end function damhz1_t_1"; nl ();
      nl ();  
      printf "  %sfunction damhz1_u_1 (cc,m,k) result (amhz1_u)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amhz1_u"; nl ();
      printf "      amhz1_u = damhw1_u_1(cc,m,k) * costhw**2"; nl ();
      printf "  end function damhz1_u_1"; nl ();
      nl ();       
      printf "  %sfunction damhw0_s_7 (cc,m,k) result (amhw0_s)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amhw0_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amhw0_s = 4*cc(14)*dam00_7(cc,s,m)/3"; nl ();
      printf "  end function damhw0_s_7"; nl ();
      nl ();
      printf "  %sfunction damhw0_t_7 (cc,m,k) result (amhw0_t)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amhw0_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amhw0_t =  4*cc(14)*(dam01_7(cc,s,m) - dam21_7(cc,s,m) &"; nl ();
      printf "                        - 25*dam02_7(cc,s,m)/3 + 25*dam22_7(cc,s,m)/3)/6"; nl (); 
      printf "  end function damhw0_t_7"; nl ();
      nl ();
      printf "  %sfunction damhw0_u_7 (cc,m,k) result (amhw0_u)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amhw0_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amhw0_u = 4*cc(14)*(dam01_7(cc,s,m) - dam21_7(cc,s,m) &"; nl ();
      printf "                       + 25*dam02_7(cc,s,m)/3 - 25*dam22_7(cc,s,m)/3)/6"; nl (); 
      printf "  end function damhw0_u_7"; nl ();
      nl ();      
      printf "  %sfunction damhz0_s_7 (cc,m,k) result (amhz0_s)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amhz0_s"; nl ();
      printf "      amhz0_s = damhw0_s_7(cc,m,k) * costhw**2"; nl();
      printf "  end function damhz0_s_7"; nl ();
      nl ();
      printf "  %sfunction damhz0_t_7 (cc,m,k) result (amhz0_t)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amhz0_t"; nl ();
      printf "      amhz0_t = damhw0_t_7(cc,m,k) * costhw**2"; nl();
      printf "  end function damhz0_t_7"; nl ();
      nl ();
      printf "  %sfunction damhz0_u_7 (cc,m,k) result (amhz0_u)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amhz0_u"; nl ();
      printf "      amhz0_u = damhw0_u_7(cc,m,k) * costhw**2"; nl();
      printf "  end function damhz0_u_7"; nl ();
      nl ();      
      printf "  %sfunction damhw1_s_7 (cc,m,k) result (amhw1_s)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amhw1_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amhw1_s = 0"; nl (); 
      printf "  end function damhw1_s_7"; nl ();
      nl ();  
      printf "  %sfunction damhw1_t_7 (cc,m,k) result (amhw1_t)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amhw1_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amhw1_t = 4*cc(14)*(3*dam11_7(cc,s,m) + 3*dam21_7(cc,s,m) &"; nl ();
      printf "                         - 25*dam12_7(cc,s,m) - 25*dam22_7(cc,s,m))/4"; nl (); 
      printf "  end function damhw1_t_7"; nl ();
      nl ();  
      printf "  %sfunction damhw1_u_7 (cc,m,k) result (amhw1_u)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amhw1_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amhw1_u = 4*cc(14)*(-3*dam11_7(cc,s,m) + 3*dam21_7(cc,s,m) &"; nl ();
      printf "                          - 25*dam12_7(cc,s,m) + 25*dam22_7(cc,s,m))/4"; nl (); 
      printf "  end function damhw1_u_7"; nl ();
      nl ();
      printf "  %sfunction damhz1_s_7 (cc,m,k) result (amhz1_s)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amhz1_s"; nl ();
      printf "      amhz1_s = damhw1_s_7(cc,m,k) * costhw**2"; nl ();
      printf "  end function damhz1_s_7"; nl ();
      nl ();  
      printf "  %sfunction damhz1_t_7 (cc,m,k) result (amhz1_t)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amhz1_t"; nl ();
      printf "      amhz1_t = damhw1_t_7(cc,m,k) * costhw**2"; nl ();
      printf "  end function damhz1_t_7"; nl ();
      nl ();  
      printf "  %sfunction damhz1_u_7 (cc,m,k) result (amhz1_u)" pure; nl ();
      printf "      type(momentum), intent(in) :: k"; nl ();
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amhz1_u"; nl ();
      printf "      amhz1_u = damhw1_u_7(cc,m,k) * costhw**2"; nl ();
      printf "  end function damhz1_u_7"; nl ();
      nl ();      
      printf " %sfunction damzz0_s_0 (cc,m,k) result (amzz0_s)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amzz0_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amzz0_s = 4*mass(24)**2*dam00(cc,s,m)/3"; nl ();
      printf "  end function damzz0_s_0"; nl ();  
      nl ();
      printf " %sfunction damzz0_t_0 (cc,m,k) result (amzz0_t)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amzz0_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amzz0_t = -4*mass(24)**2*(dam01(cc,s,m) - dam21(cc,s,m) &"; nl ();
      printf "                           - 25*dam02(cc,s,m)/3 + 25*dam22(cc,s,m)/3)/6"; nl ();
      printf "  end function damzz0_t_0"; nl ();  
      nl ();
      printf " %sfunction damzz0_u_0 (cc,m,k) result (amzz0_u)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amzz0_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amzz0_u = -4*mass(24)**2*(dam01(cc,s,m) - dam21(cc,s,m) &"; nl ();
      printf "                           + 25*dam02(cc,s,m)/3 - 25*dam22(cc,s,m)/3)/6"; nl ();
      printf "  end function damzz0_u_0"; nl ();  
      nl ();
      printf " %sfunction damzz1_s_0 (cc,m,k) result (amzz1_s)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amzz1_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amzz1_s = 0"; nl ();
      printf "  end function damzz1_s_0"; nl ();   
      nl ();
      printf " %sfunction damzz1_t_0 (cc,m,k) result (amzz1_t)" pure; nl (); 
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amzz1_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amzz1_t = -4*mass(24)**2*(3*dam11(cc,s,m) + 3*dam21(cc,s,m) &"; nl ();
      printf "                             - 25*dam12(cc,s,m) - 25*dam22(cc,s,m))/4"; nl ();
      printf "  end function damzz1_t_0"; nl ();  
      nl ();
      printf " %sfunction damzz1_u_0 (cc,m,k) result (amzz1_u)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amzz1_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amzz1_u = -4*mass(24)**2*(-3*dam11(cc,s,m) + 3*dam21(cc,s,m) &"; nl ();
      printf "                              - 25*dam12(cc,s,m) + 25*dam22(cc,s,m))/4"; nl ();
      printf "  end function damzz1_u_0"; nl ();  
      nl ();
      printf " %sfunction damww0_s_0 (cc,m,k) result (amww0_s)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amww0_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amww0_s = 4*mass(24)**2*dam00(cc,s,m)/3"; nl ();
      printf "  end function damww0_s_0"; nl ();   
      nl ();
      printf " %sfunction damww0_t_0 (cc,m,k) result (amww0_t)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amww0_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amww0_t = -4*mass(24)**2*(dam01(cc,s,m) + 3*dam11(cc,s,m)/2 &"; nl ();
      printf "                              + dam21(cc,s,m)/2 - 25*dam02(cc,s,m)/3 &"; nl ();
      printf "                           - 25*dam12(cc,s,m)/2 - 25*dam22(cc,s,m)/6)/2"; nl ();
      printf "  end function damww0_t_0"; nl ();        
      nl ();   
      printf " %sfunction damww0_u_0 (cc,m,k) result (amww0_u)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amww0_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amww0_u = -4*mass(24)**2*(dam01(cc,s,m) - 3*dam11(cc,s,m)/2 &"; nl ();
      printf "                              + dam21(cc,s,m)/2 + 25*dam02(cc,s,m)/3 &"; nl ();
      printf "                           - 25*dam12(cc,s,m)/2 + 25*dam22(cc,s,m)/6)/2"; nl ();
      printf "  end function damww0_u_0"; nl ();        
      nl ();    
      printf " %sfunction damww2_s_0 (cc,m,k) result (amww2_s)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amww2_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amww2_s = 0"; nl ();
      printf "  end function damww2_s_0"; nl ();        
      nl ();    
      printf " %sfunction damww2_t_0 (cc,m,k) result (amww2_t)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amww2_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amww2_t = -4*mass(24)**2*(3*dam21(cc,s,m) - 25*dam22(cc,s,m))/2"; nl ();
      printf "  end function damww2_t_0"; nl ();        
      nl (); 
      printf " %sfunction damww2_u_0 (cc,m,k) result (amww2_u)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amww2_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amww2_u = -4*mass(24)**2*(3*dam21(cc,s,m) - 25*dam22(cc,s,m))/2"; nl ();
      printf "  end function damww2_u_0"; nl ();        
      nl ();    
      printf " %sfunction damz4_s_0 (cc,m,k) result (amz4_s)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amz4_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amz4_s = 4*mass(24)**2*dam00(cc,s,m)/3"; nl();
      printf "  end function damz4_s_0"; nl (); 
      nl ();   
      printf " %sfunction damz4_t_0 (cc,m,k) result (amz4_t)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amz4_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amz4_t = -4*mass(24)**2*(dam01(cc,s,m)/2 + dam21(cc,s,m) &"; nl ();
      printf "                           -25*dam02(cc,s,m)/6 - 25*dam22(cc,s,m)/3)"; nl ();
      printf "  end function damz4_t_0"; nl (); 
      nl ();   
      printf " %sfunction damz4_u_0 (cc,m,k) result (amz4_u)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amz4_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amz4_u = -4*mass(24)**2*(dam01(cc,s,m)/2 + dam21(cc,s,m) &"; nl ();
      printf "                           -25*dam02(cc,s,m)/6 - 25*dam22(cc,s,m)/3)"; nl ();
      printf "  end function damz4_u_0"; nl (); 
      nl (); 
      printf " %sfunction damzz0_s_1 (cc,m,k) result (amzz0_s)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amzz0_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amzz0_s = 4*mass(24)**2*dam00_1(cc,s,m)/3"; nl ();
      printf "  end function damzz0_s_1"; nl ();  
      nl ();
      printf " %sfunction damzz0_t_1 (cc,m,k) result (amzz0_t)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amzz0_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amzz0_t = -4*mass(24)**2*(dam01_1(cc,s,m) - dam21_1(cc,s,m) &"; nl ();
      printf "                           - 25*dam02_1(cc,s,m)/3 + 25*dam22_1(cc,s,m)/3)/6"; nl ();         
      printf "  end function damzz0_t_1"; nl ();  
      nl ();
      printf " %sfunction damzz0_u_1 (cc,m,k) result (amzz0_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amzz0_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amzz0_u = -4*mass(24)**2*(dam01_1(cc,s,m) - dam21_1(cc,s,m) &"; nl ();
      printf "                           + 25*dam02_1(cc,s,m)/3 - 25*dam22_1(cc,s,m)/3)/6"; nl ();
      printf "  end function damzz0_u_1"; nl ();  
      nl ();
      printf " %sfunction damzz1_s_1 (cc,m,k) result (amzz1_s)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amzz1_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amzz1_s = 0"; nl ();
      printf "  end function damzz1_s_1"; nl ();   
      nl ();
      printf " %sfunction damzz1_t_1 (cc,m,k) result (amzz1_t)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amzz1_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amzz1_t = -4*mass(24)**2*(3*dam11_1(cc,s,m) + 3*dam21_1(cc,s,m) &"; nl ();
      printf "                             - 25*dam12_1(cc,s,m) - 25*dam22_1(cc,s,m))/4"; nl ();
      printf "  end function damzz1_t_1"; nl ();  
      nl ();
      printf " %sfunction damzz1_u_1 (cc,m,k) result (amzz1_u)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amzz1_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amzz1_u = -4*mass(24)**2*(-3*dam11_1(cc,s,m) + 3*dam21_1(cc,s,m) &"; nl ();
      printf "                              - 25*dam12_1(cc,s,m) + 25*dam22_1(cc,s,m))/4"; nl ();
      printf "  end function damzz1_u_1"; nl ();  
      nl ();
      printf " %sfunction damww0_s_1 (cc,m,k) result (amww0_s)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amww0_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amww0_s = 4*mass(24)**2*dam00_1(cc,s,m)/3"; nl ();
      printf "  end function damww0_s_1"; nl ();   
      nl ();
      printf " %sfunction damww0_t_1 (cc,m,k) result (amww0_t)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amww0_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amww0_t = -4*mass(24)**2*(dam01_1(cc,s,m) + 3*dam11_1(cc,s,m)/2 &"; nl ();
      printf "                              + dam21_1(cc,s,m)/2 - 25*dam02_1(cc,s,m)/3 &"; nl ();
      printf "                           - 25*dam12_1(cc,s,m)/2 - 25*dam22_1(cc,s,m)/6)/2"; nl ();
      printf "  end function damww0_t_1"; nl ();        
      nl ();   
      printf " %sfunction damww0_u_1 (cc,m,k) result (amww0_u)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amww0_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amww0_u = -4*mass(24)**2*(dam01_1(cc,s,m) - 3*dam11_1(cc,s,m)/2 &"; nl ();
      printf "                              + dam21_1(cc,s,m)/2 + 25*dam02_1(cc,s,m)/3 &"; nl ();
      printf "                           - 25*dam12_1(cc,s,m)/2 + 25*dam22_1(cc,s,m)/6)/2"; nl ();
      printf "  end function damww0_u_1"; nl ();        
      nl ();    
      printf " %sfunction damww2_s_1 (cc,m,k) result (amww2_s)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amww2_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amww2_s = 0"; nl ();
      printf "  end function damww2_s_1"; nl ();        
      nl ();    
      printf " %sfunction damww2_t_1 (cc,m,k) result (amww2_t)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amww2_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amww2_t = -4*mass(24)**2*(3*dam21_1(cc,s,m) - 25*dam22_1(cc,s,m))/2"; nl ();
      printf "  end function damww2_t_1"; nl ();        
      nl (); 
      printf " %sfunction damww2_u_1 (cc,m,k) result (amww2_u)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amww2_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amww2_u = -4*mass(24)**2*(3*dam21_1(cc,s,m) - 25*dam22_1(cc,s,m))/2"; nl ();
      printf "  end function damww2_u_1"; nl ();        
      nl ();    
      printf " %sfunction damz4_s_1 (cc,m,k) result (amz4_s)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amz4_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amz4_s = 4*mass(24)**2*dam00_1(cc,s,m)/3"; nl ();
      printf "  end function damz4_s_1"; nl (); 
      nl ();   
      printf " %sfunction damz4_t_1 (cc,m,k) result (amz4_t)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amz4_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amz4_t = -4*mass(24)**2*(dam01_1(cc,s,m)/2 + dam21_1(cc,s,m) &"; nl ();
      printf "                          - 25*dam02_1(cc,s,m)/6 - 25*dam22_1(cc,s,m)/3)"; nl ();
      printf "  end function damz4_t_1"; nl (); 
      nl ();   
      printf " %sfunction damz4_u_1 (cc,m,k) result (amz4_u)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amz4_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amz4_u = -4*mass(24)**2*(dam01_1(cc,s,m)/2 + dam21_1(cc,s,m) &"; nl ();
      printf "                          - 25*dam02_1(cc,s,m)/6 - 25*dam22_1(cc,s,m)/3)"; nl ();               
      printf "  end function damz4_u_1"; nl (); 
      nl ();
      printf " %sfunction damzz0_s_7 (cc,m,k) result (amzz0_s)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amzz0_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amzz0_s = 4*mass(24)**2*dam00_7(cc,s,m)/3"; nl ();
      printf "  end function damzz0_s_7"; nl ();  
      nl ();
      printf " %sfunction damzz0_t_7 (cc,m,k) result (amzz0_t)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amzz0_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amzz0_t = 4*mass(24)**2*(dam01_7(cc,s,m) - dam21_7(cc,s,m) &"; nl ();
      printf "                           - 25*dam02_7(cc,s,m)/3 + 25*dam22_7(cc,s,m)/3)/6"; nl ();         
      printf "  end function damzz0_t_7"; nl ();  
      nl ();
      printf " %sfunction damzz0_u_7 (cc,m,k) result (amzz0_u)" pure; nl();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amzz0_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amzz0_u = 4*mass(24)**2*(dam01_7(cc,s,m) - dam21_7(cc,s,m) &"; nl ();
      printf "                           + 25*dam02_7(cc,s,m)/3 - 25*dam22_7(cc,s,m)/3)/6"; nl ();
      printf "  end function damzz0_u_7"; nl ();  
      nl ();
      printf " %sfunction damzz1_s_7 (cc,m,k) result (amzz1_s)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amzz1_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amzz1_s = 0"; nl ();
      printf "  end function damzz1_s_7"; nl ();   
      nl ();
      printf " %sfunction damzz1_t_7 (cc,m,k) result (amzz1_t)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amzz1_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amzz1_t = 4*mass(24)**2*(3*dam11_7(cc,s,m) + 3*dam21_7(cc,s,m) &"; nl ();
      printf "                             - 25*dam12_7(cc,s,m) - 25*dam22_7(cc,s,m))/4"; nl ();
      printf "  end function damzz1_t_7"; nl ();  
      nl ();
      printf " %sfunction damzz1_u_7 (cc,m,k) result (amzz1_u)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amzz1_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amzz1_u = 4*mass(24)**2*(-3*dam11_7(cc,s,m) + 3*dam21_7(cc,s,m) &"; nl ();
      printf "                              - 25*dam12_7(cc,s,m) + 25*dam22_7(cc,s,m))/4"; nl ();
      printf "  end function damzz1_u_7"; nl ();  
      nl ();
      printf " %sfunction damww0_s_7 (cc,m,k) result (amww0_s)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amww0_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amww0_s = 4*mass(24)**2*dam00_7(cc,s,m)/3"; nl ();
      printf "  end function damww0_s_7"; nl ();   
      nl ();
      printf " %sfunction damww0_t_7 (cc,m,k) result (amww0_t)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amww0_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amww0_t = 4*mass(24)**2*(dam01_7(cc,s,m) + 3*dam11_7(cc,s,m)/2 &"; nl ();
      printf "                              + dam21_7(cc,s,m)/2 - 25*dam02_7(cc,s,m)/3 &"; nl ();
      printf "                           - 25*dam12_7(cc,s,m)/2 - 25*dam22_7(cc,s,m)/6)/2"; nl ();
      printf "  end function damww0_t_7"; nl ();        
      nl ();   
      printf " %sfunction damww0_u_7 (cc,m,k) result (amww0_u)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amww0_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amww0_u = 4*mass(24)**2*(dam01_7(cc,s,m) - 3*dam11_7(cc,s,m)/2 &"; nl ();
      printf "                              + dam21_7(cc,s,m)/2 + 25*dam02_7(cc,s,m)/3 &"; nl ();
      printf "                           - 25*dam12_7(cc,s,m)/2 + 25*dam22_7(cc,s,m)/6)/2"; nl ();
      printf "  end function damww0_u_7"; nl ();        
      nl ();    
      printf " %sfunction damww2_s_7 (cc,m,k) result (amww2_s)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amww2_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amww2_s = 0"; nl ();
      printf "  end function damww2_s_7"; nl ();        
      nl ();    
      printf " %sfunction damww2_t_7 (cc,m,k) result (amww2_t)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amww2_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amww2_t = 4*mass(24)**2*(3*dam21_7(cc,s,m) - 25*dam22_7(cc,s,m))/2"; nl ();
      printf "  end function damww2_t_7"; nl ();        
      nl (); 
      printf " %sfunction damww2_u_7 (cc,m,k) result (amww2_u)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amww2_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amww2_u = 4*mass(24)**2*(3*dam21_7(cc,s,m) - 25*dam22_7(cc,s,m))/2"; nl ();
      printf "  end function damww2_u_7"; nl ();        
      nl ();    
      printf " %sfunction damz4_s_7 (cc,m,k) result (amz4_s)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amz4_s"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amz4_s = 4*mass(24)**2*dam00_7(cc,s,m)/3"; nl ();
      printf "  end function damz4_s_7"; nl (); 
      nl ();   
      printf " %sfunction damz4_t_7 (cc,m,k) result (amz4_t)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amz4_t"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amz4_t = 4*mass(24)**2*(dam01_7(cc,s,m)/2 + dam21_7(cc,s,m) &"; nl ();
      printf "                          - 25*dam02_7(cc,s,m)/6 - 25*dam22_7(cc,s,m)/3)"; nl ();
      printf "  end function damz4_t_7"; nl (); 
      nl ();   
      printf " %sfunction damz4_u_7 (cc,m,k) result (amz4_u)" pure; nl ();
      printf "     type(momentum), intent(in) :: k"; nl (); 
      printf "      real(kind=default), dimension(1:14), intent(in) :: cc"; nl ();
      printf "      real(kind=default), dimension(1:5), intent(in) :: m"; nl ();      
      printf "      real(kind=default) :: s"; nl ();
      printf "      complex(kind=default) :: amz4_u"; nl ();
      printf "      s = k*k"; nl ();
      printf "      amz4_u = 4*mass(24)**2*(dam01_7(cc,s,m)/2 + dam21_7(cc,s,m) &"; nl ();
      printf "                          - 25*dam02_7(cc,s,m)/6 - 25*dam22_7(cc,s,m)/3)"; nl ();               
      printf "  end function damz4_u_7"; nl (); 
      nl ();      
  end

(*i
 *  Local Variables:
 *  mode:caml
 *  indent-tabs-mode:nil
 *  page-delimiter:"^(\\* .*\n"
 *  End:
i*)
