! WHIZARD 2.2.8 Nov 22 2015
! 
! Copyright (C) 1999-2015 by 
!     Wolfgang Kilian <kilian@physik.uni-siegen.de>
!     Thorsten Ohl <ohl@physik.uni-wuerzburg.de>
!     Juergen Reuter <juergen.reuter@desy.de>
!     
!     with contributions from
!     Fabian Bach <fabian.bach@t-online.de>
!     Bijan Chokoufe <bijan.chokoufe@desy.de>
!     Christian Speckner <cnspeckn@googlemail.com> 
!     Soyoung Shim <soyoung.shim@desy.de>
!     Florian Staub <florian.staub@cern.ch>  
!     Christian Weiss <christian.weiss@desy.de>
!     and Hans-Werner Boschmann, Felix Braam, 
!     Sebastian Schmidt, So-young Shim, Daniel Wiesler 
!
! WHIZARD is free software; you can redistribute it and/or modify it
! under the terms of the GNU General Public License as published by 
! the Free Software Foundation; either version 2, or (at your option)
! any later version.
!
! WHIZARD is distributed in the hope that it will be useful, but
! WITHOUT ANY WARRANTY; without even the implied warranty of
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
! GNU General Public License for more details.
!
! You should have received a copy of the GNU General Public License
! along with this program; if not, write to the Free Software
! Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! This file has been stripped of most comments.  For documentation, refer
! to the source 'whizard.nw'

module rng_base

  use kinds, only: default
  use kinds, only: i16
  use constants, only: TWOPI

  implicit none
  private

  public :: rng_t
  public :: rng_factory_t

  type, abstract :: rng_t
   contains
     procedure (rng_init), deferred :: init
     procedure (rng_final), deferred :: final
     procedure (rng_write), deferred :: write
     generic :: generate => generate_single, generate_array
     procedure (rng_generate_single), deferred :: generate_single
     procedure (rng_generate_array), deferred :: generate_array
     generic :: generate_gaussian => &
          rng_generate_gaussian_single, rng_generate_gaussian_array
     procedure, private :: rng_generate_gaussian_single
     procedure, private :: rng_generate_gaussian_array
  end type rng_t

  type, abstract :: rng_factory_t
   contains
     procedure (rng_factory_write), deferred :: write
     procedure (rng_factory_init), deferred :: init
     procedure (rng_factory_make), deferred :: make
  end type rng_factory_t
  

  abstract interface
     subroutine rng_init (rng, seed)
       import
       class(rng_t), intent(out) :: rng
       integer, intent(in), optional :: seed
     end subroutine rng_init
  end interface
  
  abstract interface
     subroutine rng_final (rng)
       import
       class(rng_t), intent(inout) :: rng
     end subroutine rng_final
  end interface
  
  abstract interface
     subroutine rng_write (rng, unit, indent)
       import
       class(rng_t), intent(in) :: rng
       integer, intent(in), optional :: unit, indent
     end subroutine rng_write
  end interface
  
  abstract interface
     subroutine rng_generate_single (rng, x)
       import
       class(rng_t), intent(inout) :: rng
       real(default), intent(out) :: x
     end subroutine rng_generate_single
  end interface
  
  abstract interface
     subroutine rng_generate_array (rng, x)
       import
       class(rng_t), intent(inout) :: rng
       real(default), dimension(:), intent(out) :: x
     end subroutine rng_generate_array
  end interface
  
  abstract interface
     subroutine rng_factory_write (object, unit)
       import
       class(rng_factory_t), intent(in) :: object
       integer, intent(in), optional :: unit
     end subroutine rng_factory_write
  end interface
  
  abstract interface
     subroutine rng_factory_init (factory, seed)
       import
       class(rng_factory_t), intent(out) :: factory
       integer(i16), intent(in), optional :: seed
     end subroutine rng_factory_init
  end interface
       
  abstract interface
     subroutine rng_factory_make (factory, rng)
       import
       class(rng_factory_t), intent(inout) :: factory
       class(rng_t), intent(out), allocatable :: rng
     end subroutine rng_factory_make
  end interface
  

contains

  subroutine rng_generate_gaussian_single (rng, x)
    class(rng_t), intent(inout) :: rng
    real(default), intent(out) :: x
    real(default), dimension(2) :: u
    call rng%generate (u)
    x = sin (twopi * u(1)) * sqrt (- 2 * log (u(2)))
  end subroutine rng_generate_gaussian_single
  
  subroutine rng_generate_gaussian_array (rng, x)
    class(rng_t), intent(inout) :: rng
    real(default), dimension(:), intent(out) :: x
    integer :: i
    do i = 1, size (x)
       call rng%generate_gaussian (x(i))
    end do
  end subroutine rng_generate_gaussian_array
  

end module rng_base
