/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "sw" locale.
 */
public class LocalizedNamesImpl_sw extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "TZ",
        "CD",
        "KE",
        "UG",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "ZA",
        "IS",
        "AR",
        "AL",
        "DZ",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AM",
        "AW",
        "AU",
        "AT",
        "IE",
        "AZ",
        "BB",
        "BS",
        "BH",
        "BD",
        "BY",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BO",
        "BA",
        "BW",
        "BR",
        "BN",
        "BF",
        "BG",
        "BI",
        "CV",
        "EA",
        "TD",
        "CZ",
        "CL",
        "CI",
        "HR",
        "CU",
        "CW",
        "CY",
        "DK",
        "DG",
        "DM",
        "EC",
        "SV",
        "IO",
        "ER",
        "EE",
        "ET",
        "EZ",
        "AE",
        "FJ",
        "GA",
        "GM",
        "GH",
        "GI",
        "GN",
        "GW",
        "GL",
        "GD",
        "GP",
        "GU",
        "GT",
        "GG",
        "GF",
        "GQ",
        "GY",
        "HT",
        "TF",
        "HN",
        "HK",
        "HU",
        "IN",
        "ID",
        "IQ",
        "IR",
        "IL",
        "IT",
        "JM",
        "CF",
        "DO",
        "CD",
        "JP",
        "JE",
        "DJ",
        "GE",
        "JO",
        "KH",
        "CM",
        "CA",
        "KZ",
        "KE",
        "KI",
        "KG",
        "AC",
        "BV",
        "CP",
        "HM",
        "CX",
        "IM",
        "NF",
        "CO",
        "KM",
        "CG",
        "KP",
        "KR",
        "XK",
        "CR",
        "KW",
        "LA",
        "LV",
        "LB",
        "LS",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MO",
        "MK",
        "MG",
        "PS",
        "MW",
        "MV",
        "MY",
        "ML",
        "MT",
        "US",
        "MQ",
        "YT",
        "MX",
        "FM",
        "EG",
        "VA",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MU",
        "MR",
        "MA",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "NC",
        "NE",
        "NG",
        "NI",
        "NU",
        "NO",
        "NZ",
        "QO",
        "OM",
        "PK",
        "PW",
        "PA",
        "PG",
        "PY",
        "PE",
        "PL",
        "PF",
        "PR",
        "QA",
        "RE",
        "RO",
        "RW",
        "EH",
        "WS",
        "AS",
        "SM",
        "PM",
        "ST",
        "SA",
        "SN",
        "RS",
        "SL",
        "SG",
        "SX",
        "SK",
        "SI",
        "SO",
        "LK",
        "BL",
        "SH",
        "KN",
        "LC",
        "MF",
        "VC",
        "SD",
        "SS",
        "SR",
        "SJ",
        "SY",
        "TH",
        "TW",
        "TJ",
        "TZ",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TM",
        "TV",
        "BE",
        "CN",
        "GB",
        "FR",
        "PH",
        "FI",
        "UG",
        "GR",
        "ES",
        "NL",
        "BQ",
        "DE",
        "UA",
        "UN",
        "EU",
        "PT",
        "UY",
        "RU",
        "SC",
        "SZ",
        "SE",
        "CH",
        "TR",
        "UZ",
        "VU",
        "VE",
        "VN",
        "UM",
        "AX",
        "KY",
        "CC",
        "CK",
        "FK",
        "FO",
        "GS",
        "IC",
        "MP",
        "MH",
        "PN",
        "SB",
        "TC",
        "VI",
        "VG",
        "WF",
        "XA",
        "XB",
        "YE",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Dunia");
    namesMap.put("002", "Afrika");
    namesMap.put("003", "Amerika Kaskazini");
    namesMap.put("005", "Amerika Kusini");
    namesMap.put("011", "Afrika ya Magharibi");
    namesMap.put("013", "Amerika ya Kati");
    namesMap.put("014", "Afrika ya Mashariki");
    namesMap.put("015", "Afrika ya Kaskazini");
    namesMap.put("017", "Afrika ya Kati");
    namesMap.put("018", "Afrika ya Kusini");
    namesMap.put("019", "Amerika");
    namesMap.put("021", "Amerika ya Kaskazini");
    namesMap.put("029", "Karibiani");
    namesMap.put("030", "Asia ya Mashariki");
    namesMap.put("034", "Asia ya Kusini");
    namesMap.put("035", "Asia ya Kusini Mashariki");
    namesMap.put("039", "Ulaya ya Kusini");
    namesMap.put("057", "Eneo la Mikronesia");
    namesMap.put("143", "Asia ya Kati");
    namesMap.put("145", "Asia ya Magharibi");
    namesMap.put("150", "Ulaya");
    namesMap.put("151", "Ulaya ya Mashariki");
    namesMap.put("154", "Ulaya ya Kaskazini");
    namesMap.put("155", "Ulaya ya Magharibi");
    namesMap.put("202", "Afrika Kusine mwa Jangwa la Sahara");
    namesMap.put("419", "Amerika ya Kilatini");
    namesMap.put("AC", "Kisiwa cha Ascension");
    namesMap.put("AE", "Falme za Kiarabu");
    namesMap.put("AG", "Antigua na Barbuda");
    namesMap.put("AQ", "Antaktiki");
    namesMap.put("AR", "Ajentina");
    namesMap.put("AS", "Samoa ya Marekani");
    namesMap.put("AX", "Visiwa vya Aland");
    namesMap.put("AZ", "Azerbaijani");
    namesMap.put("BA", "Bosnia na Hezegovina");
    namesMap.put("BB", "Babadosi");
    namesMap.put("BD", "Bangladeshi");
    namesMap.put("BE", "Ubelgiji");
    namesMap.put("BF", "Bukinafaso");
    namesMap.put("BH", "Bahareni");
    namesMap.put("BL", "St. Barthelemy");
    namesMap.put("BQ", "Uholanzi ya Karibiani");
    namesMap.put("BS", "Bahama");
    namesMap.put("BV", "Kisiwa cha Bouvet");
    namesMap.put("CA", "Kanada");
    namesMap.put("CC", "Visiwa vya Cocos (Keeling)");
    namesMap.put("CD", "Jamhuri ya Kidemokrasia ya Kongo");
    namesMap.put("CF", "Jamhuri ya Afrika ya Kati");
    namesMap.put("CG", "Kongo - Brazzaville");
    namesMap.put("CH", "Uswisi");
    namesMap.put("CI", "Cote d’Ivoire");
    namesMap.put("CK", "Visiwa vya Cook");
    namesMap.put("CM", "Kameruni");
    namesMap.put("CN", "Uchina");
    namesMap.put("CO", "Kolombia");
    namesMap.put("CP", "Kisiwa cha Clipperton");
    namesMap.put("CR", "Kostarika");
    namesMap.put("CW", "Curacao");
    namesMap.put("CX", "Kisiwa cha Krismasi");
    namesMap.put("CZ", "Chechia");
    namesMap.put("DE", "Ujerumani");
    namesMap.put("DJ", "Jibuti");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Jamhuri ya Dominika");
    namesMap.put("DZ", "Aljeria");
    namesMap.put("EA", "Ceuta na Melilla");
    namesMap.put("EG", "Misri");
    namesMap.put("EH", "Sahara Magharibi");
    namesMap.put("ES", "Uhispania");
    namesMap.put("EU", "Umoja wa Ulaya");
    namesMap.put("FI", "Ufini");
    namesMap.put("FK", "Visiwa vya Falkland");
    namesMap.put("FO", "Visiwa vya Faroe");
    namesMap.put("FR", "Ufaransa");
    namesMap.put("GB", "Ufalme wa Muungano");
    namesMap.put("GE", "Jojia");
    namesMap.put("GF", "Guiana ya Ufaransa");
    namesMap.put("GN", "Gine");
    namesMap.put("GQ", "Guinea ya Ikweta");
    namesMap.put("GR", "Ugiriki");
    namesMap.put("GS", "Visiwa vya Georgia Kusini na Sandwich Kusini");
    namesMap.put("GW", "Ginebisau");
    namesMap.put("HM", "Kisiwa cha Heard na Visiwa vya McDonald");
    namesMap.put("HU", "Hungaria");
    namesMap.put("IC", "Visiwa vya Kanari");
    namesMap.put("IE", "Ayalandi");
    namesMap.put("IL", "Israeli");
    namesMap.put("IM", "Kisiwa cha Man");
    namesMap.put("IO", "Eneo la Uingereza katika Bahari Hindi");
    namesMap.put("IQ", "Iraki");
    namesMap.put("IS", "Aisilandi");
    namesMap.put("IT", "Italia");
    namesMap.put("JM", "Jamaika");
    namesMap.put("JP", "Japani");
    namesMap.put("KG", "Kirigizistani");
    namesMap.put("KH", "Kambodia");
    namesMap.put("KM", "Komoro");
    namesMap.put("KN", "St. Kitts na Nevis");
    namesMap.put("KP", "Korea Kaskazini");
    namesMap.put("KR", "Korea Kusini");
    namesMap.put("KY", "Visiwa vya Cayman");
    namesMap.put("KZ", "Kazakistani");
    namesMap.put("LS", "Lesoto");
    namesMap.put("MG", "Madagaska");
    namesMap.put("MH", "Visiwa vya Marshall");
    namesMap.put("MP", "Visiwa vya Mariana vya Kaskazini");
    namesMap.put("MR", "Moritania");
    namesMap.put("MU", "Morisi");
    namesMap.put("MX", "Meksiko");
    namesMap.put("MY", "Malesia");
    namesMap.put("MZ", "Msumbiji");
    namesMap.put("NF", "Kisiwa cha Norfolk");
    namesMap.put("NI", "Nikaragwa");
    namesMap.put("NL", "Uholanzi");
    namesMap.put("NZ", "Nyuzilandi");
    namesMap.put("PF", "Polynesia ya Ufaransa");
    namesMap.put("PH", "Ufilipino");
    namesMap.put("PK", "Pakistani");
    namesMap.put("PM", "Santapierre na Miquelon");
    namesMap.put("PN", "Visiwa vya Pitcairn");
    namesMap.put("PS", "Maeneo ya Palestina");
    namesMap.put("PT", "Ureno");
    namesMap.put("QO", "Oceania ya Nje");
    namesMap.put("RE", "Reunion");
    namesMap.put("RU", "Urusi");
    namesMap.put("SA", "Saudia");
    namesMap.put("SB", "Visiwa vya Solomon");
    namesMap.put("SC", "Ushelisheli");
    namesMap.put("SE", "Uswidi");
    namesMap.put("SJ", "Svalbard na Jan Mayen");
    namesMap.put("SL", "Siera Leoni");
    namesMap.put("SN", "Senegali");
    namesMap.put("SS", "Sudan Kusini");
    namesMap.put("ST", "São Tomé na Príncipe");
    namesMap.put("SZ", "Uswazi");
    namesMap.put("TC", "Visiwa vya Turks na Caicos");
    namesMap.put("TF", "Himaya za Kusini za Kifaranza");
    namesMap.put("TH", "Tailandi");
    namesMap.put("TJ", "Tajikistani");
    namesMap.put("TR", "Uturuki");
    namesMap.put("TT", "Trinidad na Tobago");
    namesMap.put("UM", "Visiwa Vidogo vya Nje vya Marekani");
    namesMap.put("UN", "Umoja wa Mataifa");
    namesMap.put("US", "Marekani");
    namesMap.put("UZ", "Uzibekistani");
    namesMap.put("VA", "Mji wa Vatican");
    namesMap.put("VC", "St. Vincent na Grenadines");
    namesMap.put("VG", "Visiwa vya Virgin, Uingereza");
    namesMap.put("VI", "Visiwa vya Virgin, Marekani");
    namesMap.put("WF", "Wallis na Futuna");
    namesMap.put("YE", "Yemeni");
    namesMap.put("ZA", "Afrika Kusini");
    namesMap.put("ZZ", "Eneo lisilojulikana");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Dunia",
        "002": "Afrika",
        "003": "Amerika Kaskazini",
        "005": "Amerika Kusini",
        "011": "Afrika ya Magharibi",
        "013": "Amerika ya Kati",
        "014": "Afrika ya Mashariki",
        "015": "Afrika ya Kaskazini",
        "017": "Afrika ya Kati",
        "018": "Afrika ya Kusini",
        "019": "Amerika",
        "021": "Amerika ya Kaskazini",
        "029": "Karibiani",
        "030": "Asia ya Mashariki",
        "034": "Asia ya Kusini",
        "035": "Asia ya Kusini Mashariki",
        "039": "Ulaya ya Kusini",
        "057": "Eneo la Mikronesia",
        "143": "Asia ya Kati",
        "145": "Asia ya Magharibi",
        "150": "Ulaya",
        "151": "Ulaya ya Mashariki",
        "154": "Ulaya ya Kaskazini",
        "155": "Ulaya ya Magharibi",
        "202": "Afrika Kusine mwa Jangwa la Sahara",
        "419": "Amerika ya Kilatini",
        "AC": "Kisiwa cha Ascension",
        "AE": "Falme za Kiarabu",
        "AG": "Antigua na Barbuda",
        "AQ": "Antaktiki",
        "AR": "Ajentina",
        "AS": "Samoa ya Marekani",
        "AX": "Visiwa vya Aland",
        "AZ": "Azerbaijani",
        "BA": "Bosnia na Hezegovina",
        "BB": "Babadosi",
        "BD": "Bangladeshi",
        "BE": "Ubelgiji",
        "BF": "Bukinafaso",
        "BH": "Bahareni",
        "BL": "St. Barthelemy",
        "BQ": "Uholanzi ya Karibiani",
        "BS": "Bahama",
        "BV": "Kisiwa cha Bouvet",
        "CA": "Kanada",
        "CC": "Visiwa vya Cocos (Keeling)",
        "CD": "Jamhuri ya Kidemokrasia ya Kongo",
        "CF": "Jamhuri ya Afrika ya Kati",
        "CG": "Kongo - Brazzaville",
        "CH": "Uswisi",
        "CI": "Cote d’Ivoire",
        "CK": "Visiwa vya Cook",
        "CM": "Kameruni",
        "CN": "Uchina",
        "CO": "Kolombia",
        "CP": "Kisiwa cha Clipperton",
        "CR": "Kostarika",
        "CW": "Curacao",
        "CX": "Kisiwa cha Krismasi",
        "CZ": "Chechia",
        "DE": "Ujerumani",
        "DJ": "Jibuti",
        "DM": "Dominika",
        "DO": "Jamhuri ya Dominika",
        "DZ": "Aljeria",
        "EA": "Ceuta na Melilla",
        "EG": "Misri",
        "EH": "Sahara Magharibi",
        "ES": "Uhispania",
        "EU": "Umoja wa Ulaya",
        "FI": "Ufini",
        "FK": "Visiwa vya Falkland",
        "FO": "Visiwa vya Faroe",
        "FR": "Ufaransa",
        "GB": "Ufalme wa Muungano",
        "GE": "Jojia",
        "GF": "Guiana ya Ufaransa",
        "GN": "Gine",
        "GQ": "Guinea ya Ikweta",
        "GR": "Ugiriki",
        "GS": "Visiwa vya Georgia Kusini na Sandwich Kusini",
        "GW": "Ginebisau",
        "HM": "Kisiwa cha Heard na Visiwa vya McDonald",
        "HU": "Hungaria",
        "IC": "Visiwa vya Kanari",
        "IE": "Ayalandi",
        "IL": "Israeli",
        "IM": "Kisiwa cha Man",
        "IO": "Eneo la Uingereza katika Bahari Hindi",
        "IQ": "Iraki",
        "IS": "Aisilandi",
        "IT": "Italia",
        "JM": "Jamaika",
        "JP": "Japani",
        "KG": "Kirigizistani",
        "KH": "Kambodia",
        "KM": "Komoro",
        "KN": "St. Kitts na Nevis",
        "KP": "Korea Kaskazini",
        "KR": "Korea Kusini",
        "KY": "Visiwa vya Cayman",
        "KZ": "Kazakistani",
        "LS": "Lesoto",
        "MG": "Madagaska",
        "MH": "Visiwa vya Marshall",
        "MP": "Visiwa vya Mariana vya Kaskazini",
        "MR": "Moritania",
        "MU": "Morisi",
        "MX": "Meksiko",
        "MY": "Malesia",
        "MZ": "Msumbiji",
        "NF": "Kisiwa cha Norfolk",
        "NI": "Nikaragwa",
        "NL": "Uholanzi",
        "NZ": "Nyuzilandi",
        "PF": "Polynesia ya Ufaransa",
        "PH": "Ufilipino",
        "PK": "Pakistani",
        "PM": "Santapierre na Miquelon",
        "PN": "Visiwa vya Pitcairn",
        "PS": "Maeneo ya Palestina",
        "PT": "Ureno",
        "QO": "Oceania ya Nje",
        "RE": "Reunion",
        "RU": "Urusi",
        "SA": "Saudia",
        "SB": "Visiwa vya Solomon",
        "SC": "Ushelisheli",
        "SE": "Uswidi",
        "SJ": "Svalbard na Jan Mayen",
        "SL": "Siera Leoni",
        "SN": "Senegali",
        "SS": "Sudan Kusini",
        "ST": "São Tomé na Príncipe",
        "SZ": "Uswazi",
        "TC": "Visiwa vya Turks na Caicos",
        "TF": "Himaya za Kusini za Kifaranza",
        "TH": "Tailandi",
        "TJ": "Tajikistani",
        "TR": "Uturuki",
        "TT": "Trinidad na Tobago",
        "UM": "Visiwa Vidogo vya Nje vya Marekani",
        "UN": "Umoja wa Mataifa",
        "US": "Marekani",
        "UZ": "Uzibekistani",
        "VA": "Mji wa Vatican",
        "VC": "St. Vincent na Grenadines",
        "VG": "Visiwa vya Virgin, Uingereza",
        "VI": "Visiwa vya Virgin, Marekani",
        "WF": "Wallis na Futuna",
        "YE": "Yemeni",
        "ZA": "Afrika Kusini",
        "ZZ": "Eneo lisilojulikana"
    };
  }-*/;
}
