/*-
 ***********************************************************************
 *
 * $Id: webjob.h,v 1.155 2012/01/07 07:56:14 mavrik Exp $
 *
 ***********************************************************************
 *
 * Copyright 2001-2012 The WebJob Project, All Rights Reserved.
 *
 ***********************************************************************
 */
#ifndef _WEBJOB_H_INCLUDED
#define _WEBJOB_H_INCLUDED

/*-
 ***********************************************************************
 *
 * Defines
 *
 ***********************************************************************
 */
#define PROGRAM_NAME "webjob"

#define FALSE 0
#define TRUE  1

#ifdef WIN32
#ifdef MINGW32
#define UNIX_EPOCH_IN_NT_TIME 0x019db1ded53e8000LL
#else
#define UNIX_EPOCH_IN_NT_TIME 0x019db1ded53e8000
#endif
#define N_100ns_UNITS_IN_1s        10000000
#define N_100ns_UNITS_IN_1us             10
#endif

#define MESSAGE_SIZE 1024

#define KEY_ClientId              "ClientId"
#define KEY_GetTimeLimit          "GetTimeLimit"
#define KEY_HashType              "HashType"
#define KEY_Import                "Import"
#define KEY_OverwriteExecutable   "OverwriteExecutable"
#define KEY_Priority              "Priority"
#define KEY_PutTimeLimit          "PutTimeLimit"
#define KEY_RunTimeLimit          "RunTimeLimit"
#define KEY_RunType               "RunType"
#define KEY_StrictControls        "StrictControls"
#define KEY_TempDirectory         "TempDirectory"
#ifdef UNIX
#define KEY_TimeoutSignal         "TimeoutSignal"
#endif
#define KEY_UrlAuthType           "UrlAuthType"
#define KEY_UrlDownloadLimit      "UrlDownloadLimit"
#define KEY_UrlGetUrl             "UrlGetUrl"
#define KEY_UrlPassword           "UrlPassword"
#define KEY_UrlPutUrl             "UrlPutUrl"
#define KEY_UrlUsername           "UrlUsername"
#define KEY_UrlGetProxyAuthType   "UrlGetProxyAuthType"
#define KEY_UrlGetProxyEnable     "UrlGetProxyEnable"
#define KEY_UrlGetProxyHost       "UrlGetProxyHost"
#define KEY_UrlGetProxyPassword   "UrlGetProxyPassword"
#define KEY_UrlGetProxyPort       "UrlGetProxyPort"
#define KEY_UrlGetProxyUsername   "UrlGetProxyUsername"
#define KEY_UrlPutProxyAuthType   "UrlPutProxyAuthType"
#define KEY_UrlPutProxyEnable     "UrlPutProxyEnable"
#define KEY_UrlPutProxyHost       "UrlPutProxyHost"
#define KEY_UrlPutProxyPassword   "UrlPutProxyPassword"
#define KEY_UrlPutProxyPort       "UrlPutProxyPort"
#define KEY_UrlPutProxyUsername   "UrlPutProxyUsername"
#define KEY_UnlinkExecutable      "UnlinkExecutable"
#define KEY_UnlinkOutput          "UnlinkOutput"
#define KEY_UploadOnGetFailure    "UploadOnGetFailure"
#ifdef USE_SSL
#define KEY_SslBundledCAsFile     "SslBundledCAsFile"
#define KEY_SslExpectedPeerCN     "SslExpectedPeerCN"
#define KEY_SslMaxChainLength     "SslMaxChainLength"
#define KEY_SslPassPhrase         "SslPassPhrase"
#define KEY_SslPrivateKeyFile     "SslPrivateKeyFile"
#define KEY_SslPublicCertFile     "SslPublicCertFile"
#define KEY_SslUseCertificate     "SslUseCertificate"
#define KEY_SslVerifyPeerCert     "SslVerifyPeerCert"
#endif
#define KEY_GetHookEnable         "GetHookEnable"
#define KEY_GetHookCommandLine    "GetHookCommandLine"
#define KEY_GetHookStatus         "GetHookStatus"
#define KEY_GetHookSuffix         "GetHookSuffix"
#ifdef USE_DSV
#define KEY_DsvCertificateTree    "DsvCertificateTree"
#define KEY_DsvVerifySignature    "DsvVerifySignature"
#endif

#define WEBJOB_RUNMODE 0x00000001
#define WEBJOB_GETMODE 0x00000002
#define WEBJOB_HASHSUM 0x00000004
#define WEBJOB_RUN_EMBEDDED 0x00000008

#define MODES_ClientId            ((WEBJOB_RUNMODE))
#define MODES_GetTimeLimit        ((WEBJOB_RUNMODE))
#define MODES_HashType            ((WEBJOB_RUNMODE))
#define MODES_Import              ((WEBJOB_RUNMODE) | (WEBJOB_GETMODE))
#define MODES_OverwriteExecutable ((WEBJOB_RUNMODE))
#define MODES_Priority            ((WEBJOB_RUNMODE))
#define MODES_PutTimeLimit        ((WEBJOB_RUNMODE))
#define MODES_RunTimeLimit        ((WEBJOB_RUNMODE))
#define MODES_RunType             ((WEBJOB_RUNMODE))
#define MODES_StrictControls      ((WEBJOB_RUNMODE) | (WEBJOB_GETMODE))
#define MODES_TempDirectory       ((WEBJOB_RUNMODE))
#ifdef UNIX
#define MODES_TimeoutSignal       ((WEBJOB_RUNMODE))
#endif
#define MODES_UrlAuthType         ((WEBJOB_RUNMODE) | (WEBJOB_GETMODE))
#define MODES_UrlDownloadLimit    ((WEBJOB_RUNMODE) | (WEBJOB_GETMODE))
#define MODES_UrlGetUrl           ((WEBJOB_RUNMODE))
#define MODES_UrlPassword         ((WEBJOB_RUNMODE) | (WEBJOB_GETMODE))
#define MODES_UrlPutUrl           ((WEBJOB_RUNMODE))
#define MODES_UrlUsername         ((WEBJOB_RUNMODE) | (WEBJOB_GETMODE))
#define MODES_UrlGetProxyAuthType ((WEBJOB_RUNMODE) | (WEBJOB_GETMODE))
#define MODES_UrlGetProxyEnable   ((WEBJOB_RUNMODE) | (WEBJOB_GETMODE))
#define MODES_UrlGetProxyHost     ((WEBJOB_RUNMODE) | (WEBJOB_GETMODE))
#define MODES_UrlGetProxyPassword ((WEBJOB_RUNMODE) | (WEBJOB_GETMODE))
#define MODES_UrlGetProxyPort     ((WEBJOB_RUNMODE) | (WEBJOB_GETMODE))
#define MODES_UrlGetProxyUsername ((WEBJOB_RUNMODE) | (WEBJOB_GETMODE))
#define MODES_UrlPutProxyAuthType ((WEBJOB_RUNMODE))
#define MODES_UrlPutProxyEnable   ((WEBJOB_RUNMODE))
#define MODES_UrlPutProxyHost     ((WEBJOB_RUNMODE))
#define MODES_UrlPutProxyPassword ((WEBJOB_RUNMODE))
#define MODES_UrlPutProxyPort     ((WEBJOB_RUNMODE))
#define MODES_UrlPutProxyUsername ((WEBJOB_RUNMODE))
#define MODES_UnlinkExecutable    ((WEBJOB_RUNMODE))
#define MODES_UnlinkOutput        ((WEBJOB_RUNMODE))
#define MODES_UploadOnGetFailure  ((WEBJOB_RUNMODE))
#ifdef USE_SSL
#define MODES_SslBundledCAsFile   ((WEBJOB_RUNMODE) | (WEBJOB_GETMODE))
#define MODES_SslExpectedPeerCN   ((WEBJOB_RUNMODE) | (WEBJOB_GETMODE))
#define MODES_SslMaxChainLength   ((WEBJOB_RUNMODE) | (WEBJOB_GETMODE))
#define MODES_SslPassPhrase       ((WEBJOB_RUNMODE) | (WEBJOB_GETMODE))
#define MODES_SslPrivateKeyFile   ((WEBJOB_RUNMODE) | (WEBJOB_GETMODE))
#define MODES_SslPublicCertFile   ((WEBJOB_RUNMODE) | (WEBJOB_GETMODE))
#define MODES_SslUseCertificate   ((WEBJOB_RUNMODE) | (WEBJOB_GETMODE))
#define MODES_SslVerifyPeerCert   ((WEBJOB_RUNMODE) | (WEBJOB_GETMODE))
#endif
#define MODES_GetHookEnable       ((WEBJOB_RUNMODE))
#define MODES_GetHookCommandLine  ((WEBJOB_RUNMODE))
#define MODES_GetHookStatus       ((WEBJOB_RUNMODE))
#define MODES_GetHookSuffix       ((WEBJOB_RUNMODE))
#ifdef USE_DSV
#define MODES_DsvCertificateTree  ((WEBJOB_RUNMODE))
#define MODES_DsvVerifySignature  ((WEBJOB_RUNMODE))
#endif

#define RUN_MODE_IS_SET(mask, mode) (((mask) & (mode)) == (mode))

#define WEBJOB_MAX_32BIT_NUMBER_LENGTH   11 /* 4294967295 */
#define WEBJOB_MAX_CLIENTID_LENGTH       64
#define WEBJOB_MAX_PRIORITY_LENGTH       64
#define WEBJOB_MAX_QUEUETAG_LENGTH       64
#define WEBJOB_MAX_PATHNAME_LENGTH      255
#define WEBJOB_MAX_HOSTNAME_LENGTH      256
#define WEBJOB_MAX_USERNAME_LENGTH       32
#define WEBJOB_MAX_PORT_LENGTH            6
#define WEBJOB_MAX_LINE_LENGTH         1024
#define WEBJOB_MAX_QUERY_LENGTH        1024
#define WEBJOB_MIN_TIME_LIMIT             0
#define WEBJOB_MAX_TIME_LIMIT      31536000 /* 86400 * 365 */
#define WEBJOB_MAX_CONTENT_LENGTH 100000000

#ifdef UNIX
#define WEBJOB_MIN_SIGNAL                 1
#ifdef NSIG
#define WEBJOB_MAX_SIGNAL         ((NSIG)-1)
#else
#define WEBJOB_MAX_SIGNAL                31
#endif
#endif

#ifdef USE_DSV
#ifdef WIN32
#define WEBJOB_DSV_CERT_DIRECTORY "C:\\WebJob\\etc\\dsv"
#else
#define WEBJOB_DSV_CERT_DIRECTORY "/usr/local/webjob/etc/dsv"
#endif
#endif

#ifdef WIN32
#define WEBJOB_MAX_PATH                  260
#define WEBJOB_SLASH                    "\\"
#define WEBJOB_SLASHCHAR                '\\'
#define WEBJOB_TEMP_DIRECTORY       "\\temp"
#else
#define WEBJOB_MAX_PATH                 4096
#define WEBJOB_SLASH                     "/"
#define WEBJOB_SLASHCHAR                 '/'
#define WEBJOB_TEMP_DIRECTORY         "/tmp"
#endif
#define WEBJOB_SEPARATOR_S               "="

#define WEBJOB_PASS_TOKEN            "%pass"
#define WEBJOB_USER_TOKEN            "%user"

#define WEBJOB_PROXY_PASS_TOKEN "%proxy_pass"
#define WEBJOB_PROXY_USER_TOKEN "%proxy_user"

#define WEBJOB_HASHTYPE_MD5            "MD5"
#define WEBJOB_HASHTYPE_SHA1          "SHA1"
#define WEBJOB_HASHTYPE_SHA256      "SHA256"
#define WEBJOB_HASHTYPE_SIZE             16

#define WEBJOB_NONCE_SIZE                 9

#ifdef WIN32
#ifndef IDLE_PRIORITY_CLASS
#define IDLE_PRIORITY_CLASS         0x00000040
#endif
#ifndef BELOW_NORMAL_PRIORITY_CLASS
#define BELOW_NORMAL_PRIORITY_CLASS 0x00004000
#endif
#ifndef NORMAL_PRIORITY_CLASS
#define NORMAL_PRIORITY_CLASS       0x00000020
#endif
#ifndef ABOVE_NORMAL_PRIORITY_CLASS
#define ABOVE_NORMAL_PRIORITY_CLASS 0x00008000
#endif
#ifndef HIGH_PRIORITY_CLASS
#define HIGH_PRIORITY_CLASS         0x00000080
#endif
#define WEBJOB_PRIORITY_LOW IDLE_PRIORITY_CLASS
#define WEBJOB_PRIORITY_BELOW_NORMAL BELOW_NORMAL_PRIORITY_CLASS
#define WEBJOB_PRIORITY_NORMAL NORMAL_PRIORITY_CLASS
#define WEBJOB_PRIORITY_ABOVE_NORMAL ABOVE_NORMAL_PRIORITY_CLASS
#define WEBJOB_PRIORITY_HIGH HIGH_PRIORITY_CLASS
#else
#define WEBJOB_PRIORITY_LOW              20
#define WEBJOB_PRIORITY_BELOW_NORMAL     10
#define WEBJOB_PRIORITY_NORMAL            0
#define WEBJOB_PRIORITY_ABOVE_NORMAL    -10
#define WEBJOB_PRIORITY_HIGH            -20
#endif

#define WEBJOB_RUNTYPE_LINKTEST   "linktest"
#define WEBJOB_RUNTYPE_SNAPSHOT   "snapshot"
#define WEBJOB_RUNTYPE_SIZE              16

#define WEBJOB_READER_HANDLE              0
#define WEBJOB_WRITER_HANDLE              1
#define WEBJOB_READ_SIZE             0x8000

#define WEBJOB_GET_STAGE                  1
#define WEBJOB_RUN_STAGE                  2
#define WEBJOB_PUT_STAGE                  3

#define WEBJOB_GET_FILE         "webjob.get"
#define WEBJOB_PUT_FILE         "webjob.put"

#define ER                               -1
#define ER_OK                             0
#define ER_BadHandle                      1
#define ER_BadValue                       2
#define ER_Bool                           3
#define ER_DuplicateControl               4
#define ER_HttpParseUrl                   5
#define ER_Jibberish                      6
#define ER_Length                         7
#define ER_MaxIndirection                 8
#define ER_PathLength                     9
#define ER_fgets                         10
#define ER_fopen                         11
#define ER_lstat                         12

#define XER_OK                            0
#define XER_Usage                         1
#define XER_Abort                         2
#define XER_BootStrap                     3
#define XER_ProcessArguments              4
#define XER_ReadProperties                5
#define XER_CheckDependencies             6
#define XER_Configure                     7
#define XER_GetStage                      8
#define XER_RunStage                      9
#define XER_PutStage                     10
#define XER_MultiStage                   11
#define XER_GetUrl                       12
#define XER_CloneProperties              13
#define XER_Cleanup                      20
#define XER_Cleanup_Configure  ((XER_Cleanup) + (XER_Configure))  /* 27 */
#define XER_Cleanup_GetStage   ((XER_Cleanup) + (XER_GetStage))   /* 28 */
#define XER_Cleanup_RunStage   ((XER_Cleanup) + (XER_RunStage))   /* 29 */
#define XER_Cleanup_PutStage   ((XER_Cleanup) + (XER_PutStage))   /* 30 */
#define XER_Cleanup_MultiStage ((XER_Cleanup) + (XER_MultiStage)) /* 31 */
#define XER_MaxExternalErrorCode        255

/*-
 ***********************************************************************
 *
 * Typedefs
 *
 ***********************************************************************
 */
typedef enum _WEBJOB_OPTION_IDS
{
  OPT_File,
  OPT_HashType,
  OPT_NoUpload,
  OPT_GetTimeLimit,
  OPT_PutTimeLimit,
  OPT_RunTimeLimit,
#ifdef UNIX
  OPT_TimeoutSignal,
#endif
} WEBJOB_OPTION_IDS;

typedef struct _CONTROLS_FOUND
{
  int                 ClientIdFound;
  int                 GetTimeLimitFound;
  int                 HashTypeFound;
  int                 OverwriteExecutableFound;
  int                 PriorityFound;
  int                 PutTimeLimitFound;
  int                 RunTimeLimitFound;
  int                 RunTypeFound;
  int                 TempDirectoryFound;
#ifdef UNIX
  int                 TimeoutSignalFound;
#endif
  int                 UrlAuthTypeFound;
  int                 UrlDownloadLimitFound;
  int                 UrlGetUrlFound;
  int                 UrlPasswordFound;
  int                 UrlPutUrlFound;
  int                 UrlUsernameFound;
  int                 UrlGetProxyAuthTypeFound;
  int                 UrlGetProxyEnableFound;
  int                 UrlGetProxyHostFound;
  int                 UrlGetProxyPasswordFound;
  int                 UrlGetProxyPortFound;
  int                 UrlGetProxyUsernameFound;
  int                 UrlPutProxyAuthTypeFound;
  int                 UrlPutProxyEnableFound;
  int                 UrlPutProxyHostFound;
  int                 UrlPutProxyPasswordFound;
  int                 UrlPutProxyPortFound;
  int                 UrlPutProxyUsernameFound;
  int                 UnlinkExecutableFound;
  int                 UnlinkOutputFound;
  int                 UploadOnGetFailureFound;
#ifdef USE_SSL
  int                 SslBundledCAsFileFound;
  int                 SslExpectedPeerCNFound;
  int                 SslMaxChainLengthFound;
  int                 SslPassPhraseFound;
  int                 SslPrivateKeyFileFound;
  int                 SslPublicCertFileFound;
  int                 SslUseCertificateFound;
  int                 SslVerifyPeerCertFound;
#endif
  int                 GetHookEnableFound;
  int                 GetHookCommandLineFound;
  int                 GetHookStatusFound;
  int                 GetHookSuffixFound;
#ifdef USE_DSV
  int                 DsvCertificateTreeFound;
  int                 DsvVerifySignatureFound;
#endif
} CONTROLS_FOUND;

typedef struct _WEBJOB {
  char               *pcCommand;
  char               *pcCommandLine;
  char               *pcEmbeddedCommand;
  char               *pcEmbeddedCommandLine;
  char              **ppcArguments;
  char              **ppcEmbeddedArguments;
  char                acKidReason[MESSAGE_SIZE];
  int                 iArgumentCount;
  int                 iEmbeddedArgumentCount;
  int                 iKidPid;
  int                 iKidSignal;
  int                 iKidStatus;
#ifdef UNIX
  int                 iPipe[2];
#endif
  FILE               *pStdEnv;
  FILE               *pStdErr;
  FILE               *pStdOut;
} WEBJOB;

typedef struct _WEBJOB_PROPERTIES
{
  char               *pcConfigFile;
  char               *pcConfigList;
  char               *pcHostname;
  char               *pcNonce;
  char               *pcPathToSelf;
  char               *pcUrl;
  char               *pcDoneDirectory;
  char               *pcTempDirectory;
  char               *pcWorkDirectory;
  char                acClientId[WEBJOB_MAX_CLIENTID_LENGTH];
  char                acJobId[HTTP_JOB_ID_SIZE];
  char                acPriority[WEBJOB_MAX_PRIORITY_LENGTH];
  char                acQueueTag[WEBJOB_MAX_QUEUETAG_LENGTH];
  char                acRunType[WEBJOB_RUNTYPE_SIZE];
  char                acStdEnvFile[WEBJOB_MAX_PATHNAME_LENGTH];
  char                acStdErrFile[WEBJOB_MAX_PATHNAME_LENGTH];
  char                acStdOutFile[WEBJOB_MAX_PATHNAME_LENGTH];
  char                acTempDirectory[WEBJOB_MAX_PATHNAME_LENGTH];
  char                acGetError[MESSAGE_SIZE];
  char                acRunError[MESSAGE_SIZE];
  char                acPutError[MESSAGE_SIZE];
  int                 iGetOk;
  int                 iPutOk;
  int                 iNoUpload;
  int                 iOverwriteExecutable;
  int                 iPriority;
  int                 iRunEmbedded;
  int                 iRunMode;
  int                 iRunStage;
  int                 iRunStageDisabled;
  int                 iStrictControls;
  int                 iUnlinkExecutable;
  int                 iUnlinkOutput;
  int                 iUploadOnGetFailure;
  int                 iWorkDirectoryCreated;

  char                acHashType[WEBJOB_HASHTYPE_SIZE];
  char               *pcHashType;
  unsigned char      *pcStdErrHash;
  unsigned char      *pcStdOutHash;
  int                 iHashSize;
  int               (*piHashStream)();
  APP_UI64            ui64StdErrSize;
  APP_UI64            ui64StdOutSize;

  int                 iGetTimeLimit;
  int                 iRunTimeLimit;
  int                 iPutTimeLimit;

  char                acUrlUsername[WEBJOB_MAX_USERNAME_LENGTH];
  char               *pcUrlPassword;
  int                 iUrlAuthType;
  int                 iUrlDownloadLimit;
  HTTP_URL           *psGetUrl;
  HTTP_URL           *psPutUrl;
  WEBJOB              sWEBJOB;
  CONTROLS_FOUND      sFound;
  int                 iImportRecursionLevel;

  struct timeval      tvJobEpoch;
  struct timeval      tvSRGEpoch;
  struct timeval      tvGetEpoch;
  struct timeval      tvRunEpoch;
  struct timeval      tvPutEpoch;

#ifdef UNIX
  int                 iTimeoutSignal;
  jmp_buf             sGetEnvironment;
  jmp_buf             sPutEnvironment;
#endif

#ifdef USE_SSL
  SSL_PROPERTIES     *psSslProperties;
#endif

  HOOK               *psGetHook;

#ifdef USE_DSV
  char                acDsvCertificateTree[WEBJOB_MAX_PATHNAME_LENGTH];
  DSV_CERT_NODE      *psDsvCertList;
  DSV_SIGNATURE      *psDsvGetSignature;
  DSV_SIGNATURE      *psDsvPutSignature;
  int                 iDsvGetStatus;
  int                 iDsvPutStatus;
  int                 iDsvVerifySignature;
#endif

  char                acUrlGetProxyHost[WEBJOB_MAX_HOSTNAME_LENGTH];
  char               *pcUrlGetProxyPassword;
  char                acUrlGetProxyPort[WEBJOB_MAX_PORT_LENGTH];
  char                acUrlGetProxyUsername[WEBJOB_MAX_USERNAME_LENGTH];
  int                 iUrlGetProxyAuthType;
  int                 iUrlGetProxyEnable;

  char                acUrlPutProxyHost[WEBJOB_MAX_HOSTNAME_LENGTH];
  char               *pcUrlPutProxyPassword;
  char                acUrlPutProxyPort[WEBJOB_MAX_PORT_LENGTH];
  char                acUrlPutProxyUsername[WEBJOB_MAX_USERNAME_LENGTH];
  int                 iUrlPutProxyAuthType;
  int                 iUrlPutProxyEnable;

#ifdef WIN32
  char                acCwd[WEBJOB_MAX_PATH + 1];
#else
  DIR                *psCwd;
#endif

  char               *pcGetFile;
  char               *pcPutFile;
  FILE               *pGetFile;
  FILE               *pPutFile;

  struct _WEBJOB_PROPERTIES *psNext;

} WEBJOB_PROPERTIES;

typedef struct _WEBJOB_THREAD
{
  WEBJOB_PROPERTIES  *psProperties;
  char               *pcError;
  int               (*piRoutine)();
} WEBJOB_THREAD;

typedef struct _WEBJOB_EXPORT_LIST
{
#define WEBJOB_EXPORT_NAME_SIZE 32
  char                acKey[WEBJOB_EXPORT_NAME_SIZE];
  char               *pcValue;
} WEBJOB_EXPORT_LIST;

/*-
 ***********************************************************************
 *
 * Macros
 *
 ***********************************************************************
 */
#define WEBJOB_SAFE_FCLOSE(pFile) \
  if (pFile != NULL) \
  { \
    fclose(pFile); \
  }

/*-
 ***********************************************************************
 *
 * Global Variables
 *
 ***********************************************************************
 */
extern WEBJOB_PROPERTIES Properties;

/*-
 ***********************************************************************
 *
 * Function Prototypes (webjob.c)
 *
 ***********************************************************************
 */
int                 WebJobBootStrap(int iArgumentCount, char *ppcArgumentVector[], char *pcError);
int                 WebJobCheckDependencies(WEBJOB_PROPERTIES *psProperties, char *pcError);
int                 WebJobCloneProperties(WEBJOB_PROPERTIES *psProperties, char *pcError);
int                 WebJobCloneSelf(char *pcPathToSelf, char *pcError);
int                 WebJobCopyFile(char *pcSourceFile, char *pcTargetFile, char *pcError);
char               *WebJobDecodeValue(char *pcEncoded, char *pcError);
int                 WebJobDoConfigure(WEBJOB_PROPERTIES *psProperties, char *pcError);
#if defined(USE_EMBEDDED_LUA) || defined(USE_EMBEDDED_PERL)
int                 WebJobDoConfigureEmbedded(WEBJOB_PROPERTIES *psProperties, char *pcError);
#endif
int                 WebJobDoGetHook(WEBJOB_PROPERTIES *psProperties, char *pcError);
int                 WebJobDoGetRequest(WEBJOB_PROPERTIES *psProperties, char *pcError);
int                 WebJobDoGetStage(WEBJOB_PROPERTIES *psProperties, char *pcError);
#ifdef UNIX
int                 WebJobDoKidStage(WEBJOB_PROPERTIES *psProperties, char *pcError);
#endif
#ifdef USE_EMBEDDED_LUA
void                WebJobRunLua(int iArgumentCount, char *ppcArgumentVector[]);
#endif
int                 WebJobDoPutRequest(WEBJOB_PROPERTIES *psProperties, char *pcError);
int                 WebJobDoPutStage(WEBJOB_PROPERTIES *psProperties, char *pcError);
int                 WebJobDoRunStage(WEBJOB_PROPERTIES *psProperties, char *pcError);
int                 WebJobExportEnvironment(WEBJOB_EXPORT_LIST *psKeyValuePairs, int iNKeyValuePairs, char *pcError);
char               *WebJobFormatTime(time_t time);
void                WebJobFreeProperties(WEBJOB_PROPERTIES *psProperties);
char               *WebJobGetEnvValue(char *pcName);
long                WebJobGetEpoch(struct timeval *tvEpoch);
FILE               *WebJobGetHandle(char *pcFilename, char *pcError);
char               *WebJobGetPathToSelf(char *pcArgumentZero, char *pcError);
WEBJOB_PROPERTIES  *WebJobGetPropertiesReference(void);
int                 WebJobGetUrl(WEBJOB_PROPERTIES *psProperties, char *pcError);
void                WebJobHashSum(char *pcFilename, char *pcHashType);
WEBJOB_PROPERTIES  *WebJobNewProperties(char *pcError);
int                 WebJobOptionHandler(OPTIONS_TABLE *psOption, char *pcValue, WEBJOB_PROPERTIES *psProperties, char *pcError);
int                 WebJobPrepareHandles(WEBJOB_PROPERTIES *psProperties, char *pcError);
int                 WebJobProcessArguments(WEBJOB_PROPERTIES *psProperties, int iArgumentCount, char *ppcArgumentVector[], char *pcError);
#ifdef USE_EMBEDDED_PERL
void                WebJobRunPerl(int iArgumentCount, char *ppcArgumentVector[]);
#endif
void                WebJobSetPropertiesReference(WEBJOB_PROPERTIES *psProperties);
int                 WebJobShutdown(WEBJOB_PROPERTIES *psProperties, int iLastError, int iErrorCount);
#ifdef WIN32
DWORD WINAPI        WebJobThreadWrapper(LPVOID lpArgument);
#endif
#ifdef UNIX
void                WebJobTimeoutHandler();
#endif
void                WebJobUsage(void);
#ifdef USE_DSV
int                 WebJobVerifySignature(WEBJOB_PROPERTIES *psProperties, HTTP_RESPONSE_HDR *psResponseHeader, char *pcError);
#endif
void                WebJobVersion(void);

char               *BuildCommandLine(int iArgumentCount, char *ppcArgumentVector[], int iQuoteArgument0);
#ifdef WIN32
void                FormatWin32Error(DWORD dwError, char **ppcMessage);
#endif
char               *GetHostname(void);
char               *GetSystemOS(void);
int                 HttpFinalizeCredentials(HTTP_URL *psUrl, char *pcUser, char *pcPass, char *pcError);
int                 HttpFinalizeProxyCredentials(HTTP_URL *psUrl, char *pcProxyUser, char *pcProxyPass, char *pcError);
char               *MakeNonce(char *pcError);
char               *MakeRandomExtension(void);
#ifdef USE_SSL
int                 SslCheckDependencies(SSL_PROPERTIES *psProperties, char *pcError);
#endif
int                 SeedRandom(unsigned long ulTime1, unsigned long ulTime2, char *pcError);

/*-
 ***********************************************************************
 *
 * Function Prototypes (properties.c)
 *
 ***********************************************************************
 */
int                 PropertiesReadFile(char *pcFilename, WEBJOB_PROPERTIES *psProperties, char *pcError);
int                 PropertiesReadLine(char *pcLine, WEBJOB_PROPERTIES *psProperties, char *pcError);

#endif /* !_WEBJOB_H_INCLUDED */
