/*-
 ***********************************************************************
 *
 * $Id: base64.c,v 1.5 2012/01/07 07:56:14 mavrik Exp $
 *
 ***********************************************************************
 *
 * Copyright 2006-2012 The WebJob Project, All Rights Reserved.
 *
 ***********************************************************************
 */
#include <stdio.h>

/*-
 ***********************************************************************
 *
 * Globals
 *
 ***********************************************************************
 */
static unsigned char  gaucBase64[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
static int            giFromBase64[256];

/*-
 ***********************************************************************
 *
 * Reference: http://www.ietf.org/rfc/rfc3548.txt
 *
 ***********************************************************************
 */

/*-
 ***********************************************************************
 *
 * Base64BootStrap
 *
 ***********************************************************************
 */
void
Base64BootStrap(void)
{
  int                 i = 0;

  for (i = 0; i < 256; i++)
  {
    giFromBase64[i] = -1;
  }

  for (i = 0; gaucBase64[i] != 0; i++)
  {
    giFromBase64[gaucBase64[i]] = i;
  }
}


/*-
 ***********************************************************************
 *
 * Base64Decode
 *
 ***********************************************************************
 */
int
Base64Decode(char *pcIData, unsigned char *pucOData, int iLength)
{
  int                 i = 0;
  int                 n = 0;
  int                 iNLeft = 0;
  unsigned int        uiBits = 0;

  if (pcIData == NULL || pucOData == NULL || iLength < 0)
  {
    return -1;
  }

  while (i < iLength && pcIData[i] != '=')
  {
    if (giFromBase64[(int) pcIData[i]] < 0)
    {
      return -1; /* Invalid input. */
    }
    uiBits = (uiBits << 6) | giFromBase64[(int) pcIData[i]];
    iNLeft += 6;
    while (iNLeft >= 8)
    {
      pucOData[n++] = (unsigned char) ((uiBits >> (iNLeft - 8)) & 0xff);
      iNLeft -= 8;
    }
    i++;
  }

  return n;
}

int
Base64Encode(unsigned char *pucIData, char *pcOData, int iLength)
{
  int                 i = 0;
  int                 n = 0;
  int                 iNLeft = 0;
  int                 iNFill = 0;
  unsigned int        uiBits = 0;

  if (pucIData == NULL || pcOData == NULL || iLength < 0)
  {
    return -1;
  }

  while (i < iLength)
  {
    uiBits = (uiBits << 8) | pucIData[i];
    iNLeft += 8;
    while (iNLeft > 6)
    {
      pcOData[n++] = gaucBase64[(uiBits >> (iNLeft - 6)) & 0x3f];
      iNLeft -= 6;
    }
    i++;
  }
  if (iNLeft != 0)
  {
    pcOData[n++] = gaucBase64[(uiBits << (6 - iNLeft)) & 0x3f];
  }
  iNFill = (iLength % 3) ? 3 - (iLength % 3) : 0;
  for (i = 0; i < iNFill; i++)
  {
    pcOData[n++] = '=';
  }
  pcOData[n] = 0;

  return n;
}
