/*-
 ***********************************************************************
 *
 * $Id: pad-common.h,v 1.16 2012/01/07 07:56:14 mavrik Exp $
 *
 ***********************************************************************
 *
 * Copyright 2002-2012 The WebJob Project, All Rights Reserved.
 *
 ***********************************************************************
 */
#ifndef _PAD_COMMON_H_INCLUDED
#define _PAD_COMMON_H_INCLUDED

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#ifdef WIN32
#include <fcntl.h>
#include <io.h>
#include <windows.h>
#else
#include <ctype.h>
#include <limits.h>
#include <unistd.h>
#endif

/*-
 ***********************************************************************
 *
 * Defines
 *
 ***********************************************************************
 */
#ifdef WIN32
#define snprintf                    _snprintf
#define stat _stat
#endif

#define DOT                                "."
#define DOTDOT                            ".."

#define ER                                 -1
#define ER_OK                               0

#define MESSAGE_SIZE                     1024

#define PAD_MUTE_OFF                        0
#define PAD_MUTE_ON                         1
#define PAD_OVERWRITE_OFF                   0
#define PAD_OVERWRITE_ON                    1
#define PAD_PAYLOAD_TOKEN           "%payload"
#define PAD_READ_SIZE                    8192
#define PAD_SUFFIX                      ".pad"
#define PAD_UMASK                         022

#define PAD_CALL_NAME_SIZE                 64
#define PAD_VOID_CALL            (void (*)())

#define PAD_GUTS_TEMPLATE "PAD GUTS DELIMITER"
#define PAD_MAKE_TEMPLATE "PAD MAKE DELIMITER"

/*-
 ***********************************************************************
 *
 * Typedefs
 *
 ***********************************************************************
 */
typedef struct _PAD_CALL_TABLE
{
  void              (*pvCall)();
  char                acName[PAD_CALL_NAME_SIZE];
} PAD_CALL_TABLE;

/*-
 ***********************************************************************
 *
 * Function Prototypes
 *
 ***********************************************************************
 */
char               *PaDGetBasename(char *pcPath);
char               *PaDGetCallname(void (*pvCall)());
char               *PaDGetEnvValue(char *pcName);
FILE               *PaDGetMyHandle(char *pcMyName, char *pcError);
void               *PaDGetPropertiesReference(void);
int                 PaDLocateDelimiter(FILE *pFile, char *pcDelimiter, char *pcError);
char               *PaDNewDelimiter(char *pcTemplate, int iConvert, char *pcError);
void               *PaDNewProperties(int iSize, char *pcError);
int                 PaDReadWrite(FILE *pFileFrom, FILE *pFileTo, char *pcError);
void                PaDSetPropertiesReference(void *psProperties);

#endif /* !_PAD_COMMON_H_INCLUDED */
