#!/usr/bin/perl -w
######################################################################
#
# $Id: WebJob-MldbmRoutines.t,v 1.6 2012/01/07 07:56:13 mavrik Exp $
#
######################################################################
#
# Copyright 2007-2012 The WebJob Project, All Rights Reserved.
#
######################################################################
#
# Purpose: Tests for WebJob::MldbmRoutines.
#
######################################################################

use 5.008;
use strict;
use Getopt::Std;
use Test;

BEGIN
{
  my %hPlan =
  (
    'tests' => 8,
  );
  plan(%hPlan);
};

######################################################################
#
# Tests
#
######################################################################

  ####################################################################
  #
  # Get Options.
  #
  ####################################################################

  my %hOptions;

  if (!getopts("b", \%hOptions))
  {
    ok(0);
  }
  ok(1);

  ####################################################################
  #
  # DoBlocking, '-b', is optional.
  #
  ####################################################################

  my $sDoBlocking = (exists($hOptions{'b'})) ? 1 : 0;

  ####################################################################
  #
  # Test: The target module must load without error.
  #
  ####################################################################

  use WebJob::MldbmRoutines;
  ok(1);

  ####################################################################
  #
  # Test: Create a DB.
  #
  ####################################################################

  my $sDbFile = "test.db";
  my $sDbLock = $sDbFile . ".lock";
  unlink($sDbFile);
  unlink($sDbLock);
  ok(MldbmCreateDb($sDbFile));

  ####################################################################
  #
  # Test: The context hash must be defined.
  #
  ####################################################################

  use Fcntl qw(:DEFAULT :flock);
  my $phDbContext = MldbmNewContext
  (
    {
      'DbFile'     => $sDbFile,
      'DbFlags'    => O_RDWR,
      'LockFlags'  => LOCK_EX,
      'LockMode'   => "+<",
    }
  );
  ok(defined($phDbContext));

  ####################################################################
  #
  # Test: Connect to and lock (exclusive access) the DB.
  #
  ####################################################################

  my $sLocalError;
  ok(MldbmConnect($phDbContext, \$sLocalError));

  ####################################################################
  #
  # Test: Add a client to the DB, and the hash must not be empty.
  #
  ####################################################################

  my $phDb = $$phDbContext{'DbHandle'};
  $$phDb{'client_test'} = undef;
  ok(scalar(keys(%$phDb)));

  ####################################################################
  #
  # Test: Disconnect from and unlock the DB.
  #
  ####################################################################

#NOTE: Turning this variable on should cause the next test to hang.
#      However, this is not true in Solaris. Apparantly because the
#      same file is being opened again, so Solaris resets the lock.
#      This is (may not be?) not true for NFS mounts either.
  if ($sDoBlocking)
  {
    ok(1);
  }
  else
  {
    ok(MldbmDisconnect($phDbContext, \$sLocalError));
  }

  ####################################################################
  #
  # Test: Delete a DB.
  #
  ####################################################################

  ok(MldbmDeleteDb($sDbFile));

