#!/usr/bin/perl -w
######################################################################
#
# $Id: WebJob-MiaRoutines.t,v 1.5 2012/01/07 07:56:13 mavrik Exp $
#
######################################################################
#
# Copyright 2007-2012 The WebJob Project, All Rights Reserved.
#
######################################################################
#
# Purpose: Tests for WebJob::MiaRoutines.
#
######################################################################

use 5.008;
use strict;
use Test;

BEGIN
{
  my %hPlan =
  (
    'tests' => 64,
  );
  plan(%hPlan);
};

######################################################################
#
# Tests
#
######################################################################

  ####################################################################
  #
  # Test: The target module must load without error.
  #
  ####################################################################

  use WebJob::MiaRoutines;
  ok(1);

  ####################################################################
  #
  # Test: Various inputs yield expected results.
  #
  ####################################################################

  my $sClient = "client_test";
  my $sCheckpoint = 946684800;
  my $sError;
  my @aTuples =
  (
# Limit is the limiting factor.
    "900:150:0:0",
    "900:150:1:0",
    "900:150:2:0",
    "900:150:899:0",
    "900:150:900:0",
    "900:150:901:0",
    "900:150:1049:0",
    "900:150:1050:0",
    "900:150:1051:1",
# Limit is the limiting factor.
    "3600:600:0:0",
    "3600:600:1:0",
    "3600:600:2:0",
    "3600:600:3599:0",
    "3600:600:3600:0",
    "3600:600:3601:0",
    "3600:600:4199:0",
    "3600:600:4200:0",
    "3600:600:4201:1",
# Limit is the limiting factor.
    "86400:600:0:0",
    "86400:600:1:0",
    "86400:600:2:0",
    "86400:600:86399:0",
    "86400:600:86400:0",
    "86400:600:86401:0",
    "86400:600:86999:0",
    "86400:600:87000:0",
    "86400:600:87001:1",
# Multiplier is the limiting factor.
    "900:900:0:0",
    "900:900:1:0",
    "900:900:2:0",
    "900:900:899:0",
    "900:900:900:0",
    "900:900:901:0",
    "900:900:1049:0",
    "900:900:1050:0",
    "900:900:1051:0",
    "900:900:1349:0",
    "900:900:1350:0",
    "900:900:1351:1",
# Multiplier is the limiting factor.
    "3600:3600:0:0",
    "3600:3600:1:0",
    "3600:3600:2:0",
    "3600:3600:3599:0",
    "3600:3600:3600:0",
    "3600:3600:3601:0",
    "3600:3600:4199:0",
    "3600:3600:4200:0",
    "3600:3600:4201:0",
    "3600:3600:5399:0",
    "3600:3600:5400:0",
    "3600:3600:5401:1",
# Multiplier is the limiting factor.
    "86400:86400:0:0",
    "86400:86400:1:0",
    "86400:86400:2:0",
    "86400:86400:86399:0",
    "86400:86400:86400:0",
    "86400:86400:86401:0",
    "86400:86400:86999:0",
    "86400:86400:87000:0",
    "86400:86400:87001:0",
    "86400:86400:129599:0",
    "86400:86400:129600:0",
    "86400:86400:129601:1",
  );

  foreach my $sTuple (@aTuples)
  {
    my ($sPeriod, $sLimit, $sDelta, $sExpectedResult) = split(/:/, $sTuple);
    my $phMiaContext = MiaNewContext
    (
      {
        'Checkpoint' => $sCheckpoint,
        'Client'     => $sClient,
        'Limit'      => $sLimit,
        'Period'     => $sPeriod,
        'Time'       => $sCheckpoint + $sDelta,
      }
    );
    ok((MiaComputeMiaStatus($phMiaContext, \$sError) && $$phMiaContext{'Mia'} == $sExpectedResult));
  }

