#!/usr/bin/perl -w
######################################################################
#
# $Id: WebJob-LogRoutines.t,v 1.6 2012/01/07 07:56:13 mavrik Exp $
#
######################################################################
#
# Copyright 2008-2012 The WebJob Project, All Rights Reserved.
#
######################################################################
#
# Purpose: Tests for WebJob::LogRoutines.
#
######################################################################

use 5.008;
use strict;
use Test;
use Digest::MD5;

BEGIN
{
  my %hPlan =
  (
    'tests' => 258 + 60,
  );
  plan(%hPlan);
};

######################################################################
#
# Tests
#
######################################################################

  ####################################################################
  #
  # Test: The target module must load without error.
  #
  ####################################################################

  use WebJob::LogRoutines;
  ok(1);

  ####################################################################
  #
  # Test: Generate a simple log message.
  #
  ####################################################################

  my $sLogFile = "log";

  my %hOptions =
  (
    'LogEpoch'       => 0,
    'LogFields'      => ["Field1", "Field2", "Message"],
    'LogFile'        => $sLogFile,
    'LogValues'      => {},
    'RevertToStderr' => 1,
    'UseGmt'         => 1,
  );

  foreach my $sField1 ("field_1", "field 1", "field\t1", "field\n1", "field\r1", "field+1", "field%1", undef)
  {
    $hOptions{'LogValues'}{'Field1'} = $sField1;
    foreach my $sField2 ("field_2", "field 2", "field\t2", "field\n2", "field\r2", "field+2", "field%2", undef)
    {
      $hOptions{'LogValues'}{'Field2'} = $sField2;
      foreach my $sMessage ("pass", "fail", "pass and/or fail", undef)
      {
        $hOptions{'LogValues'}{'Message'} = $sMessage;
        ok(LogNf1vMessage(\%hOptions));
        $hOptions{'LogEpoch'}++;
      }
    }
  }

  ####################################################################
  #
  # Test: Check the hash of the log file.
  #
  ####################################################################

  my $oMd5 = Digest::MD5->new;
  open(FH, "< $sLogFile");
  $oMd5->addfile(*FH);
  my $sMd5 = $oMd5->hexdigest;
  close(FH);
  ok($sMd5 eq "80530eeaaa145a13fff8cbb5a53f57c7");

  ####################################################################
  #
  # Test: Check various debug value/level combinations.
  #
  ####################################################################

  my @aTuples =
  (
    [ 0, 0, 0 ], # (Debug Value, Debug Level, Expected Result)
    [ 0, 1, 0 ],
    [ 0, 2, 0 ],
    [ 0, 3, 0 ],
    [ 0, 4, 0 ],
    [ 0, 5, 0 ],
    [ 0, 6, 0 ],
    [ 0, 7, 0 ],
    [ 0, 8, 0 ],
    [ 0, 9, 0 ],

    [ 1, 0, 1 ],
    [ 1, 1, 1 ],
    [ 1, 2, 0 ],
    [ 1, 3, 0 ],
    [ 1, 4, 0 ],
    [ 1, 5, 0 ],
    [ 1, 6, 0 ],
    [ 1, 7, 0 ],
    [ 1, 8, 0 ],
    [ 1, 9, 0 ],

    [ 2, 0, 1 ],
    [ 2, 1, 1 ],
    [ 2, 2, 1 ],
    [ 2, 3, 0 ],
    [ 2, 4, 0 ],
    [ 2, 5, 0 ],
    [ 2, 6, 0 ],
    [ 2, 7, 0 ],
    [ 2, 8, 0 ],
    [ 2, 9, 0 ],

    [ 3, 0, 1 ],
    [ 3, 1, 1 ],
    [ 3, 2, 1 ],
    [ 3, 3, 1 ],
    [ 3, 4, 0 ],
    [ 3, 5, 0 ],
    [ 3, 6, 0 ],
    [ 3, 7, 0 ],
    [ 3, 8, 0 ],
    [ 3, 9, 0 ],

    [ 9, 0, 1 ],
    [ 9, 1, 1 ],
    [ 9, 2, 1 ],
    [ 9, 3, 1 ],
    [ 9, 4, 1 ],
    [ 9, 5, 1 ],
    [ 9, 6, 1 ],
    [ 9, 7, 1 ],
    [ 9, 8, 1 ],
    [ 9, 9, 1 ],

    [ 10, 0, 1 ],
    [ 10, 1, 1 ],
    [ 10, 2, 1 ],
    [ 10, 3, 1 ],
    [ 10, 4, 1 ],
    [ 10, 5, 1 ],
    [ 10, 6, 1 ],
    [ 10, 7, 1 ],
    [ 10, 8, 1 ],
    [ 10, 9, 1 ],
  );

  foreach my $paTuple (@aTuples)
  {
    my $sResult = LogCheckDebugLevel({ 'Debug' => $$paTuple[0] }, $$paTuple[1]);
    ok($sResult == $$paTuple[2]);
  }

  ####################################################################
  #
  # Cleanup and go home.
  #
  ####################################################################

  unlink($sLogFile);

