#!/usr/bin/perl -w
######################################################################
#
# $Id: WebJob-FdaRoutines.t,v 1.7 2012/01/07 07:56:13 mavrik Exp $
#
######################################################################
#
# Copyright 2007-2012 The WebJob Project, All Rights Reserved.
#
######################################################################
#
# Purpose: Tests for WebJob::FdaRoutines.
#
######################################################################

use 5.008;
use strict;
use Test;

BEGIN
{
  my %hPlan =
  (
    'tests' => 11,
  );
  plan(%hPlan);
};

######################################################################
#
# Tests
#
######################################################################

  ####################################################################
  #
  # Test: The target module must load without error.
  #
  ####################################################################

  use WebJob::FdaRoutines;
  ok(1);

  ####################################################################
  #
  # Test: A numeric owner in should result in the same value out.
  #
  ####################################################################

  my $sUid = FdaOwnerToUid({ 'Owner' => 0 });
  ok(defined($sUid) && $sUid == 0);

  ####################################################################
  #
  # Test: A numeric group in should result in the same value out.
  #
  ####################################################################

  my $sGid = FdaGroupToGid({ 'Group' => 1 });
  ok(defined($sGid) && $sGid == 1);

  ####################################################################
  #
  # Test: Convert string-based permissions to an octal mode.
  #
  ####################################################################

  my $sMode = FdaPermissionsToMode({ 'Permissions' => "0755", 'Umask' => 0 });
  ok(defined($sMode) && $sMode == 0755);

  ####################################################################
  #
  # Test: Create a directory.
  #
  ####################################################################

  $sMode = 0755;
  $sGid = $(; $sGid =~ s/^(\d+).*$/$1/;
  $sUid = $<; $sUid =~ s/^(\d+).*$/$1/;

  my $paaPdmugs = # Prefix, Directory, Mode, UID, GID
  [
    [
      ".",
      "d",
      $sMode,
      $sUid,
      $sGid,
    ],
    [
      "d",
      "d1",
      $sMode,
      $sUid,
      $sGid,
    ],
    [
      "d",
      "d2",
      $sMode,
      $sUid,
      $sGid,
    ],
    [
      "d",
      "d3",
      $sMode,
      $sUid,
      $sGid,
    ],
  ];

  foreach my $paPdmug (@{$paaPdmugs})
  {
    my %hPdmugOptions =
    (
      'Prefix'    => $$paPdmug[0],
      'Directory' => $$paPdmug[1],
      'Mode'      => $$paPdmug[2],
      'Uid'       => $$paPdmug[3],
      'Gid'       => $$paPdmug[4],
      'BeQuiet'   => 1,
    );
    ok(FdaCreateDirectory(\%hPdmugOptions));
  }

  rmdir("d/d1");
  rmdir("d/d2");
  rmdir("d/d3");
  rmdir("d");

  ####################################################################
  #
  # Test: Create a file.
  #
  ####################################################################

  $sMode = 0644;

  my $paaPfmugs = # Prefix, Directory, Mode, UID, GID
  [
    [ undef, "f1", 0444, $sUid, $sGid, ],
    [ ".",   "f2", 0644, $sUid, $sGid, ],
    [ "./",  "f3", 0664, $sUid, $sGid, ],
  ];

  foreach my $paPfmug (@{$paaPfmugs})
  {
    my %hPfmugOptions =
    (
      'Prefix'    => $$paPfmug[0],
      'File'      => $$paPfmug[1],
      'Mode'      => $$paPfmug[2],
      'Uid'       => $$paPfmug[3],
      'Gid'       => $$paPfmug[4],
      'BeQuiet'   => 1,
    );
    ok(FdaCreateFile(\%hPfmugOptions));
  }

  unlink("f1");
  unlink("f2");
  unlink("f3");

