/*-
 ***********************************************************************
 *
 * $Id: webjob.h,v 1.27 2004/03/20 04:25:49 mavrik Exp $
 *
 ***********************************************************************
 *
 * Copyright 2001-2004 Klayton Monroe, All Rights Reserved.
 *
 ***********************************************************************
 */

/*-
 ***********************************************************************
 *
 * Defines
 *
 ***********************************************************************
 */
#define PROGRAM_NAME "webjob"
#define VERSION "1.4.0"

#define FALSE 0
#define TRUE  1

#define UNIX_EPOCH_IN_NT_TIME 0x019db1ded53e8000
#define N_100ns_UNITS_IN_1s        10000000
#define N_100ns_UNITS_IN_1us             10

#define MESSAGE_SIZE 1024

#define KEY_ClientId              "ClientId"
#define KEY_GetTimeLimit          "GetTimeLimit"
#define KEY_HashType              "HashType"
#define KEY_Import                "Import"
#define KEY_OverwriteExecutable   "OverwriteExecutable"
#define KEY_PutTimeLimit          "PutTimeLimit"
#define KEY_RunTimeLimit          "RunTimeLimit"
#define KEY_RunType               "RunType"
#define KEY_TempDirectory         "TempDirectory"
#define KEY_URLAuthType           "URLAuthType"
#define KEY_URLGetURL             "URLGetURL"
#define KEY_URLDownloadLimit      "URLDownloadLimit"
#define KEY_URLPassword           "URLPassword"
#define KEY_URLPutURL             "URLPutURL"
#define KEY_URLUsername           "URLUsername"
#define KEY_UnlinkExecutable      "UnlinkExecutable"
#define KEY_UnlinkOutput          "UnlinkOutput"
#ifdef USE_SSL
#define KEY_SSLBundledCAsFile     "SSLBundledCAsFile"
#define KEY_SSLExpectedPeerCN     "SSLExpectedPeerCN"
#define KEY_SSLMaxChainLength     "SSLMaxChainLength"
#define KEY_SSLPassPhrase         "SSLPassPhrase"
#define KEY_SSLPrivateKeyFile     "SSLPrivateKeyFile"
#define KEY_SSLPublicCertFile     "SSLPublicCertFile"
#define KEY_SSLUseCertificate     "SSLUseCertificate"
#define KEY_SSLVerifyPeerCert     "SSLVerifyPeerCert"
#endif
#define KEY_GetHookEnable         "GetHookEnable"
#define KEY_GetHookCommandLine    "GetHookCommandLine"
#define KEY_GetHookStatus         "GetHookStatus"
#define KEY_GetHookSuffix         "GetHookSuffix"

#define WEBJOB_RUNMODE 0x00000001

#define MODES_ClientId            ((WEBJOB_RUNMODE))
#define MODES_GetTimeLimit        ((WEBJOB_RUNMODE))
#define MODES_HashType            ((WEBJOB_RUNMODE))
#define MODES_Import              ((WEBJOB_RUNMODE))
#define MODES_OverwriteExecutable ((WEBJOB_RUNMODE))
#define MODES_PutTimeLimit        ((WEBJOB_RUNMODE))
#define MODES_RunTimeLimit        ((WEBJOB_RUNMODE))
#define MODES_RunType             ((WEBJOB_RUNMODE))
#define MODES_TempDirectory       ((WEBJOB_RUNMODE))
#define MODES_URLAuthType         ((WEBJOB_RUNMODE))
#define MODES_URLGetURL           ((WEBJOB_RUNMODE))
#define MODES_URLDownloadLimit    ((WEBJOB_RUNMODE))
#define MODES_URLPassword         ((WEBJOB_RUNMODE))
#define MODES_URLPutURL           ((WEBJOB_RUNMODE))
#define MODES_URLUsername         ((WEBJOB_RUNMODE))
#define MODES_UnlinkExecutable    ((WEBJOB_RUNMODE))
#define MODES_UnlinkOutput        ((WEBJOB_RUNMODE))
#ifdef USE_SSL
#define MODES_SSLBundledCAsFile   ((WEBJOB_RUNMODE))
#define MODES_SSLExpectedPeerCN   ((WEBJOB_RUNMODE))
#define MODES_SSLMaxChainLength   ((WEBJOB_RUNMODE))
#define MODES_SSLPassPhrase       ((WEBJOB_RUNMODE))
#define MODES_SSLPrivateKeyFile   ((WEBJOB_RUNMODE))
#define MODES_SSLPublicCertFile   ((WEBJOB_RUNMODE))
#define MODES_SSLUseCertificate   ((WEBJOB_RUNMODE))
#define MODES_SSLVerifyPeerCert   ((WEBJOB_RUNMODE))
#endif
#define MODES_GetHookEnable       ((WEBJOB_RUNMODE))
#define MODES_GetHookCommandLine  ((WEBJOB_RUNMODE))
#define MODES_GetHookStatus       ((WEBJOB_RUNMODE))
#define MODES_GetHookSuffix       ((WEBJOB_RUNMODE))

#define RUN_MODE_IS_SET(mask, mode) (((mask) & (mode)) == (mode))

#define WEBJOB_MAX_CLIENTID_LENGTH       64
#define WEBJOB_MAX_PATHNAME_LENGTH      255
#define WEBJOB_MAX_HOSTNAME_LENGTH      256
#define WEBJOB_MAX_USERNAME_LENGTH       32
#define WEBJOB_MAX_PASSWORD_LENGTH       32
#define WEBJOB_MAX_LINE_LENGTH         1024
#define WEBJOB_MAX_QUERY_LENGTH        1024
#define WEBJOB_MIN_TIME_LIMIT             0
#define WEBJOB_MAX_TIME_LIMIT         86400
#define WEBJOB_MAX_CONTENT_LENGTH 100000000

#ifdef WIN32
#define WEBJOB_TEMP_DIRECTORY       "\\temp"
#else
#define WEBJOB_TEMP_DIRECTORY         "/tmp"
#endif
#define WEBJOB_SEPARATOR_S               "="

#define WEBJOB_USER_TOKEN            "%user"
#define WEBJOB_PASS_TOKEN            "%pass"

#define WEBJOB_HASHTYPE_MD5            "MD5"
#define WEBJOB_HASHTYPE_SHA1          "SHA1"
#define WEBJOB_HASHTYPE_SIZE             16

#define WEBJOB_RUNTYPE_LINKTEST   "linktest"
#define WEBJOB_RUNTYPE_SNAPSHOT   "snapshot"
#define WEBJOB_RUNTYPE_SIZE              16

#define WEBJOB_READER_HANDLE              0
#define WEBJOB_WRITER_HANDLE              1
#define WEBJOB_READ_SIZE             0x8000

#define WEBJOB_GET_STAGE                  1
#define WEBJOB_RUN_STAGE                  2
#define WEBJOB_PUT_STAGE                  3

#define ER                               -1
#define ER_OK                             0
#define ER_BadHandle                      1
#define ER_BadValue                       2
#define ER_Bool                           3
#define ER_DuplicateControl               4
#define ER_HTTPParseURL                   5
#define ER_Jibberish                      6
#define ER_Length                         7
#define ER_MaxIndirection                 8
#define ER_PathLength                     9
#define ER_fgets                         10
#define ER_fopen                         11
#define ER_lstat                         12

#define XER_OK                            0
#define XER_Abort                         1
#define XER_Usage                         2
#define XER_BootStrap                     3
#define XER_ProcessArguments              4
#define XER_ReadProperties                5
#define XER_CheckDependencies             6
#define XER_Configure                     7
#define XER_GetStage                      8
#define XER_RunStage                      9
#define XER_PutStage                     10
#define XER_MultiStage                   11
#define XER_MaxExternalErrorCode        255

/*-
 ***********************************************************************
 *
 * Typedefs
 *
 ***********************************************************************
 */
typedef struct _CONTROLS_FOUND
{
  int                 ClientIdFound;
  int                 GetTimeLimitFound;
  int                 HashTypeFound;
  int                 OverwriteExecutableFound;
  int                 PutTimeLimitFound;
  int                 RunTimeLimitFound;
  int                 RunTypeFound;
  int                 TempDirectoryFound;
  int                 URLAuthTypeFound;
  int                 URLGetURLFound;
  int                 URLDownloadLimitFound;
  int                 URLPasswordFound;
  int                 URLPutURLFound;
  int                 URLUsernameFound;
  int                 UnlinkExecutableFound;
  int                 UnlinkOutputFound;
#ifdef USE_SSL
  int                 SSLBundledCAsFileFound;
  int                 SSLExpectedPeerCNFound;
  int                 SSLMaxChainLengthFound;
  int                 SSLPassPhraseFound;
  int                 SSLPrivateKeyFileFound;
  int                 SSLPublicCertFileFound;
  int                 SSLUseCertificateFound;
  int                 SSLVerifyPeerCertFound;
#endif
  int                 GetHookEnableFound;
  int                 GetHookCommandLineFound;
  int                 GetHookStatusFound;
  int                 GetHookSuffixFound;
} CONTROLS_FOUND;

typedef struct _WEBJOB {
  char               *pcCommand;
  char               *pcCommandLine;
  char               *pcRequest;
  char              **ppcArguments;
  char                acKidReason[MESSAGE_SIZE];
  int                 iArgumentCount;
  int                 iKidPid;
  int                 iKidSignal;
  int                 iKidStatus;
#ifdef UNIX
  int                 iPipe[2];
#endif
  FILE               *pRequestFile;
  FILE               *pStdEnv;
  FILE               *pStdErr;
  FILE               *pStdOut;
} WEBJOB;

typedef struct _WEBJOB_PROPERTIES
{
  char               *pcConfigFile;
  char                acClientId[WEBJOB_MAX_CLIENTID_LENGTH];
  char                acJobId[HTTP_JOB_ID_SIZE];
  char                acRunType[WEBJOB_RUNTYPE_SIZE];
  char                acStdEnvFile[WEBJOB_MAX_PATHNAME_LENGTH];
  char                acStdErrFile[WEBJOB_MAX_PATHNAME_LENGTH];
  char                acStdOutFile[WEBJOB_MAX_PATHNAME_LENGTH];
  char                acTempDirectory[WEBJOB_MAX_PATHNAME_LENGTH];
  char                acGetError[MESSAGE_SIZE];
  char                acRunError[MESSAGE_SIZE];
  char                acPutError[MESSAGE_SIZE];
  int                 iOverwriteExecutable;
  int                 iRunMode;
  int                 iRunStage;
  int                 iRunStageDisabled;
  int                 iUnlinkExecutable;
  int                 iUnlinkOutput;

  char                acHashType[WEBJOB_HASHTYPE_SIZE];
  unsigned char      *pcStdErrHash;
  unsigned char      *pcStdOutHash;
  int                 iHashSize;
  int               (*piHashStream)();

  int                 iGetTimeLimit;
  int                 iRunTimeLimit;
  int                 iPutTimeLimit;

  char                acURLUsername[WEBJOB_MAX_USERNAME_LENGTH];
  char                acURLPassword[WEBJOB_MAX_PASSWORD_LENGTH];
  int                 iURLAuthType;
  int                 iURLDownloadLimit;
  HTTP_URL           *psGetURL;
  HTTP_URL           *psPutURL;
  WEBJOB              sWEBJOB;
  CONTROLS_FOUND      sFound;
  int                 iImportRecursionLevel;

  struct timeval      tvJobEpoch;
  struct timeval      tvSRGEpoch;
  struct timeval      tvGetEpoch;
  struct timeval      tvRunEpoch;
  struct timeval      tvPutEpoch;

#ifdef UNIX
  jmp_buf             sGetEnvironment;
  jmp_buf             sPutEnvironment;
#endif

#ifdef USE_SSL
  SSL_PROPERTIES     *psSSLProperties;
#endif

  HOOK               *psGetHook;

} WEBJOB_PROPERTIES;

typedef struct _WEBJOB_THREAD
{
  WEBJOB_PROPERTIES  *psProperties;
  char               *pcError;
  int               (*piRoutine)();
} WEBJOB_THREAD;

/*-
 ***********************************************************************
 *
 * Macros
 *
 ***********************************************************************
 */

#define WEBJOB_SAFE_FCLOSE(pFile) \
  if (pFile != NULL) \
  { \
    fclose(pFile); \
  }

/*-
 ***********************************************************************
 *
 * Global Variables
 *
 ***********************************************************************
 */
extern WEBJOB_PROPERTIES Properties;

/*-
 ***********************************************************************
 *
 * Function Prototypes (webjob.c)
 *
 ***********************************************************************
 */
int                 WebJobBootStrap(char *pcError);
int                 WebJobCheckDependencies(WEBJOB_PROPERTIES *psProperties, char *pcError);
int                 WebJobDoConfigure(WEBJOB_PROPERTIES *psProperties, char *pcError);
int                 WebJobDoGetHook(WEBJOB_PROPERTIES *psProperties, char *pcError);
int                 WebJobDoGetRequest(WEBJOB_PROPERTIES *psProperties, char *pcError);
int                 WebJobDoGetStage(WEBJOB_PROPERTIES *psProperties, char *pcError);
#ifdef UNIX
int                 WebJobDoKidStage(WEBJOB_PROPERTIES *psProperties, char *pcError);
#endif
int                 WebJobDoPutRequest(WEBJOB_PROPERTIES *psProperties, char *pcError);
int                 WebJobDoPutStage(WEBJOB_PROPERTIES *psProperties, char *pcError);
int                 WebJobDoRunStage(WEBJOB_PROPERTIES *psProperties, char *pcError);
char               *WebJobFormatTime(time_t time);
void                WebJobFreeProperties(WEBJOB_PROPERTIES *psProperties);
long                WebJobGetEpoch(struct timeval *tvEpoch);
FILE               *WebJobGetHandle(char *pcFilename, char *pcError);
WEBJOB_PROPERTIES  *WebJobGetPropertiesReference(void);
void                WebJobHashSum(char *pcFilename, char *pcHashType);
WEBJOB_PROPERTIES  *WebJobNewProperties(char *pcError);
int                 WebJobPrepareHandles(WEBJOB_PROPERTIES *psProperties, char *pcError);
int                 WebJobProcessArguments(WEBJOB_PROPERTIES *psProperties, int iArgumentCount, char *ppcArgumentVector[]);
void                WebJobSetPropertiesReference(WEBJOB_PROPERTIES *psProperties);
int                 WebJobShutdown(WEBJOB_PROPERTIES *psProperties, int iLastError, int iErrorCount);
#ifdef WIN32
DWORD WINAPI        WebJobThreadWrapper(LPVOID lpArgument);
#endif
#ifdef UNIX
void                WebJobTimeoutHandler();
#endif
void                WebJobUsage(void);
void                WebJobVersion(void);

char               *BuildCommandLine(int iArgumentCount, char *ppcArgumentVector[]);
#ifdef WIN32
void                FormatWin32Error(DWORD dwError, char **ppcMessage);
#endif
char               *GetHostname(void);
char               *GetMyVersion(void);
char               *GetSystemOS(void);
int                 HTTPFinalizeCredentials(HTTP_URL *psURL, char *pcUser, char *pcPass, char *pcError);
char               *MakeRandomExtension(void);
#ifdef USE_SSL
int                 SSLCheckDependencies(SSL_PROPERTIES *psProperties, char *pcError);
#endif
int                 SeedRandom(unsigned long ulTime1, unsigned long ulTime2, char *pcError);

/*-
 ***********************************************************************
 *
 * Function Prototypes (properties.c)
 *
 ***********************************************************************
 */
int                 PropertiesReadFile(char *pcFilename, WEBJOB_PROPERTIES *psProperties, char *pcError);
int                 PropertiesReadLine(char *pcLine, WEBJOB_PROPERTIES *psProperties, char *pcError);
