/*-
 ***********************************************************************
 *
 * $Id: pad-common.h,v 1.3 2004/03/13 17:26:28 mavrik Exp $
 *
 ***********************************************************************
 *
 * Copyright 2002-2004 The WebJob Project, All Rights Reserved.
 *
 ***********************************************************************
 */
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef WIN32
#include <fcntl.h>
#include <io.h>
#include <windows.h>
#else
#include <unistd.h>
#include <sys/stat.h>
#endif

/*-
 ***********************************************************************
 *
 * Defines
 *
 ***********************************************************************
 */
#ifdef WIN32
#define snprintf                    _snprintf
#endif

#define DOT                                "."
#define DOTDOT                            ".."

#define ER                                 -1
#define ER_OK                               0

#define MESSAGE_SIZE                     1024

#define PAD_MUTE                            0
#define PAD_PAYLOAD_TOKEN           "%payload"
#define PAD_READ_SIZE                    8192
#define PAD_SUFFIX                      ".pad"

#define PAD_CALL_NAME_SIZE                 64
#define PAD_VOID_CALL            (void (*)())

#define PAD_GUTS_TEMPLATE "PAD GUTS DELIMITER"
#define PAD_MAKE_TEMPLATE "PAD MAKE DELIMITER"

/*-
 ***********************************************************************
 *
 * Typedefs
 *
 ***********************************************************************
 */
typedef struct _PAD_CALL_TABLE
{
  void              (*pvCall)();
  char                acName[PAD_CALL_NAME_SIZE];
} PAD_CALL_TABLE;

/*-
 ***********************************************************************
 *
 * Function Prototypes
 *
 ***********************************************************************
 */
char               *PaDGetBasename(char *pcPath);
char               *PaDGetCallname(void (*pvCall)());
FILE               *PaDGetMyHandle(char *pcMyName, char *pcError);
void               *PaDGetPropertiesReference(void);
int                 PaDLocateDelimiter(FILE *pFile, char *pcDelimiter, char *pcError);
char               *PaDNewDelimiter(char *pcTemplate, int iConvert, char *pcError);
void               *PaDNewProperties(int iSize, char *pcError);
int                 PaDReadWrite(FILE *pFileFrom, FILE *pFileTo, char *pcError);
void                PaDSetPropertiesReference(void *psProperties);
