/*-
 ***********************************************************************
 *
 * $Id: pad-binary-guts.h,v 1.2 2004/03/13 17:26:28 mavrik Exp $
 *
 ***********************************************************************
 *
 * Copyright 2002-2004 The WebJob Project, All Rights Reserved.
 *
 ***********************************************************************
 */

/*-
 ***********************************************************************
 *
 * Defines
 *
 ***********************************************************************
 */
#define XER                 -1
#define XER_OK               0
#define XER_BootStrap        1
#define XER_ProcessArguments 2
#define XER_Suffix           3
#define XER_Basename         4
#define XER_Delimiter        5
#define XER_Extract          6
#define XER_Deliver          7

/*-
 ***********************************************************************
 *
 * Typedefs
 *
 ***********************************************************************
 */
typedef struct _PAD_GUTS_PROPERTIES
{
  char               *pcCmdLine;
  char               *pcDelimiter;
  char               *pcPayload;
  FILE               *pFilePaD;
  FILE               *pFilePayload;
  int                 iUnlinkPayload;
} PAD_GUTS_PROPERTIES;

/*-
 ***********************************************************************
 *
 * Function Prototypes (pad-program.c)
 *
 ***********************************************************************
 */
int                 main(int iArgumentCount, char *ppcArgumentVector[]);
int                 PaDBootStrap(char *pcError);
int                 PaDBuildCmdLine(int iArgumentCount, char *ppcArgumentVector[], char *pcPayload, char *pcCmdLine);
int                 PaDCalculateCmdLineLength(int iArgumentCount, char *ppcArgumentVector[]);
int                 PaDCheckBasename(char *pcPath, char *pcError);
int                 PaDCheckSuffix(char *pcName, char *pcSuffix, char *pcError);
int                 PaDDeliverPayload(char *pcPayload, int iNeedXBit, char *pcCmdLine, char *pcError);
int                 PaDExtractPayload(PAD_GUTS_PROPERTIES *psProperties, char *pcError);
int                 PaDProcessArguments(int iArgumentCount, char *ppcArgumentVector[], PAD_GUTS_PROPERTIES *psProperties, char *pcError);
void                PaDShutdown(int iError);
