########################################################################
#
# $Id: Makefile.vs,v 1.11 2004/03/01 23:31:22 mavrik Exp $
#
########################################################################
#
# Copyright 2000-2004 Klayton Monroe, All Rights Reserved.
#
########################################################################
#
# Purpose: Makefile for Visual Studio.
#
########################################################################

BUILD_TYPE		= RELEASE	# [RELEASE|DEBUG]
USE_CGI			= N		# [Y|N]
USE_SSL			= Y		# [Y|N]
USE_STATIC_SSL_LIBS	= N		# [Y|N]

INSTALL_DIR		= C:\Integrity
SOURCE_DIR		= src
OBJECT_DIR		= build

!IF "$(USE_SSL)" == "Y" || "$(USE_SSL)" == "y"
SSL_DIR			= C:\OpenSSL
SSL_LIB_DIR		= $(SSL_DIR)\lib
SSL_INC_DIR		= $(SSL_DIR)\include
SSL_DLL1		= $(SSL_DIR)\bin\libeay32.dll
SSL_DLL2		= $(SSL_DIR)\bin\ssleay32.dll
SSL_COMPILER_FLAGS	= /D USE_SSL /I"$(SSL_INC_DIR)"
!IF "$(USE_STATIC_SSL_LIBS)" == "Y" || "$(USE_STATIC_SSL_LIBS)" == "y"
SSL_LINKER_FLAGS	= /libpath:"$(SSL_LIB_DIR)" libeay32.lib ssleay32.lib gdi32.lib
!ELSE
SSL_LINKER_FLAGS	= /libpath:"$(SSL_LIB_DIR)" libeay32.lib ssleay32.lib
!ENDIF
!ENDIF

COMPILER		= cl.exe

COMPILER_FLAGS		=\
			/nologo\
			/D _MBCS\
			/D _CONSOLE\
			/D WIN32\
			$(SSL_COMPILER_FLAGS)\
			/Fo"$(OBJECT_DIR)\\"\
			/Fd"$(OBJECT_DIR)\\"\
			/Fp"$(OBJECT_DIR)\webjob.pch"\
			/c /W3 /GX /YX /FD\
!IF "$(BUILD_TYPE)" == "DEBUG" || "$(BUILD_TYPE)" == "debug"
			/D _DEBUG\
			/MTd /Od /Zi /Gm
!ELSE
			/D NDEBUG\
			/MT /O2
!ENDIF

INCLUDES		=\
			src\all-includes.h\
			src\app-includes.h\
			src\hook.h\
			src\http.h\
			src\ktypes.h\
			src\md5.h\
			src\sha1.h\
			src\socket.h\
			src\ssl.h\
			src\sys-includes.h\
			src\webjob.h

OBJECTS			=\
			"$(OBJECT_DIR)\hook.obj"\
			"$(OBJECT_DIR)\http.obj"\
			"$(OBJECT_DIR)\properties.obj"\
			"$(OBJECT_DIR)\md5.obj"\
			"$(OBJECT_DIR)\sha1.obj"\
			"$(OBJECT_DIR)\socket.obj"\
!IF "$(USE_SSL)" == "Y" || "$(USE_SSL)" == "y"
			"$(OBJECT_DIR)\ssl.obj"\
!ENDIF
			"$(OBJECT_DIR)\webjob.obj"

EXECUTEABLE		= $(OBJECT_DIR)\webjob.exe

LINKER			= link.exe

LINKER_FLAGS		=\
			/nologo\
			/subsystem:console\
			/machine:I386\
			$(SSL_LINKER_FLAGS)\
			wsock32.lib\
			/out:"$(EXECUTEABLE)"\
			/pdb:"$(OBJECT_DIR)\webjob.pdb"\
!IF "$(BUILD_TYPE)" == "DEBUG" || "$(BUILD_TYPE)" == "debug"
			/incremental:yes\
			/debug\
			/pdbtype:sept
!ELSE
			/incremental:no
!ENDIF

all: "$(EXECUTEABLE)"

install: "$(EXECUTEABLE)"
	if not exist "$(INSTALL_DIR)" mkdir "$(INSTALL_DIR)"
	if not exist "$(INSTALL_DIR)\bin" mkdir "$(INSTALL_DIR)\bin"
!IF "$(USE_CGI)" == "Y" || "$(USE_CGI)" == "y"
	if not exist "$(INSTALL_DIR)\cgi" mkdir "$(INSTALL_DIR)\cgi"
	if not exist "$(INSTALL_DIR)\cgi\cgi-client" mkdir "$(INSTALL_DIR)\cgi\cgi-client"
!ENDIF
	if not exist "$(INSTALL_DIR)\doc" mkdir "$(INSTALL_DIR)\doc"
	if not exist "$(INSTALL_DIR)\etc" mkdir "$(INSTALL_DIR)\etc"
	if not exist "$(INSTALL_DIR)\log" mkdir "$(INSTALL_DIR)\log"
	if not exist "$(INSTALL_DIR)\run" mkdir "$(INSTALL_DIR)\run"
	copy "$(EXECUTEABLE)" "$(INSTALL_DIR)\bin"
!IF "$(USE_CGI)" == "Y" || "$(USE_CGI)" == "y"
	copy cgi\nph-webjob.cgi "$(INSTALL_DIR)\cgi\cgi-client"
!ENDIF
	copy doc\webjob.html "$(INSTALL_DIR)\doc"
	copy etc\webjob.cfg.sample "$(INSTALL_DIR)\etc"
!IF ("$(USE_SSL)" == "Y" || "$(USE_SSL)" == "y") && ("$(USE_STATIC_SSL_LIBS)" == "N" || "$(USE_STATIC_SSL_LIBS)" == "n")
	copy "$(SSL_DLL1)" "$(INSTALL_DIR)\bin"
	copy "$(SSL_DLL2)" "$(INSTALL_DIR)\bin"
!ENDIF

clean:
	if exist "$(OBJECT_DIR)" rd /Q /S "$(OBJECT_DIR)"

clean-all: clean

"$(EXECUTEABLE)": "$(OBJECT_DIR)" $(OBJECTS)
	$(LINKER) $(LINKER_FLAGS) $(OBJECTS)
!IF ("$(USE_SSL)" == "Y" || "$(USE_SSL)" == "y") && ("$(USE_STATIC_SSL_LIBS)" == "N" || "$(USE_STATIC_SSL_LIBS)" == "n")
	copy "$(SSL_DLL1)" "$(OBJECT_DIR)"
	copy "$(SSL_DLL2)" "$(OBJECT_DIR)"
!ENDIF

{$(SOURCE_DIR)}.c{$(OBJECT_DIR)}.obj::
	$(COMPILER) $(COMPILER_FLAGS) $<

"$(OBJECT_DIR)":
	if not exist "$(OBJECT_DIR)" mkdir "$(OBJECT_DIR)"

"$(OBJECT_DIR)\hook.obj": src\hook.c $(INCLUDES) "$(OBJECT_DIR)"

"$(OBJECT_DIR)\http.obj": src\http.c $(INCLUDES) "$(OBJECT_DIR)"

"$(OBJECT_DIR)\properties.obj": src\properties.c $(INCLUDES) "$(OBJECT_DIR)"

"$(OBJECT_DIR)\md5.obj": src\md5.c $(INCLUDES) "$(OBJECT_DIR)"

"$(OBJECT_DIR)\sha1.obj": src\sha1.c $(INCLUDES) "$(OBJECT_DIR)"

"$(OBJECT_DIR)\socket.obj": src\socket.c $(INCLUDES) "$(OBJECT_DIR)"

"$(OBJECT_DIR)\ssl.obj": src\ssl.c $(INCLUDES) "$(OBJECT_DIR)"

"$(OBJECT_DIR)\webjob.obj": src\webjob.c $(INCLUDES) "$(OBJECT_DIR)"

