#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include "web.h"

void rewrite_url(char * url, const char * path, const char * host, int port,
		 char * filename)
{
    char buf[256];

    if (url[0] == '/') { /* URL is an absolute reference within the site */
	/* see if we need to change the name referred to */
	filename = rename_object(host, port, url + 1, NULL);
        sprintf(buf, "%s/%s/%s:%d/%s", pszURLPrefix, path, host,port,filename);
	if (options.bVerbose >= 2) printf("rewriting %s => %s\n", url, buf);
	strcpy(url,buf);
    }
    else if (! strncmp(url, "http:", 5)) {
	char newhost[256], newfile[256];
	int  newport;

	if (SplitURL(url + 7, newhost, newfile, &newport))
	{
	    fprintf(stderr, "rewrite: invalid url (%s)\n", url);
	    return;
	}
	switch(options.cRewriteMode) {
	case 'a':
	    break;	/* always go through to do the rewrite */
	case 'l':
	    if (!strcmp(newhost,host)) break;
	    return;
	case 'f':
	    if (file_exists(path,newhost,newport,newfile)) break;
	    return;
	}

	if (options.bVerbose >= 2) printf("rewriting %s => ", url);

	filename = rename_object(newhost, newport, newfile, NULL);
	sprintf(url, "%s/%s/%s:%d/%s", pszURLPrefix, path, newhost,
		newport, filename);

	if (options.bVerbose >= 2) printf("%s\n", url);
    }
    else if (strchr(url, ':')) /* unsupported URL type */
    {
	/* do nothing */
    }	
    else /* relative URL */
    {
	char newhost[256], newpath[256];
	int newport;
	char * newpathrenamed;

	relative_url(url, host, port, filename, newhost, &newport, newpath, 
		     0xF00); /* magic to never prompt user! */
	
	/* rewrite only if rename_object changes the name */
	newpathrenamed = rename_object(newhost, newport, newpath, NULL);
	if (strcmp(newpathrenamed,newpath)) {
	    sprintf(buf, "%s/%s/%s:%d/%s", pszURLPrefix, path, newhost,
		    newport, newpathrenamed);
	    if (options.bVerbose >= 2) 
		printf("rewriting %s => %s\n", url, buf);
	    strcpy(url, buf);
	}
    }
}

void rewrite(char * path, const char * host, int port,
	     char * filename, xreflist * xr)
{
    char 	name[256];
    char	tmp[256];
    int		i, x;
    int		index;
    FILE	* ft, * fi;
    char	buf[256];
    
    filename = rename_object(host, port, filename, NULL);

    get_filename(path,host,port,filename,name,0);
    sprintf(tmp, "/tmp/web-rewrite.%d", getpid());
    ft = fopen(tmp, "w");
    if (!ft) {
	fprintf(stderr, "couldn't rewrite %s:%d/%s - can't open %s\n",
		host, port, filename, tmp);
	return;
    }
    fi = fopen(name, "r");
    if (!fi) {
	fprintf(stderr, "rewrite: couldn't open %s:%d/%s for rewrite...!\n",
		host, port, filename);
	fclose(ft);
	return;
    }
    if (options.bVerbose >= 4) 
	printf ("Rewriting %s:%d/%s :\n", host, port, filename);
    index = 0;
    for (i = 0; i < xr->nrefs; i++)
    {
	while (index < xr->startloc[i]) {
	    fputc(fgetc(fi), ft);
	    index++;
	}
	x = 0;
	while (index < xr->endloc[i]) {
	    buf[x++] = fgetc(fi);
	    index++;
	}
	buf[x] = 0;
	rewrite_url(buf, path, host, port, filename);
	fputs(buf, ft);
    }

    while ((i = fgetc(fi)) != EOF)
	fputc(i, ft);

    fclose(fi);
    fclose(ft);

    ft = fopen (tmp, "r");
    if (!ft) {
	fprintf(stderr, "couldn't re-open tmp file! changes lost!\n");
	return;
    }
    fi = fopen (name, "w");
    if (!fi) {
	fprintf(stderr, "couldn't overwrite destination file!"
		" changes lost!\n");
	fclose(ft);
	return;
    }

    while ((i = fgetc(ft)) != EOF)
	fputc(i, fi);

    fclose(ft);
    fclose(fi);
    if (options.bVerbose >= 4) printf ("Rewrite done\n\n");
}
